/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array that describes a data quality metric. Each <code>DataQualityMetric</code> object contains the data quality
 * metric name, its value, a description of the metric, and the affected column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityMetric.Builder, DataQualityMetric> {
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricType").getter(getter(DataQualityMetric::metricTypeAsString)).setter(setter(Builder::metricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricType").build()).build();

    private static final SdkField<String> METRIC_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricDescription").getter(getter(DataQualityMetric::metricDescription))
            .setter(setter(Builder::metricDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDescription").build()).build();

    private static final SdkField<String> RELATED_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedColumnName").getter(getter(DataQualityMetric::relatedColumnName))
            .setter(setter(Builder::relatedColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedColumnName").build()).build();

    private static final SdkField<Double> METRIC_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MetricValue").getter(getter(DataQualityMetric::metricValue)).setter(setter(Builder::metricValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_TYPE_FIELD,
            METRIC_DESCRIPTION_FIELD, RELATED_COLUMN_NAME_FIELD, METRIC_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricType;

    private final String metricDescription;

    private final String relatedColumnName;

    private final Double metricValue;

    private DataQualityMetric(BuilderImpl builder) {
        this.metricType = builder.metricType;
        this.metricDescription = builder.metricDescription;
        this.relatedColumnName = builder.relatedColumnName;
        this.metricValue = builder.metricValue;
    }

    /**
     * <p>
     * The name of the data quality metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link DataQualityMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The name of the data quality metric.
     * @see DataQualityMetricType
     */
    public final DataQualityMetricType metricType() {
        return DataQualityMetricType.fromValue(metricType);
    }

    /**
     * <p>
     * The name of the data quality metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricType} will
     * return {@link DataQualityMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metricTypeAsString}.
     * </p>
     * 
     * @return The name of the data quality metric.
     * @see DataQualityMetricType
     */
    public final String metricTypeAsString() {
        return metricType;
    }

    /**
     * <p>
     * A description of the data quality metric.
     * </p>
     * 
     * @return A description of the data quality metric.
     */
    public final String metricDescription() {
        return metricDescription;
    }

    /**
     * <p>
     * The column that is being monitored.
     * </p>
     * 
     * @return The column that is being monitored.
     */
    public final String relatedColumnName() {
        return relatedColumnName;
    }

    /**
     * <p>
     * The value of the data quality metric.
     * </p>
     * 
     * @return The value of the data quality metric.
     */
    public final Double metricValue() {
        return metricValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricDescription());
        hashCode = 31 * hashCode + Objects.hashCode(relatedColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityMetric)) {
            return false;
        }
        DataQualityMetric other = (DataQualityMetric) obj;
        return Objects.equals(metricTypeAsString(), other.metricTypeAsString())
                && Objects.equals(metricDescription(), other.metricDescription())
                && Objects.equals(relatedColumnName(), other.relatedColumnName())
                && Objects.equals(metricValue(), other.metricValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityMetric").add("MetricType", metricTypeAsString())
                .add("MetricDescription", metricDescription()).add("RelatedColumnName", relatedColumnName())
                .add("MetricValue", metricValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricType":
            return Optional.ofNullable(clazz.cast(metricTypeAsString()));
        case "MetricDescription":
            return Optional.ofNullable(clazz.cast(metricDescription()));
        case "RelatedColumnName":
            return Optional.ofNullable(clazz.cast(relatedColumnName()));
        case "MetricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityMetric, T> g) {
        return obj -> g.apply((DataQualityMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityMetric> {
        /**
         * <p>
         * The name of the data quality metric.
         * </p>
         * 
         * @param metricType
         *        The name of the data quality metric.
         * @see DataQualityMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataQualityMetricType
         */
        Builder metricType(String metricType);

        /**
         * <p>
         * The name of the data quality metric.
         * </p>
         * 
         * @param metricType
         *        The name of the data quality metric.
         * @see DataQualityMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataQualityMetricType
         */
        Builder metricType(DataQualityMetricType metricType);

        /**
         * <p>
         * A description of the data quality metric.
         * </p>
         * 
         * @param metricDescription
         *        A description of the data quality metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDescription(String metricDescription);

        /**
         * <p>
         * The column that is being monitored.
         * </p>
         * 
         * @param relatedColumnName
         *        The column that is being monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedColumnName(String relatedColumnName);

        /**
         * <p>
         * The value of the data quality metric.
         * </p>
         * 
         * @param metricValue
         *        The value of the data quality metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(Double metricValue);
    }

    static final class BuilderImpl implements Builder {
        private String metricType;

        private String metricDescription;

        private String relatedColumnName;

        private Double metricValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityMetric model) {
            metricType(model.metricType);
            metricDescription(model.metricDescription);
            relatedColumnName(model.relatedColumnName);
            metricValue(model.metricValue);
        }

        public final String getMetricType() {
            return metricType;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(DataQualityMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final String getMetricDescription() {
            return metricDescription;
        }

        public final void setMetricDescription(String metricDescription) {
            this.metricDescription = metricDescription;
        }

        @Override
        public final Builder metricDescription(String metricDescription) {
            this.metricDescription = metricDescription;
            return this;
        }

        public final String getRelatedColumnName() {
            return relatedColumnName;
        }

        public final void setRelatedColumnName(String relatedColumnName) {
            this.relatedColumnName = relatedColumnName;
        }

        @Override
        public final Builder relatedColumnName(String relatedColumnName) {
            this.relatedColumnName = relatedColumnName;
            return this;
        }

        public final Double getMetricValue() {
            return metricValue;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        @Override
        public DataQualityMetric build() {
            return new DataQualityMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
