/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.m2.model.M2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentRequest
extends M2Request
implements ToCopyableBuilder<Builder, UpdateEnvironmentRequest> {
    private static final SdkField<Boolean> APPLY_DURING_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("applyDuringMaintenanceWindow").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::applyDuringMaintenanceWindow)).setter(UpdateEnvironmentRequest.setter(Builder::applyDuringMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyDuringMaintenanceWindow").build()}).build();
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredCapacity").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::desiredCapacity)).setter(UpdateEnvironmentRequest.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCapacity").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engineVersion").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::engineVersion)).setter(UpdateEnvironmentRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::environmentId)).setter(UpdateEnvironmentRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<Boolean> FORCE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("forceUpdate").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::forceUpdate)).setter(UpdateEnvironmentRequest.setter(Builder::forceUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceUpdate").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::instanceType)).setter(UpdateEnvironmentRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredMaintenanceWindow").getter(UpdateEnvironmentRequest.getter(UpdateEnvironmentRequest::preferredMaintenanceWindow)).setter(UpdateEnvironmentRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLY_DURING_MAINTENANCE_WINDOW_FIELD, DESIRED_CAPACITY_FIELD, ENGINE_VERSION_FIELD, ENVIRONMENT_ID_FIELD, FORCE_UPDATE_FIELD, INSTANCE_TYPE_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEnvironmentRequest.memberNameToFieldInitializer();
    private final Boolean applyDuringMaintenanceWindow;
    private final Integer desiredCapacity;
    private final String engineVersion;
    private final String environmentId;
    private final Boolean forceUpdate;
    private final String instanceType;
    private final String preferredMaintenanceWindow;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.applyDuringMaintenanceWindow = builder.applyDuringMaintenanceWindow;
        this.desiredCapacity = builder.desiredCapacity;
        this.engineVersion = builder.engineVersion;
        this.environmentId = builder.environmentId;
        this.forceUpdate = builder.forceUpdate;
        this.instanceType = builder.instanceType;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
    }

    public final Boolean applyDuringMaintenanceWindow() {
        return this.applyDuringMaintenanceWindow;
    }

    public final Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final Boolean forceUpdate() {
        return this.forceUpdate;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applyDuringMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.applyDuringMaintenanceWindow(), other.applyDuringMaintenanceWindow()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.forceUpdate(), other.forceUpdate()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnvironmentRequest").add("ApplyDuringMaintenanceWindow", (Object)this.applyDuringMaintenanceWindow()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("EngineVersion", (Object)this.engineVersion()).add("EnvironmentId", (Object)this.environmentId()).add("ForceUpdate", (Object)this.forceUpdate()).add("InstanceType", (Object)this.instanceType()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applyDuringMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.applyDuringMaintenanceWindow()));
            }
            case "desiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "forceUpdate": {
                return Optional.ofNullable(clazz.cast(this.forceUpdate()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "preferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applyDuringMaintenanceWindow", APPLY_DURING_MAINTENANCE_WINDOW_FIELD);
        map.put("desiredCapacity", DESIRED_CAPACITY_FIELD);
        map.put("engineVersion", ENGINE_VERSION_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("forceUpdate", FORCE_UPDATE_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("preferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends M2Request.BuilderImpl
    implements Builder {
        private Boolean applyDuringMaintenanceWindow;
        private Integer desiredCapacity;
        private String engineVersion;
        private String environmentId;
        private Boolean forceUpdate;
        private String instanceType;
        private String preferredMaintenanceWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            this.applyDuringMaintenanceWindow(model.applyDuringMaintenanceWindow);
            this.desiredCapacity(model.desiredCapacity);
            this.engineVersion(model.engineVersion);
            this.environmentId(model.environmentId);
            this.forceUpdate(model.forceUpdate);
            this.instanceType(model.instanceType);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
        }

        public final Boolean getApplyDuringMaintenanceWindow() {
            return this.applyDuringMaintenanceWindow;
        }

        public final void setApplyDuringMaintenanceWindow(Boolean applyDuringMaintenanceWindow) {
            this.applyDuringMaintenanceWindow = applyDuringMaintenanceWindow;
        }

        @Override
        public final Builder applyDuringMaintenanceWindow(Boolean applyDuringMaintenanceWindow) {
            this.applyDuringMaintenanceWindow = applyDuringMaintenanceWindow;
            return this;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Boolean getForceUpdate() {
            return this.forceUpdate;
        }

        public final void setForceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
        }

        @Override
        public final Builder forceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends M2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        public Builder applyDuringMaintenanceWindow(Boolean var1);

        public Builder desiredCapacity(Integer var1);

        public Builder engineVersion(String var1);

        public Builder environmentId(String var1);

        public Builder forceUpdate(Boolean var1);

        public Builder instanceType(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

