/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.m2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.m2.M2AsyncClient;
import software.amazon.awssdk.services.m2.internal.UserAgentUtils;
import software.amazon.awssdk.services.m2.model.DataSetExportTask;
import software.amazon.awssdk.services.m2.model.ListDataSetExportHistoryRequest;
import software.amazon.awssdk.services.m2.model.ListDataSetExportHistoryResponse;

public class ListDataSetExportHistoryPublisher
implements SdkPublisher<ListDataSetExportHistoryResponse> {
    private final M2AsyncClient client;
    private final ListDataSetExportHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSetExportHistoryPublisher(M2AsyncClient client, ListDataSetExportHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSetExportHistoryPublisher(M2AsyncClient client, ListDataSetExportHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSetExportHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSetExportHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataSetExportTask> dataSetExportTasks() {
        Function<ListDataSetExportHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSetExportTasks() != null) {
                return response.dataSetExportTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataSetExportHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataSetExportHistoryResponseFetcher
    implements AsyncPageFetcher<ListDataSetExportHistoryResponse> {
        private ListDataSetExportHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetExportHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSetExportHistoryResponse> nextPage(ListDataSetExportHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetExportHistoryPublisher.this.client.listDataSetExportHistory(ListDataSetExportHistoryPublisher.this.firstRequest);
            }
            return ListDataSetExportHistoryPublisher.this.client.listDataSetExportHistory((ListDataSetExportHistoryRequest)((Object)ListDataSetExportHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

