/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceStatistics> {
    private static final SdkField<Long> TOTAL_BYTES_CLASSIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalBytesClassified").getter(ResourceStatistics.getter(ResourceStatistics::totalBytesClassified)).setter(ResourceStatistics.setter(Builder::totalBytesClassified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBytesClassified").build()}).build();
    private static final SdkField<Long> TOTAL_DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalDetections").getter(ResourceStatistics.getter(ResourceStatistics::totalDetections)).setter(ResourceStatistics.setter(Builder::totalDetections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDetections").build()}).build();
    private static final SdkField<Long> TOTAL_DETECTIONS_SUPPRESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalDetectionsSuppressed").getter(ResourceStatistics.getter(ResourceStatistics::totalDetectionsSuppressed)).setter(ResourceStatistics.setter(Builder::totalDetectionsSuppressed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDetectionsSuppressed").build()}).build();
    private static final SdkField<Long> TOTAL_ITEMS_CLASSIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalItemsClassified").getter(ResourceStatistics.getter(ResourceStatistics::totalItemsClassified)).setter(ResourceStatistics.setter(Builder::totalItemsClassified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsClassified").build()}).build();
    private static final SdkField<Long> TOTAL_ITEMS_SENSITIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalItemsSensitive").getter(ResourceStatistics.getter(ResourceStatistics::totalItemsSensitive)).setter(ResourceStatistics.setter(Builder::totalItemsSensitive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSensitive").build()}).build();
    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalItemsSkipped").getter(ResourceStatistics.getter(ResourceStatistics::totalItemsSkipped)).setter(ResourceStatistics.setter(Builder::totalItemsSkipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkipped").build()}).build();
    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_INVALID_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalItemsSkippedInvalidEncryption").getter(ResourceStatistics.getter(ResourceStatistics::totalItemsSkippedInvalidEncryption)).setter(ResourceStatistics.setter(Builder::totalItemsSkippedInvalidEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkippedInvalidEncryption").build()}).build();
    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_INVALID_KMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalItemsSkippedInvalidKms").getter(ResourceStatistics.getter(ResourceStatistics::totalItemsSkippedInvalidKms)).setter(ResourceStatistics.setter(Builder::totalItemsSkippedInvalidKms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkippedInvalidKms").build()}).build();
    private static final SdkField<Long> TOTAL_ITEMS_SKIPPED_PERMISSION_DENIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalItemsSkippedPermissionDenied").getter(ResourceStatistics.getter(ResourceStatistics::totalItemsSkippedPermissionDenied)).setter(ResourceStatistics.setter(Builder::totalItemsSkippedPermissionDenied)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalItemsSkippedPermissionDenied").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_BYTES_CLASSIFIED_FIELD, TOTAL_DETECTIONS_FIELD, TOTAL_DETECTIONS_SUPPRESSED_FIELD, TOTAL_ITEMS_CLASSIFIED_FIELD, TOTAL_ITEMS_SENSITIVE_FIELD, TOTAL_ITEMS_SKIPPED_FIELD, TOTAL_ITEMS_SKIPPED_INVALID_ENCRYPTION_FIELD, TOTAL_ITEMS_SKIPPED_INVALID_KMS_FIELD, TOTAL_ITEMS_SKIPPED_PERMISSION_DENIED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long totalBytesClassified;
    private final Long totalDetections;
    private final Long totalDetectionsSuppressed;
    private final Long totalItemsClassified;
    private final Long totalItemsSensitive;
    private final Long totalItemsSkipped;
    private final Long totalItemsSkippedInvalidEncryption;
    private final Long totalItemsSkippedInvalidKms;
    private final Long totalItemsSkippedPermissionDenied;

    private ResourceStatistics(BuilderImpl builder) {
        this.totalBytesClassified = builder.totalBytesClassified;
        this.totalDetections = builder.totalDetections;
        this.totalDetectionsSuppressed = builder.totalDetectionsSuppressed;
        this.totalItemsClassified = builder.totalItemsClassified;
        this.totalItemsSensitive = builder.totalItemsSensitive;
        this.totalItemsSkipped = builder.totalItemsSkipped;
        this.totalItemsSkippedInvalidEncryption = builder.totalItemsSkippedInvalidEncryption;
        this.totalItemsSkippedInvalidKms = builder.totalItemsSkippedInvalidKms;
        this.totalItemsSkippedPermissionDenied = builder.totalItemsSkippedPermissionDenied;
    }

    public final Long totalBytesClassified() {
        return this.totalBytesClassified;
    }

    public final Long totalDetections() {
        return this.totalDetections;
    }

    public final Long totalDetectionsSuppressed() {
        return this.totalDetectionsSuppressed;
    }

    public final Long totalItemsClassified() {
        return this.totalItemsClassified;
    }

    public final Long totalItemsSensitive() {
        return this.totalItemsSensitive;
    }

    public final Long totalItemsSkipped() {
        return this.totalItemsSkipped;
    }

    public final Long totalItemsSkippedInvalidEncryption() {
        return this.totalItemsSkippedInvalidEncryption;
    }

    public final Long totalItemsSkippedInvalidKms() {
        return this.totalItemsSkippedInvalidKms;
    }

    public final Long totalItemsSkippedPermissionDenied() {
        return this.totalItemsSkippedPermissionDenied;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBytesClassified());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDetections());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDetectionsSuppressed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalItemsClassified());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalItemsSensitive());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalItemsSkipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalItemsSkippedInvalidEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalItemsSkippedInvalidKms());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalItemsSkippedPermissionDenied());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceStatistics)) {
            return false;
        }
        ResourceStatistics other = (ResourceStatistics)obj;
        return Objects.equals(this.totalBytesClassified(), other.totalBytesClassified()) && Objects.equals(this.totalDetections(), other.totalDetections()) && Objects.equals(this.totalDetectionsSuppressed(), other.totalDetectionsSuppressed()) && Objects.equals(this.totalItemsClassified(), other.totalItemsClassified()) && Objects.equals(this.totalItemsSensitive(), other.totalItemsSensitive()) && Objects.equals(this.totalItemsSkipped(), other.totalItemsSkipped()) && Objects.equals(this.totalItemsSkippedInvalidEncryption(), other.totalItemsSkippedInvalidEncryption()) && Objects.equals(this.totalItemsSkippedInvalidKms(), other.totalItemsSkippedInvalidKms()) && Objects.equals(this.totalItemsSkippedPermissionDenied(), other.totalItemsSkippedPermissionDenied());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceStatistics").add("TotalBytesClassified", (Object)this.totalBytesClassified()).add("TotalDetections", (Object)this.totalDetections()).add("TotalDetectionsSuppressed", (Object)this.totalDetectionsSuppressed()).add("TotalItemsClassified", (Object)this.totalItemsClassified()).add("TotalItemsSensitive", (Object)this.totalItemsSensitive()).add("TotalItemsSkipped", (Object)this.totalItemsSkipped()).add("TotalItemsSkippedInvalidEncryption", (Object)this.totalItemsSkippedInvalidEncryption()).add("TotalItemsSkippedInvalidKms", (Object)this.totalItemsSkippedInvalidKms()).add("TotalItemsSkippedPermissionDenied", (Object)this.totalItemsSkippedPermissionDenied()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalBytesClassified": {
                return Optional.ofNullable(clazz.cast(this.totalBytesClassified()));
            }
            case "totalDetections": {
                return Optional.ofNullable(clazz.cast(this.totalDetections()));
            }
            case "totalDetectionsSuppressed": {
                return Optional.ofNullable(clazz.cast(this.totalDetectionsSuppressed()));
            }
            case "totalItemsClassified": {
                return Optional.ofNullable(clazz.cast(this.totalItemsClassified()));
            }
            case "totalItemsSensitive": {
                return Optional.ofNullable(clazz.cast(this.totalItemsSensitive()));
            }
            case "totalItemsSkipped": {
                return Optional.ofNullable(clazz.cast(this.totalItemsSkipped()));
            }
            case "totalItemsSkippedInvalidEncryption": {
                return Optional.ofNullable(clazz.cast(this.totalItemsSkippedInvalidEncryption()));
            }
            case "totalItemsSkippedInvalidKms": {
                return Optional.ofNullable(clazz.cast(this.totalItemsSkippedInvalidKms()));
            }
            case "totalItemsSkippedPermissionDenied": {
                return Optional.ofNullable(clazz.cast(this.totalItemsSkippedPermissionDenied()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceStatistics, T> g) {
        return obj -> g.apply((ResourceStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalBytesClassified;
        private Long totalDetections;
        private Long totalDetectionsSuppressed;
        private Long totalItemsClassified;
        private Long totalItemsSensitive;
        private Long totalItemsSkipped;
        private Long totalItemsSkippedInvalidEncryption;
        private Long totalItemsSkippedInvalidKms;
        private Long totalItemsSkippedPermissionDenied;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceStatistics model) {
            this.totalBytesClassified(model.totalBytesClassified);
            this.totalDetections(model.totalDetections);
            this.totalDetectionsSuppressed(model.totalDetectionsSuppressed);
            this.totalItemsClassified(model.totalItemsClassified);
            this.totalItemsSensitive(model.totalItemsSensitive);
            this.totalItemsSkipped(model.totalItemsSkipped);
            this.totalItemsSkippedInvalidEncryption(model.totalItemsSkippedInvalidEncryption);
            this.totalItemsSkippedInvalidKms(model.totalItemsSkippedInvalidKms);
            this.totalItemsSkippedPermissionDenied(model.totalItemsSkippedPermissionDenied);
        }

        public final Long getTotalBytesClassified() {
            return this.totalBytesClassified;
        }

        public final void setTotalBytesClassified(Long totalBytesClassified) {
            this.totalBytesClassified = totalBytesClassified;
        }

        @Override
        public final Builder totalBytesClassified(Long totalBytesClassified) {
            this.totalBytesClassified = totalBytesClassified;
            return this;
        }

        public final Long getTotalDetections() {
            return this.totalDetections;
        }

        public final void setTotalDetections(Long totalDetections) {
            this.totalDetections = totalDetections;
        }

        @Override
        public final Builder totalDetections(Long totalDetections) {
            this.totalDetections = totalDetections;
            return this;
        }

        public final Long getTotalDetectionsSuppressed() {
            return this.totalDetectionsSuppressed;
        }

        public final void setTotalDetectionsSuppressed(Long totalDetectionsSuppressed) {
            this.totalDetectionsSuppressed = totalDetectionsSuppressed;
        }

        @Override
        public final Builder totalDetectionsSuppressed(Long totalDetectionsSuppressed) {
            this.totalDetectionsSuppressed = totalDetectionsSuppressed;
            return this;
        }

        public final Long getTotalItemsClassified() {
            return this.totalItemsClassified;
        }

        public final void setTotalItemsClassified(Long totalItemsClassified) {
            this.totalItemsClassified = totalItemsClassified;
        }

        @Override
        public final Builder totalItemsClassified(Long totalItemsClassified) {
            this.totalItemsClassified = totalItemsClassified;
            return this;
        }

        public final Long getTotalItemsSensitive() {
            return this.totalItemsSensitive;
        }

        public final void setTotalItemsSensitive(Long totalItemsSensitive) {
            this.totalItemsSensitive = totalItemsSensitive;
        }

        @Override
        public final Builder totalItemsSensitive(Long totalItemsSensitive) {
            this.totalItemsSensitive = totalItemsSensitive;
            return this;
        }

        public final Long getTotalItemsSkipped() {
            return this.totalItemsSkipped;
        }

        public final void setTotalItemsSkipped(Long totalItemsSkipped) {
            this.totalItemsSkipped = totalItemsSkipped;
        }

        @Override
        public final Builder totalItemsSkipped(Long totalItemsSkipped) {
            this.totalItemsSkipped = totalItemsSkipped;
            return this;
        }

        public final Long getTotalItemsSkippedInvalidEncryption() {
            return this.totalItemsSkippedInvalidEncryption;
        }

        public final void setTotalItemsSkippedInvalidEncryption(Long totalItemsSkippedInvalidEncryption) {
            this.totalItemsSkippedInvalidEncryption = totalItemsSkippedInvalidEncryption;
        }

        @Override
        public final Builder totalItemsSkippedInvalidEncryption(Long totalItemsSkippedInvalidEncryption) {
            this.totalItemsSkippedInvalidEncryption = totalItemsSkippedInvalidEncryption;
            return this;
        }

        public final Long getTotalItemsSkippedInvalidKms() {
            return this.totalItemsSkippedInvalidKms;
        }

        public final void setTotalItemsSkippedInvalidKms(Long totalItemsSkippedInvalidKms) {
            this.totalItemsSkippedInvalidKms = totalItemsSkippedInvalidKms;
        }

        @Override
        public final Builder totalItemsSkippedInvalidKms(Long totalItemsSkippedInvalidKms) {
            this.totalItemsSkippedInvalidKms = totalItemsSkippedInvalidKms;
            return this;
        }

        public final Long getTotalItemsSkippedPermissionDenied() {
            return this.totalItemsSkippedPermissionDenied;
        }

        public final void setTotalItemsSkippedPermissionDenied(Long totalItemsSkippedPermissionDenied) {
            this.totalItemsSkippedPermissionDenied = totalItemsSkippedPermissionDenied;
        }

        @Override
        public final Builder totalItemsSkippedPermissionDenied(Long totalItemsSkippedPermissionDenied) {
            this.totalItemsSkippedPermissionDenied = totalItemsSkippedPermissionDenied;
            return this;
        }

        public ResourceStatistics build() {
            return new ResourceStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceStatistics> {
        public Builder totalBytesClassified(Long var1);

        public Builder totalDetections(Long var1);

        public Builder totalDetectionsSuppressed(Long var1);

        public Builder totalItemsClassified(Long var1);

        public Builder totalItemsSensitive(Long var1);

        public Builder totalItemsSkipped(Long var1);

        public Builder totalItemsSkippedInvalidEncryption(Long var1);

        public Builder totalItemsSkippedInvalidKms(Long var1);

        public Builder totalItemsSkippedPermissionDenied(Long var1);
    }
}

