/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.SuppressDataIdentifier;
import software.amazon.awssdk.services.macie2.model.___listOfSuppressDataIdentifierCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceProfileDetectionsRequest
extends Macie2Request
implements ToCopyableBuilder<Builder, UpdateResourceProfileDetectionsRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(UpdateResourceProfileDetectionsRequest.getter(UpdateResourceProfileDetectionsRequest::resourceArn)).setter(UpdateResourceProfileDetectionsRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()}).build();
    private static final SdkField<List<SuppressDataIdentifier>> SUPPRESS_DATA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suppressDataIdentifiers").getter(UpdateResourceProfileDetectionsRequest.getter(UpdateResourceProfileDetectionsRequest::suppressDataIdentifiers)).setter(UpdateResourceProfileDetectionsRequest.setter(Builder::suppressDataIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressDataIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuppressDataIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SUPPRESS_DATA_IDENTIFIERS_FIELD));
    private final String resourceArn;
    private final List<SuppressDataIdentifier> suppressDataIdentifiers;

    private UpdateResourceProfileDetectionsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.suppressDataIdentifiers = builder.suppressDataIdentifiers;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasSuppressDataIdentifiers() {
        return this.suppressDataIdentifiers != null && !(this.suppressDataIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<SuppressDataIdentifier> suppressDataIdentifiers() {
        return this.suppressDataIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuppressDataIdentifiers() ? this.suppressDataIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceProfileDetectionsRequest)) {
            return false;
        }
        UpdateResourceProfileDetectionsRequest other = (UpdateResourceProfileDetectionsRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasSuppressDataIdentifiers() == other.hasSuppressDataIdentifiers() && Objects.equals(this.suppressDataIdentifiers(), other.suppressDataIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceProfileDetectionsRequest").add("ResourceArn", (Object)this.resourceArn()).add("SuppressDataIdentifiers", this.hasSuppressDataIdentifiers() ? this.suppressDataIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "suppressDataIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.suppressDataIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceProfileDetectionsRequest, T> g) {
        return obj -> g.apply((UpdateResourceProfileDetectionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Request.BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<SuppressDataIdentifier> suppressDataIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceProfileDetectionsRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.suppressDataIdentifiers(model.suppressDataIdentifiers);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<SuppressDataIdentifier.Builder> getSuppressDataIdentifiers() {
            List<SuppressDataIdentifier.Builder> result = ___listOfSuppressDataIdentifierCopier.copyToBuilder(this.suppressDataIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuppressDataIdentifiers(Collection<SuppressDataIdentifier.BuilderImpl> suppressDataIdentifiers) {
            this.suppressDataIdentifiers = ___listOfSuppressDataIdentifierCopier.copyFromBuilder(suppressDataIdentifiers);
        }

        @Override
        public final Builder suppressDataIdentifiers(Collection<SuppressDataIdentifier> suppressDataIdentifiers) {
            this.suppressDataIdentifiers = ___listOfSuppressDataIdentifierCopier.copy(suppressDataIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressDataIdentifiers(SuppressDataIdentifier ... suppressDataIdentifiers) {
            this.suppressDataIdentifiers(Arrays.asList(suppressDataIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressDataIdentifiers(Consumer<SuppressDataIdentifier.Builder> ... suppressDataIdentifiers) {
            this.suppressDataIdentifiers(Stream.of(suppressDataIdentifiers).map(c -> (SuppressDataIdentifier)((SuppressDataIdentifier.Builder)SuppressDataIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceProfileDetectionsRequest build() {
            return new UpdateResourceProfileDetectionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceProfileDetectionsRequest> {
        public Builder resourceArn(String var1);

        public Builder suppressDataIdentifiers(Collection<SuppressDataIdentifier> var1);

        public Builder suppressDataIdentifiers(SuppressDataIdentifier ... var1);

        public Builder suppressDataIdentifiers(Consumer<SuppressDataIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

