/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TokenIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TokenIdentifier> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(TokenIdentifier.getter(TokenIdentifier::networkAsString)).setter(TokenIdentifier.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<String> CONTRACT_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contractAddress").getter(TokenIdentifier.getter(TokenIdentifier::contractAddress)).setter(TokenIdentifier.setter(Builder::contractAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractAddress").build()}).build();
    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenId").getter(TokenIdentifier.getter(TokenIdentifier::tokenId)).setter(TokenIdentifier.setter(Builder::tokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD, CONTRACT_ADDRESS_FIELD, TOKEN_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String network;
    private final String contractAddress;
    private final String tokenId;

    private TokenIdentifier(BuilderImpl builder) {
        this.network = builder.network;
        this.contractAddress = builder.contractAddress;
        this.tokenId = builder.tokenId;
    }

    public final QueryNetwork network() {
        return QueryNetwork.fromValue(this.network);
    }

    public final String networkAsString() {
        return this.network;
    }

    public final String contractAddress() {
        return this.contractAddress;
    }

    public final String tokenId() {
        return this.tokenId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contractAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenIdentifier)) {
            return false;
        }
        TokenIdentifier other = (TokenIdentifier)obj;
        return Objects.equals(this.networkAsString(), other.networkAsString()) && Objects.equals(this.contractAddress(), other.contractAddress()) && Objects.equals(this.tokenId(), other.tokenId());
    }

    public final String toString() {
        return ToString.builder((String)"TokenIdentifier").add("Network", (Object)this.networkAsString()).add("ContractAddress", (Object)this.contractAddress()).add("TokenId", (Object)this.tokenId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "network": {
                return Optional.ofNullable(clazz.cast(this.networkAsString()));
            }
            case "contractAddress": {
                return Optional.ofNullable(clazz.cast(this.contractAddress()));
            }
            case "tokenId": {
                return Optional.ofNullable(clazz.cast(this.tokenId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TokenIdentifier, T> g) {
        return obj -> g.apply((TokenIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String network;
        private String contractAddress;
        private String tokenId;

        private BuilderImpl() {
        }

        private BuilderImpl(TokenIdentifier model) {
            this.network(model.network);
            this.contractAddress(model.contractAddress);
            this.tokenId(model.tokenId);
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getContractAddress() {
            return this.contractAddress;
        }

        public final void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        @Override
        public final Builder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public final String getTokenId() {
            return this.tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public TokenIdentifier build() {
            return new TokenIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TokenIdentifier> {
        public Builder network(String var1);

        public Builder network(QueryNetwork var1);

        public Builder contractAddress(String var1);

        public Builder tokenId(String var1);
    }
}

