/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant;
import software.amazon.awssdk.services.managedblockchainquery.model.ErrorType;
import software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier;
import software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTokenBalanceErrorItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetTokenBalanceErrorItem> {
    private static final SdkField<TokenIdentifier> TOKEN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tokenIdentifier").getter(BatchGetTokenBalanceErrorItem.getter(BatchGetTokenBalanceErrorItem::tokenIdentifier)).setter(BatchGetTokenBalanceErrorItem.setter(Builder::tokenIdentifier)).constructor(TokenIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenIdentifier").build()}).build();
    private static final SdkField<OwnerIdentifier> OWNER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ownerIdentifier").getter(BatchGetTokenBalanceErrorItem.getter(BatchGetTokenBalanceErrorItem::ownerIdentifier)).setter(BatchGetTokenBalanceErrorItem.setter(Builder::ownerIdentifier)).constructor(OwnerIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerIdentifier").build()}).build();
    private static final SdkField<BlockchainInstant> AT_BLOCKCHAIN_INSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("atBlockchainInstant").getter(BatchGetTokenBalanceErrorItem.getter(BatchGetTokenBalanceErrorItem::atBlockchainInstant)).setter(BatchGetTokenBalanceErrorItem.setter(Builder::atBlockchainInstant)).constructor(BlockchainInstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atBlockchainInstant").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(BatchGetTokenBalanceErrorItem.getter(BatchGetTokenBalanceErrorItem::errorCode)).setter(BatchGetTokenBalanceErrorItem.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(BatchGetTokenBalanceErrorItem.getter(BatchGetTokenBalanceErrorItem::errorMessage)).setter(BatchGetTokenBalanceErrorItem.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorType").getter(BatchGetTokenBalanceErrorItem.getter(BatchGetTokenBalanceErrorItem::errorTypeAsString)).setter(BatchGetTokenBalanceErrorItem.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_IDENTIFIER_FIELD, OWNER_IDENTIFIER_FIELD, AT_BLOCKCHAIN_INSTANT_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, ERROR_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetTokenBalanceErrorItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TokenIdentifier tokenIdentifier;
    private final OwnerIdentifier ownerIdentifier;
    private final BlockchainInstant atBlockchainInstant;
    private final String errorCode;
    private final String errorMessage;
    private final String errorType;

    private BatchGetTokenBalanceErrorItem(BuilderImpl builder) {
        this.tokenIdentifier = builder.tokenIdentifier;
        this.ownerIdentifier = builder.ownerIdentifier;
        this.atBlockchainInstant = builder.atBlockchainInstant;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.errorType = builder.errorType;
    }

    public final TokenIdentifier tokenIdentifier() {
        return this.tokenIdentifier;
    }

    public final OwnerIdentifier ownerIdentifier() {
        return this.ownerIdentifier;
    }

    public final BlockchainInstant atBlockchainInstant() {
        return this.atBlockchainInstant;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final ErrorType errorType() {
        return ErrorType.fromValue(this.errorType);
    }

    public final String errorTypeAsString() {
        return this.errorType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.atBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTokenBalanceErrorItem)) {
            return false;
        }
        BatchGetTokenBalanceErrorItem other = (BatchGetTokenBalanceErrorItem)obj;
        return Objects.equals(this.tokenIdentifier(), other.tokenIdentifier()) && Objects.equals(this.ownerIdentifier(), other.ownerIdentifier()) && Objects.equals(this.atBlockchainInstant(), other.atBlockchainInstant()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.errorTypeAsString(), other.errorTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTokenBalanceErrorItem").add("TokenIdentifier", (Object)this.tokenIdentifier()).add("OwnerIdentifier", (Object)this.ownerIdentifier()).add("AtBlockchainInstant", (Object)this.atBlockchainInstant()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("ErrorType", (Object)this.errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tokenIdentifier": {
                return Optional.ofNullable(clazz.cast(this.tokenIdentifier()));
            }
            case "ownerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ownerIdentifier()));
            }
            case "atBlockchainInstant": {
                return Optional.ofNullable(clazz.cast(this.atBlockchainInstant()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "errorType": {
                return Optional.ofNullable(clazz.cast(this.errorTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tokenIdentifier", TOKEN_IDENTIFIER_FIELD);
        map.put("ownerIdentifier", OWNER_IDENTIFIER_FIELD);
        map.put("atBlockchainInstant", AT_BLOCKCHAIN_INSTANT_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTokenBalanceErrorItem, T> g) {
        return obj -> g.apply((BatchGetTokenBalanceErrorItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TokenIdentifier tokenIdentifier;
        private OwnerIdentifier ownerIdentifier;
        private BlockchainInstant atBlockchainInstant;
        private String errorCode;
        private String errorMessage;
        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTokenBalanceErrorItem model) {
            this.tokenIdentifier(model.tokenIdentifier);
            this.ownerIdentifier(model.ownerIdentifier);
            this.atBlockchainInstant(model.atBlockchainInstant);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.errorType(model.errorType);
        }

        public final TokenIdentifier.Builder getTokenIdentifier() {
            return this.tokenIdentifier != null ? this.tokenIdentifier.toBuilder() : null;
        }

        public final void setTokenIdentifier(TokenIdentifier.BuilderImpl tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier != null ? tokenIdentifier.build() : null;
        }

        @Override
        public final Builder tokenIdentifier(TokenIdentifier tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        public final OwnerIdentifier.Builder getOwnerIdentifier() {
            return this.ownerIdentifier != null ? this.ownerIdentifier.toBuilder() : null;
        }

        public final void setOwnerIdentifier(OwnerIdentifier.BuilderImpl ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier != null ? ownerIdentifier.build() : null;
        }

        @Override
        public final Builder ownerIdentifier(OwnerIdentifier ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier;
            return this;
        }

        public final BlockchainInstant.Builder getAtBlockchainInstant() {
            return this.atBlockchainInstant != null ? this.atBlockchainInstant.toBuilder() : null;
        }

        public final void setAtBlockchainInstant(BlockchainInstant.BuilderImpl atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant != null ? atBlockchainInstant.build() : null;
        }

        @Override
        public final Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(ErrorType errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        public BatchGetTokenBalanceErrorItem build() {
            return new BatchGetTokenBalanceErrorItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetTokenBalanceErrorItem> {
        public Builder tokenIdentifier(TokenIdentifier var1);

        default public Builder tokenIdentifier(Consumer<TokenIdentifier.Builder> tokenIdentifier) {
            return this.tokenIdentifier((TokenIdentifier)((TokenIdentifier.Builder)TokenIdentifier.builder().applyMutation(tokenIdentifier)).build());
        }

        public Builder ownerIdentifier(OwnerIdentifier var1);

        default public Builder ownerIdentifier(Consumer<OwnerIdentifier.Builder> ownerIdentifier) {
            return this.ownerIdentifier((OwnerIdentifier)((OwnerIdentifier.Builder)OwnerIdentifier.builder().applyMutation(ownerIdentifier)).build());
        }

        public Builder atBlockchainInstant(BlockchainInstant var1);

        default public Builder atBlockchainInstant(Consumer<BlockchainInstant.Builder> atBlockchainInstant) {
            return this.atBlockchainInstant((BlockchainInstant)((BlockchainInstant.Builder)BlockchainInstant.builder().applyMutation(atBlockchainInstant)).build());
        }

        public Builder errorCode(String var1);

        public Builder errorMessage(String var1);

        public Builder errorType(String var1);

        public Builder errorType(ErrorType var1);
    }
}

