/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.marketplaceagreement.DefaultMarketplaceAgreementAsyncClientBuilder;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementAsyncClientBuilder;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementServiceClientConfiguration;
import software.amazon.awssdk.services.marketplaceagreement.model.DescribeAgreementRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.DescribeAgreementResponse;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsResponse;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsResponse;
import software.amazon.awssdk.services.marketplaceagreement.paginators.GetAgreementTermsPublisher;
import software.amazon.awssdk.services.marketplaceagreement.paginators.SearchAgreementsPublisher;

@SdkPublicApi
@ThreadSafe
public interface MarketplaceAgreementAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "aws-marketplace";
    public static final String SERVICE_METADATA_ID = "agreement-marketplace";

    default public CompletableFuture<DescribeAgreementResponse> describeAgreement(DescribeAgreementRequest describeAgreementRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeAgreementResponse> describeAgreement(Consumer<DescribeAgreementRequest.Builder> describeAgreementRequest) {
        return this.describeAgreement((DescribeAgreementRequest)((Object)((DescribeAgreementRequest.Builder)DescribeAgreementRequest.builder().applyMutation(describeAgreementRequest)).build()));
    }

    default public CompletableFuture<GetAgreementTermsResponse> getAgreementTerms(GetAgreementTermsRequest getAgreementTermsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetAgreementTermsResponse> getAgreementTerms(Consumer<GetAgreementTermsRequest.Builder> getAgreementTermsRequest) {
        return this.getAgreementTerms((GetAgreementTermsRequest)((Object)((GetAgreementTermsRequest.Builder)GetAgreementTermsRequest.builder().applyMutation(getAgreementTermsRequest)).build()));
    }

    default public GetAgreementTermsPublisher getAgreementTermsPaginator(GetAgreementTermsRequest getAgreementTermsRequest) {
        return new GetAgreementTermsPublisher(this, getAgreementTermsRequest);
    }

    default public GetAgreementTermsPublisher getAgreementTermsPaginator(Consumer<GetAgreementTermsRequest.Builder> getAgreementTermsRequest) {
        return this.getAgreementTermsPaginator((GetAgreementTermsRequest)((Object)((GetAgreementTermsRequest.Builder)GetAgreementTermsRequest.builder().applyMutation(getAgreementTermsRequest)).build()));
    }

    default public CompletableFuture<SearchAgreementsResponse> searchAgreements(SearchAgreementsRequest searchAgreementsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SearchAgreementsResponse> searchAgreements(Consumer<SearchAgreementsRequest.Builder> searchAgreementsRequest) {
        return this.searchAgreements((SearchAgreementsRequest)((Object)((SearchAgreementsRequest.Builder)SearchAgreementsRequest.builder().applyMutation(searchAgreementsRequest)).build()));
    }

    default public SearchAgreementsPublisher searchAgreementsPaginator(SearchAgreementsRequest searchAgreementsRequest) {
        return new SearchAgreementsPublisher(this, searchAgreementsRequest);
    }

    default public SearchAgreementsPublisher searchAgreementsPaginator(Consumer<SearchAgreementsRequest.Builder> searchAgreementsRequest) {
        return this.searchAgreementsPaginator((SearchAgreementsRequest)((Object)((SearchAgreementsRequest.Builder)SearchAgreementsRequest.builder().applyMutation(searchAgreementsRequest)).build()));
    }

    default public MarketplaceAgreementServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static MarketplaceAgreementAsyncClient create() {
        return (MarketplaceAgreementAsyncClient)MarketplaceAgreementAsyncClient.builder().build();
    }

    public static MarketplaceAgreementAsyncClientBuilder builder() {
        return new DefaultMarketplaceAgreementAsyncClientBuilder();
    }
}

