/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.AcceptedTerm;
import software.amazon.awssdk.services.marketplaceagreement.model.AcceptedTermListCopier;
import software.amazon.awssdk.services.marketplaceagreement.model.MarketplaceAgreementResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAgreementTermsResponse
extends MarketplaceAgreementResponse
implements ToCopyableBuilder<Builder, GetAgreementTermsResponse> {
    private static final SdkField<List<AcceptedTerm>> ACCEPTED_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceptedTerms").getter(GetAgreementTermsResponse.getter(GetAgreementTermsResponse::acceptedTerms)).setter(GetAgreementTermsResponse.setter(Builder::acceptedTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptedTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcceptedTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAgreementTermsResponse.getter(GetAgreementTermsResponse::nextToken)).setter(GetAgreementTermsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_TERMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AcceptedTerm> acceptedTerms;
    private final String nextToken;

    private GetAgreementTermsResponse(BuilderImpl builder) {
        super(builder);
        this.acceptedTerms = builder.acceptedTerms;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAcceptedTerms() {
        return this.acceptedTerms != null && !(this.acceptedTerms instanceof SdkAutoConstructList);
    }

    public final List<AcceptedTerm> acceptedTerms() {
        return this.acceptedTerms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceptedTerms() ? this.acceptedTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgreementTermsResponse)) {
            return false;
        }
        GetAgreementTermsResponse other = (GetAgreementTermsResponse)((Object)obj);
        return this.hasAcceptedTerms() == other.hasAcceptedTerms() && Objects.equals(this.acceptedTerms(), other.acceptedTerms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAgreementTermsResponse").add("AcceptedTerms", this.hasAcceptedTerms() ? this.acceptedTerms() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceptedTerms": {
                return Optional.ofNullable(clazz.cast(this.acceptedTerms()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAgreementTermsResponse, T> g) {
        return obj -> g.apply((GetAgreementTermsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceAgreementResponse.BuilderImpl
    implements Builder {
        private List<AcceptedTerm> acceptedTerms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgreementTermsResponse model) {
            super(model);
            this.acceptedTerms(model.acceptedTerms);
            this.nextToken(model.nextToken);
        }

        public final List<AcceptedTerm.Builder> getAcceptedTerms() {
            List<AcceptedTerm.Builder> result = AcceptedTermListCopier.copyToBuilder(this.acceptedTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcceptedTerms(Collection<AcceptedTerm.BuilderImpl> acceptedTerms) {
            this.acceptedTerms = AcceptedTermListCopier.copyFromBuilder(acceptedTerms);
        }

        @Override
        public final Builder acceptedTerms(Collection<AcceptedTerm> acceptedTerms) {
            this.acceptedTerms = AcceptedTermListCopier.copy(acceptedTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedTerms(AcceptedTerm ... acceptedTerms) {
            this.acceptedTerms(Arrays.asList(acceptedTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceptedTerms(Consumer<AcceptedTerm.Builder> ... acceptedTerms) {
            this.acceptedTerms(Stream.of(acceptedTerms).map(c -> (AcceptedTerm)((AcceptedTerm.Builder)AcceptedTerm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAgreementTermsResponse build() {
            return new GetAgreementTermsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceAgreementResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAgreementTermsResponse> {
        public Builder acceptedTerms(Collection<AcceptedTerm> var1);

        public Builder acceptedTerms(AcceptedTerm ... var1);

        public Builder acceptedTerms(Consumer<AcceptedTerm.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

