/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplaceentitlement.MarketplaceEntitlementClient;
import software.amazon.awssdk.services.marketplaceentitlement.internal.UserAgentUtils;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsRequest;
import software.amazon.awssdk.services.marketplaceentitlement.model.GetEntitlementsResponse;

public class GetEntitlementsIterable
implements SdkIterable<GetEntitlementsResponse> {
    private final MarketplaceEntitlementClient client;
    private final GetEntitlementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetEntitlementsIterable(MarketplaceEntitlementClient client, GetEntitlementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetEntitlementsResponseFetcher();
    }

    public Iterator<GetEntitlementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetEntitlementsResponseFetcher
    implements SyncPageFetcher<GetEntitlementsResponse> {
        private GetEntitlementsResponseFetcher() {
        }

        public boolean hasNextPage(GetEntitlementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetEntitlementsResponse nextPage(GetEntitlementsResponse previousPage) {
            if (previousPage == null) {
                return GetEntitlementsIterable.this.client.getEntitlements(GetEntitlementsIterable.this.firstRequest);
            }
            return GetEntitlementsIterable.this.client.getEntitlements((GetEntitlementsRequest)((Object)GetEntitlementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

