/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplacemetering.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeterUsageRequest extends MarketplaceMeteringRequest implements
        ToCopyableBuilder<MeterUsageRequest.Builder, MeterUsageRequest> {
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductCode").getter(getter(MeterUsageRequest::productCode)).setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(MeterUsageRequest::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> USAGE_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageDimension").getter(getter(MeterUsageRequest::usageDimension))
            .setter(setter(Builder::usageDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageDimension").build()).build();

    private static final SdkField<Integer> USAGE_QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UsageQuantity").getter(getter(MeterUsageRequest::usageQuantity)).setter(setter(Builder::usageQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageQuantity").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(MeterUsageRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<List<UsageAllocation>> USAGE_ALLOCATIONS_FIELD = SdkField
            .<List<UsageAllocation>> builder(MarshallingType.LIST)
            .memberName("UsageAllocations")
            .getter(getter(MeterUsageRequest::usageAllocations))
            .setter(setter(Builder::usageAllocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageAllocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageAllocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageAllocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_CODE_FIELD,
            TIMESTAMP_FIELD, USAGE_DIMENSION_FIELD, USAGE_QUANTITY_FIELD, DRY_RUN_FIELD, USAGE_ALLOCATIONS_FIELD));

    private final String productCode;

    private final Instant timestamp;

    private final String usageDimension;

    private final Integer usageQuantity;

    private final Boolean dryRun;

    private final List<UsageAllocation> usageAllocations;

    private MeterUsageRequest(BuilderImpl builder) {
        super(builder);
        this.productCode = builder.productCode;
        this.timestamp = builder.timestamp;
        this.usageDimension = builder.usageDimension;
        this.usageQuantity = builder.usageQuantity;
        this.dryRun = builder.dryRun;
        this.usageAllocations = builder.usageAllocations;
    }

    /**
     * <p>
     * Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same as
     * the one used during the publishing of a new product.
     * </p>
     * 
     * @return Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the
     *         same as the one used during the publishing of a new product.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * <p>
     * Timestamp, in UTC, for which the usage is being reported. Your application can meter usage for up to one hour in
     * the past. Make sure the <code>timestamp</code> value is not before the start of the software usage.
     * </p>
     * 
     * @return Timestamp, in UTC, for which the usage is being reported. Your application can meter usage for up to one
     *         hour in the past. Make sure the <code>timestamp</code> value is not before the start of the software
     *         usage.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * It will be one of the fcp dimension name provided during the publishing of the product.
     * </p>
     * 
     * @return It will be one of the fcp dimension name provided during the publishing of the product.
     */
    public final String usageDimension() {
        return usageDimension;
    }

    /**
     * <p>
     * Consumption value for the hour. Defaults to <code>0</code> if not specified.
     * </p>
     * 
     * @return Consumption value for the hour. Defaults to <code>0</code> if not specified.
     */
    public final Integer usageQuantity() {
        return usageQuantity;
    }

    /**
     * <p>
     * Checks whether you have the permissions required for the action, but does not make the request. If you have the
     * permissions, the request returns <code>DryRunOperation</code>; otherwise, it returns
     * <code>UnauthorizedException</code>. Defaults to <code>false</code> if not specified.
     * </p>
     * 
     * @return Checks whether you have the permissions required for the action, but does not make the request. If you
     *         have the permissions, the request returns <code>DryRunOperation</code>; otherwise, it returns
     *         <code>UnauthorizedException</code>. Defaults to <code>false</code> if not specified.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageAllocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageAllocations() {
        return usageAllocations != null && !(usageAllocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of <code>UsageAllocations</code> to submit.
     * </p>
     * <p>
     * The sum of all <code>UsageAllocation</code> quantities must equal the <code>UsageQuantity</code> of the
     * <code>MeterUsage</code> request, and each <code>UsageAllocation</code> must have a unique set of tags (include no
     * tags).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageAllocations} method.
     * </p>
     * 
     * @return The set of <code>UsageAllocations</code> to submit.</p>
     *         <p>
     *         The sum of all <code>UsageAllocation</code> quantities must equal the <code>UsageQuantity</code> of the
     *         <code>MeterUsage</code> request, and each <code>UsageAllocation</code> must have a unique set of tags
     *         (include no tags).
     */
    public final List<UsageAllocation> usageAllocations() {
        return usageAllocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(usageDimension());
        hashCode = 31 * hashCode + Objects.hashCode(usageQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageAllocations() ? usageAllocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeterUsageRequest)) {
            return false;
        }
        MeterUsageRequest other = (MeterUsageRequest) obj;
        return Objects.equals(productCode(), other.productCode()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(usageDimension(), other.usageDimension())
                && Objects.equals(usageQuantity(), other.usageQuantity()) && Objects.equals(dryRun(), other.dryRun())
                && hasUsageAllocations() == other.hasUsageAllocations()
                && Objects.equals(usageAllocations(), other.usageAllocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeterUsageRequest").add("ProductCode", productCode()).add("Timestamp", timestamp())
                .add("UsageDimension", usageDimension()).add("UsageQuantity", usageQuantity()).add("DryRun", dryRun())
                .add("UsageAllocations", hasUsageAllocations() ? usageAllocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "UsageDimension":
            return Optional.ofNullable(clazz.cast(usageDimension()));
        case "UsageQuantity":
            return Optional.ofNullable(clazz.cast(usageQuantity()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "UsageAllocations":
            return Optional.ofNullable(clazz.cast(usageAllocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeterUsageRequest, T> g) {
        return obj -> g.apply((MeterUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MarketplaceMeteringRequest.Builder, SdkPojo, CopyableBuilder<Builder, MeterUsageRequest> {
        /**
         * <p>
         * Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the same
         * as the one used during the publishing of a new product.
         * </p>
         * 
         * @param productCode
         *        Product code is used to uniquely identify a product in AWS Marketplace. The product code should be the
         *        same as the one used during the publishing of a new product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * Timestamp, in UTC, for which the usage is being reported. Your application can meter usage for up to one hour
         * in the past. Make sure the <code>timestamp</code> value is not before the start of the software usage.
         * </p>
         * 
         * @param timestamp
         *        Timestamp, in UTC, for which the usage is being reported. Your application can meter usage for up to
         *        one hour in the past. Make sure the <code>timestamp</code> value is not before the start of the
         *        software usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * It will be one of the fcp dimension name provided during the publishing of the product.
         * </p>
         * 
         * @param usageDimension
         *        It will be one of the fcp dimension name provided during the publishing of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageDimension(String usageDimension);

        /**
         * <p>
         * Consumption value for the hour. Defaults to <code>0</code> if not specified.
         * </p>
         * 
         * @param usageQuantity
         *        Consumption value for the hour. Defaults to <code>0</code> if not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageQuantity(Integer usageQuantity);

        /**
         * <p>
         * Checks whether you have the permissions required for the action, but does not make the request. If you have
         * the permissions, the request returns <code>DryRunOperation</code>; otherwise, it returns
         * <code>UnauthorizedException</code>. Defaults to <code>false</code> if not specified.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the permissions required for the action, but does not make the request. If you
         *        have the permissions, the request returns <code>DryRunOperation</code>; otherwise, it returns
         *        <code>UnauthorizedException</code>. Defaults to <code>false</code> if not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The set of <code>UsageAllocations</code> to submit.
         * </p>
         * <p>
         * The sum of all <code>UsageAllocation</code> quantities must equal the <code>UsageQuantity</code> of the
         * <code>MeterUsage</code> request, and each <code>UsageAllocation</code> must have a unique set of tags
         * (include no tags).
         * </p>
         * 
         * @param usageAllocations
         *        The set of <code>UsageAllocations</code> to submit.</p>
         *        <p>
         *        The sum of all <code>UsageAllocation</code> quantities must equal the <code>UsageQuantity</code> of
         *        the <code>MeterUsage</code> request, and each <code>UsageAllocation</code> must have a unique set of
         *        tags (include no tags).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAllocations(Collection<UsageAllocation> usageAllocations);

        /**
         * <p>
         * The set of <code>UsageAllocations</code> to submit.
         * </p>
         * <p>
         * The sum of all <code>UsageAllocation</code> quantities must equal the <code>UsageQuantity</code> of the
         * <code>MeterUsage</code> request, and each <code>UsageAllocation</code> must have a unique set of tags
         * (include no tags).
         * </p>
         * 
         * @param usageAllocations
         *        The set of <code>UsageAllocations</code> to submit.</p>
         *        <p>
         *        The sum of all <code>UsageAllocation</code> quantities must equal the <code>UsageQuantity</code> of
         *        the <code>MeterUsage</code> request, and each <code>UsageAllocation</code> must have a unique set of
         *        tags (include no tags).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAllocations(UsageAllocation... usageAllocations);

        /**
         * <p>
         * The set of <code>UsageAllocations</code> to submit.
         * </p>
         * <p>
         * The sum of all <code>UsageAllocation</code> quantities must equal the <code>UsageQuantity</code> of the
         * <code>MeterUsage</code> request, and each <code>UsageAllocation</code> must have a unique set of tags
         * (include no tags).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.marketplacemetering.model.UsageAllocation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.marketplacemetering.model.UsageAllocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.marketplacemetering.model.UsageAllocation.Builder#build()} is called
         * immediately and its result is passed to {@link #usageAllocations(List<UsageAllocation>)}.
         * 
         * @param usageAllocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.marketplacemetering.model.UsageAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageAllocations(java.util.Collection<UsageAllocation>)
         */
        Builder usageAllocations(Consumer<UsageAllocation.Builder>... usageAllocations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MarketplaceMeteringRequest.BuilderImpl implements Builder {
        private String productCode;

        private Instant timestamp;

        private String usageDimension;

        private Integer usageQuantity;

        private Boolean dryRun;

        private List<UsageAllocation> usageAllocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MeterUsageRequest model) {
            super(model);
            productCode(model.productCode);
            timestamp(model.timestamp);
            usageDimension(model.usageDimension);
            usageQuantity(model.usageQuantity);
            dryRun(model.dryRun);
            usageAllocations(model.usageAllocations);
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getUsageDimension() {
            return usageDimension;
        }

        public final void setUsageDimension(String usageDimension) {
            this.usageDimension = usageDimension;
        }

        @Override
        public final Builder usageDimension(String usageDimension) {
            this.usageDimension = usageDimension;
            return this;
        }

        public final Integer getUsageQuantity() {
            return usageQuantity;
        }

        public final void setUsageQuantity(Integer usageQuantity) {
            this.usageQuantity = usageQuantity;
        }

        @Override
        public final Builder usageQuantity(Integer usageQuantity) {
            this.usageQuantity = usageQuantity;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<UsageAllocation.Builder> getUsageAllocations() {
            List<UsageAllocation.Builder> result = UsageAllocationsCopier.copyToBuilder(this.usageAllocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageAllocations(Collection<UsageAllocation.BuilderImpl> usageAllocations) {
            this.usageAllocations = UsageAllocationsCopier.copyFromBuilder(usageAllocations);
        }

        @Override
        public final Builder usageAllocations(Collection<UsageAllocation> usageAllocations) {
            this.usageAllocations = UsageAllocationsCopier.copy(usageAllocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageAllocations(UsageAllocation... usageAllocations) {
            usageAllocations(Arrays.asList(usageAllocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageAllocations(Consumer<UsageAllocation.Builder>... usageAllocations) {
            usageAllocations(Stream.of(usageAllocations).map(c -> UsageAllocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MeterUsageRequest build() {
            return new MeterUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
