/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouterInputType {
    STANDARD("STANDARD"),
    FAILOVER("FAILOVER"),
    MERGE("MERGE"),
    MEDIACONNECT_FLOW("MEDIACONNECT_FLOW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouterInputType> VALUE_MAP;
    private final String value;

    private RouterInputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouterInputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouterInputType> knownValues() {
        EnumSet<RouterInputType> knownValues = EnumSet.allOf(RouterInputType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouterInputType.class, RouterInputType::toString);
    }
}

