/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterInput;

public class ListRouterInputsIterable
implements SdkIterable<ListRouterInputsResponse> {
    private final MediaConnectClient client;
    private final ListRouterInputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRouterInputsIterable(MediaConnectClient client, ListRouterInputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRouterInputsResponseFetcher();
    }

    public Iterator<ListRouterInputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedRouterInput> routerInputs() {
        Function<ListRouterInputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.routerInputs() != null) {
                return response.routerInputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRouterInputsResponseFetcher
    implements SyncPageFetcher<ListRouterInputsResponse> {
        private ListRouterInputsResponseFetcher() {
        }

        public boolean hasNextPage(ListRouterInputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRouterInputsResponse nextPage(ListRouterInputsResponse previousPage) {
            if (previousPage == null) {
                return ListRouterInputsIterable.this.client.listRouterInputs(ListRouterInputsIterable.this.firstRequest);
            }
            return ListRouterInputsIterable.this.client.listRouterInputs((ListRouterInputsRequest)((Object)ListRouterInputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

