/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterInput;

public class ListRouterInputsPublisher
implements SdkPublisher<ListRouterInputsResponse> {
    private final MediaConnectAsyncClient client;
    private final ListRouterInputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRouterInputsPublisher(MediaConnectAsyncClient client, ListRouterInputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRouterInputsPublisher(MediaConnectAsyncClient client, ListRouterInputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRouterInputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRouterInputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedRouterInput> routerInputs() {
        Function<ListRouterInputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.routerInputs() != null) {
                return response.routerInputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRouterInputsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRouterInputsResponseFetcher
    implements AsyncPageFetcher<ListRouterInputsResponse> {
        private ListRouterInputsResponseFetcher() {
        }

        public boolean hasNextPage(ListRouterInputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRouterInputsResponse> nextPage(ListRouterInputsResponse previousPage) {
            if (previousPage == null) {
                return ListRouterInputsPublisher.this.client.listRouterInputs(ListRouterInputsPublisher.this.firstRequest);
            }
            return ListRouterInputsPublisher.this.client.listRouterInputs((ListRouterInputsRequest)((Object)ListRouterInputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

