/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterOutput;

public class ListRouterOutputsPublisher
implements SdkPublisher<ListRouterOutputsResponse> {
    private final MediaConnectAsyncClient client;
    private final ListRouterOutputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRouterOutputsPublisher(MediaConnectAsyncClient client, ListRouterOutputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRouterOutputsPublisher(MediaConnectAsyncClient client, ListRouterOutputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRouterOutputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRouterOutputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedRouterOutput> routerOutputs() {
        Function<ListRouterOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.routerOutputs() != null) {
                return response.routerOutputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRouterOutputsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRouterOutputsResponseFetcher
    implements AsyncPageFetcher<ListRouterOutputsResponse> {
        private ListRouterOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListRouterOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRouterOutputsResponse> nextPage(ListRouterOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListRouterOutputsPublisher.this.client.listRouterOutputs(ListRouterOutputsPublisher.this.firstRequest);
            }
            return ListRouterOutputsPublisher.this.client.listRouterOutputs((ListRouterOutputsRequest)((Object)ListRouterOutputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

