/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectWaiter;
import software.amazon.awssdk.services.mediaconnect.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultMediaConnectWaiter
implements MediaConnectWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final MediaConnectClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeFlowResponse> flowActiveWaiter;
    private final Waiter<DescribeFlowResponse> flowDeletedWaiter;
    private final Waiter<DescribeFlowResponse> flowStandbyWaiter;
    private final Waiter<GetRouterInputResponse> inputActiveWaiter;
    private final Waiter<GetRouterInputResponse> inputDeletedWaiter;
    private final Waiter<GetRouterInputResponse> inputStandbyWaiter;
    private final Waiter<GetRouterOutputResponse> outputActiveWaiter;
    private final Waiter<GetRouterOutputResponse> outputDeletedWaiter;
    private final Waiter<GetRouterOutputResponse> outputRoutedWaiter;
    private final Waiter<GetRouterOutputResponse> outputStandbyWaiter;

    private DefaultMediaConnectWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MediaConnectClient)MediaConnectClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.flowActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectWaiter.flowActiveWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.flowActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.flowDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectWaiter.flowDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.flowDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.flowStandbyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFlowResponse.class).acceptors(DefaultMediaConnectWaiter.flowStandbyWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.flowStandbyWaiterConfig(builder.overrideConfiguration))).build();
        this.inputActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRouterInputResponse.class).acceptors(DefaultMediaConnectWaiter.inputActiveWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.inputActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.inputDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRouterInputResponse.class).acceptors(DefaultMediaConnectWaiter.inputDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.inputDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.inputStandbyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRouterInputResponse.class).acceptors(DefaultMediaConnectWaiter.inputStandbyWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.inputStandbyWaiterConfig(builder.overrideConfiguration))).build();
        this.outputActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectWaiter.outputActiveWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.outputActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.outputDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectWaiter.outputDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.outputDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.outputRoutedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectWaiter.outputRoutedWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.outputRoutedWaiterConfig(builder.overrideConfiguration))).build();
        this.outputStandbyWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRouterOutputResponse.class).acceptors(DefaultMediaConnectWaiter.outputStandbyWaiterAcceptors())).overrideConfiguration(DefaultMediaConnectWaiter.outputStandbyWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeFlowResponse> waitUntilFlowActive(DescribeFlowRequest describeFlowRequest) {
        return this.flowActiveWaiter.run(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public WaiterResponse<DescribeFlowResponse> waitUntilFlowActive(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowActiveWaiter.run(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectWaiter.flowActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFlowResponse> waitUntilFlowDeleted(DescribeFlowRequest describeFlowRequest) {
        return this.flowDeletedWaiter.run(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public WaiterResponse<DescribeFlowResponse> waitUntilFlowDeleted(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowDeletedWaiter.run(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectWaiter.flowDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFlowResponse> waitUntilFlowStandby(DescribeFlowRequest describeFlowRequest) {
        return this.flowStandbyWaiter.run(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)));
    }

    @Override
    public WaiterResponse<DescribeFlowResponse> waitUntilFlowStandby(DescribeFlowRequest describeFlowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.flowStandbyWaiter.run(() -> this.client.describeFlow(this.applyWaitersUserAgent(describeFlowRequest)), DefaultMediaConnectWaiter.flowStandbyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRouterInputResponse> waitUntilInputActive(GetRouterInputRequest getRouterInputRequest) {
        return this.inputActiveWaiter.run(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)));
    }

    @Override
    public WaiterResponse<GetRouterInputResponse> waitUntilInputActive(GetRouterInputRequest getRouterInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputActiveWaiter.run(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)), DefaultMediaConnectWaiter.inputActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRouterInputResponse> waitUntilInputDeleted(GetRouterInputRequest getRouterInputRequest) {
        return this.inputDeletedWaiter.run(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)));
    }

    @Override
    public WaiterResponse<GetRouterInputResponse> waitUntilInputDeleted(GetRouterInputRequest getRouterInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputDeletedWaiter.run(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)), DefaultMediaConnectWaiter.inputDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRouterInputResponse> waitUntilInputStandby(GetRouterInputRequest getRouterInputRequest) {
        return this.inputStandbyWaiter.run(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)));
    }

    @Override
    public WaiterResponse<GetRouterInputResponse> waitUntilInputStandby(GetRouterInputRequest getRouterInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputStandbyWaiter.run(() -> this.client.getRouterInput(this.applyWaitersUserAgent(getRouterInputRequest)), DefaultMediaConnectWaiter.inputStandbyWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputActive(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputActiveWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputActive(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputActiveWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectWaiter.outputActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputDeleted(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputDeletedWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputDeleted(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputDeletedWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectWaiter.outputDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputRouted(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputRoutedWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputRouted(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputRoutedWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectWaiter.outputRoutedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputStandby(GetRouterOutputRequest getRouterOutputRequest) {
        return this.outputStandbyWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)));
    }

    @Override
    public WaiterResponse<GetRouterOutputResponse> waitUntilOutputStandby(GetRouterOutputRequest getRouterOutputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outputStandbyWaiter.run(() -> this.client.getRouterOutput(this.applyWaitersUserAgent(getRouterOutputRequest)), DefaultMediaConnectWaiter.outputStandbyWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STANDBY");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=STANDBY) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "NotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFlowResponse>> flowStandbyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFlowResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFlowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STANDBY");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Flow").field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Flow.Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterInputResponse>> inputActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterInputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterInput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterInputResponse>> inputDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterInputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterInputResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterInput.State=ERROR) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "NotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterInputResponse>> inputStandbyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterInputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "STANDBY");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterInput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterInput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterOutput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterOutput.State=ERROR) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "NotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputRoutedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("RoutedState").value(), "ROUTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("RoutedState").value(), "ROUTING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRouterOutputResponse>> outputStandbyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>> result = new ArrayList<WaiterAcceptor<? super GetRouterOutputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "STANDBY");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "InternalServerErrorException")));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultMediaConnectWaiter.errorCode(error), "ServiceUnavailableException")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("RouterOutput").field("State").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (RouterOutput.State=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration flowActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration flowDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration flowStandbyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputStandbyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputRoutedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outputStandbyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MediaConnectWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MediaConnectRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MediaConnectRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MediaConnectWaiter.Builder {
        private MediaConnectClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public MediaConnectWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MediaConnectWaiter.Builder client(MediaConnectClient client) {
            this.client = client;
            return this;
        }

        @Override
        public MediaConnectWaiter build() {
            return new DefaultMediaConnectWaiter(this);
        }
    }
}

