/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
 * Dolby Digital stream for the line operating mode. Related setting: When you use this setting, MediaConvert ignores
 * any value you provide for Dynamic range compression profile. For information about the Dolby Digital DRC operating
 * modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
 * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Ac3DynamicRangeCompressionLine {
    FILM_STANDARD("FILM_STANDARD"),

    FILM_LIGHT("FILM_LIGHT"),

    MUSIC_STANDARD("MUSIC_STANDARD"),

    MUSIC_LIGHT("MUSIC_LIGHT"),

    SPEECH("SPEECH"),

    NONE("NONE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ac3DynamicRangeCompressionLine> VALUE_MAP = EnumUtils.uniqueIndex(
            Ac3DynamicRangeCompressionLine.class, Ac3DynamicRangeCompressionLine::toString);

    private final String value;

    private Ac3DynamicRangeCompressionLine(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Ac3DynamicRangeCompressionLine corresponding to the value
     */
    public static Ac3DynamicRangeCompressionLine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Ac3DynamicRangeCompressionLine}s
     */
    public static Set<Ac3DynamicRangeCompressionLine> knownValues() {
        Set<Ac3DynamicRangeCompressionLine> knownValues = EnumSet.allOf(Ac3DynamicRangeCompressionLine.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
