/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend that you use
 * the mode-specific settings instead of Dynamic range compression profile. The mode-specific settings are Dynamic range
 * compression profile, line mode and Dynamic range compression profile, RF mode. Note that when you specify values for
 * all three settings, MediaConvert ignores the value of this setting in favor of the mode-specific settings. If you do
 * use this setting instead of the mode-specific settings, choose None to leave out DRC signaling. Keep the default Film
 * standard to set the profile to Dolby's film standard profile for all operating modes.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Ac3DynamicRangeCompressionProfile {
    FILM_STANDARD("FILM_STANDARD"),

    NONE("NONE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ac3DynamicRangeCompressionProfile> VALUE_MAP = EnumUtils.uniqueIndex(
            Ac3DynamicRangeCompressionProfile.class, Ac3DynamicRangeCompressionProfile::toString);

    private final String value;

    private Ac3DynamicRangeCompressionProfile(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Ac3DynamicRangeCompressionProfile corresponding to the value
     */
    public static Ac3DynamicRangeCompressionProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Ac3DynamicRangeCompressionProfile}s
     */
    public static Set<Ac3DynamicRangeCompressionProfile> knownValues() {
        Set<Ac3DynamicRangeCompressionProfile> knownValues = EnumSet.allOf(Ac3DynamicRangeCompressionProfile.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
