/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * ESAM ManifestConfirmConditionNotification defined by OC-SP-ESAM-API-I03-131025.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EsamManifestConfirmConditionNotification implements SdkPojo, Serializable,
        ToCopyableBuilder<EsamManifestConfirmConditionNotification.Builder, EsamManifestConfirmConditionNotification> {
    private static final SdkField<String> MCC_XML_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("MccXml")
            .getter(getter(EsamManifestConfirmConditionNotification::mccXml)).setter(setter(Builder::mccXml))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mccXml").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCC_XML_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mccXml;

    private EsamManifestConfirmConditionNotification(BuilderImpl builder) {
        this.mccXml = builder.mccXml;
    }

    /**
     * Provide your ESAM ManifestConfirmConditionNotification XML document inside your JSON job settings. Form the XML
     * document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the Manifest Conditioning instructions in the
     * message that you supply.
     * 
     * @return Provide your ESAM ManifestConfirmConditionNotification XML document inside your JSON job settings. Form
     *         the XML document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the Manifest Conditioning
     *         instructions in the message that you supply.
     */
    public final String mccXml() {
        return mccXml;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mccXml());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EsamManifestConfirmConditionNotification)) {
            return false;
        }
        EsamManifestConfirmConditionNotification other = (EsamManifestConfirmConditionNotification) obj;
        return Objects.equals(mccXml(), other.mccXml());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EsamManifestConfirmConditionNotification").add("MccXml", mccXml()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MccXml":
            return Optional.ofNullable(clazz.cast(mccXml()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EsamManifestConfirmConditionNotification, T> g) {
        return obj -> g.apply((EsamManifestConfirmConditionNotification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EsamManifestConfirmConditionNotification> {
        /**
         * Provide your ESAM ManifestConfirmConditionNotification XML document inside your JSON job settings. Form the
         * XML document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the Manifest Conditioning instructions
         * in the message that you supply.
         * 
         * @param mccXml
         *        Provide your ESAM ManifestConfirmConditionNotification XML document inside your JSON job settings.
         *        Form the XML document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the Manifest
         *        Conditioning instructions in the message that you supply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mccXml(String mccXml);
    }

    static final class BuilderImpl implements Builder {
        private String mccXml;

        private BuilderImpl() {
        }

        private BuilderImpl(EsamManifestConfirmConditionNotification model) {
            mccXml(model.mccXml);
        }

        public final String getMccXml() {
            return mccXml;
        }

        public final void setMccXml(String mccXml) {
            this.mccXml = mccXml;
        }

        @Override
        public final Builder mccXml(String mccXml) {
            this.mccXml = mccXml;
            return this;
        }

        @Override
        public EsamManifestConfirmConditionNotification build() {
            return new EsamManifestConfirmConditionNotification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
