/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the initial presentation timestamp (PTS) offset for your transport stream output. To let MediaConvert
 * automatically determine the initial PTS offset: Keep the default value, Auto. We recommend that you choose Auto for
 * the widest player compatibility. The initial PTS will be at least two seconds and vary depending on your output's
 * bitrate, HRD buffer size and HRD buffer initial fill percentage. To manually specify an initial PTS offset: Choose
 * Seconds. Then specify the number of seconds with PTS offset.
 */
@Generated("software.amazon.awssdk:codegen")
public enum TsPtsOffset {
    AUTO("AUTO"),

    SECONDS("SECONDS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TsPtsOffset> VALUE_MAP = EnumUtils.uniqueIndex(TsPtsOffset.class, TsPtsOffset::toString);

    private final String value;

    private TsPtsOffset(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TsPtsOffset corresponding to the value
     */
    public static TsPtsOffset fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TsPtsOffset}s
     */
    public static Set<TsPtsOffset> knownValues() {
        Set<TsPtsOffset> knownValues = EnumSet.allOf(TsPtsOffset.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
