/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * To transcode only portions of your video overlay, include one input clip for each part of your video overlay that you
 * want in your output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoOverlayInputClipping implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoOverlayInputClipping.Builder, VideoOverlayInputClipping> {
    private static final SdkField<String> END_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTimecode").getter(getter(VideoOverlayInputClipping::endTimecode))
            .setter(setter(Builder::endTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimecode").build()).build();

    private static final SdkField<String> START_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTimecode").getter(getter(VideoOverlayInputClipping::startTimecode))
            .setter(setter(Builder::startTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIMECODE_FIELD,
            START_TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endTimecode;

    private final String startTimecode;

    private VideoOverlayInputClipping(BuilderImpl builder) {
        this.endTimecode = builder.endTimecode;
        this.startTimecode = builder.startTimecode;
    }

    /**
     * Specify the timecode of the last frame to include in your video overlay's clip. Use the format HH:MM:SS:FF or
     * HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When entering
     * this value, take into account your choice for Timecode source.
     * 
     * @return Specify the timecode of the last frame to include in your video overlay's clip. Use the format
     *         HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame
     *         number. When entering this value, take into account your choice for Timecode source.
     */
    public final String endTimecode() {
        return endTimecode;
    }

    /**
     * Specify the timecode of the first frame to include in your video overlay's clip. Use the format HH:MM:SS:FF or
     * HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When entering
     * this value, take into account your choice for Timecode source.
     * 
     * @return Specify the timecode of the first frame to include in your video overlay's clip. Use the format
     *         HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame
     *         number. When entering this value, take into account your choice for Timecode source.
     */
    public final String startTimecode() {
        return startTimecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(startTimecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlayInputClipping)) {
            return false;
        }
        VideoOverlayInputClipping other = (VideoOverlayInputClipping) obj;
        return Objects.equals(endTimecode(), other.endTimecode()) && Objects.equals(startTimecode(), other.startTimecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoOverlayInputClipping").add("EndTimecode", endTimecode())
                .add("StartTimecode", startTimecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndTimecode":
            return Optional.ofNullable(clazz.cast(endTimecode()));
        case "StartTimecode":
            return Optional.ofNullable(clazz.cast(startTimecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlayInputClipping, T> g) {
        return obj -> g.apply((VideoOverlayInputClipping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoOverlayInputClipping> {
        /**
         * Specify the timecode of the last frame to include in your video overlay's clip. Use the format HH:MM:SS:FF or
         * HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When
         * entering this value, take into account your choice for Timecode source.
         * 
         * @param endTimecode
         *        Specify the timecode of the last frame to include in your video overlay's clip. Use the format
         *        HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the
         *        frame number. When entering this value, take into account your choice for Timecode source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimecode(String endTimecode);

        /**
         * Specify the timecode of the first frame to include in your video overlay's clip. Use the format HH:MM:SS:FF
         * or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When
         * entering this value, take into account your choice for Timecode source.
         * 
         * @param startTimecode
         *        Specify the timecode of the first frame to include in your video overlay's clip. Use the format
         *        HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the
         *        frame number. When entering this value, take into account your choice for Timecode source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimecode(String startTimecode);
    }

    static final class BuilderImpl implements Builder {
        private String endTimecode;

        private String startTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlayInputClipping model) {
            endTimecode(model.endTimecode);
            startTimecode(model.startTimecode);
        }

        public final String getEndTimecode() {
            return endTimecode;
        }

        public final void setEndTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
        }

        @Override
        public final Builder endTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
            return this;
        }

        public final String getStartTimecode() {
            return startTimecode;
        }

        public final void setStartTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
        }

        @Override
        public final Builder startTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
            return this;
        }

        @Override
        public VideoOverlayInputClipping build() {
            return new VideoOverlayInputClipping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
