/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have
 * similar image quality over the operating points that are valid for that class.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Xavc4kProfileBitrateClass {
    BITRATE_CLASS_100("BITRATE_CLASS_100"),

    BITRATE_CLASS_140("BITRATE_CLASS_140"),

    BITRATE_CLASS_200("BITRATE_CLASS_200"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Xavc4kProfileBitrateClass> VALUE_MAP = EnumUtils.uniqueIndex(
            Xavc4kProfileBitrateClass.class, Xavc4kProfileBitrateClass::toString);

    private final String value;

    private Xavc4kProfileBitrateClass(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Xavc4kProfileBitrateClass corresponding to the value
     */
    public static Xavc4kProfileBitrateClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Xavc4kProfileBitrateClass}s
     */
    public static Set<Xavc4kProfileBitrateClass> knownValues() {
        Set<Xavc4kProfileBitrateClass> knownValues = EnumSet.allOf(Xavc4kProfileBitrateClass.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
