/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeinterlaceAlgorithm {
    INTERPOLATE("INTERPOLATE"),
    INTERPOLATE_TICKER("INTERPOLATE_TICKER"),
    BLEND("BLEND"),
    BLEND_TICKER("BLEND_TICKER"),
    LINEAR_INTERPOLATION("LINEAR_INTERPOLATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeinterlaceAlgorithm> VALUE_MAP;
    private final String value;

    private DeinterlaceAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeinterlaceAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeinterlaceAlgorithm> knownValues() {
        EnumSet<DeinterlaceAlgorithm> knownValues = EnumSet.allOf(DeinterlaceAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeinterlaceAlgorithm.class, DeinterlaceAlgorithm::toString);
    }
}

