/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputFilterEnable {
    AUTO("AUTO"),
    DISABLE("DISABLE"),
    FORCE("FORCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputFilterEnable> VALUE_MAP;
    private final String value;

    private InputFilterEnable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputFilterEnable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputFilterEnable> knownValues() {
        EnumSet<InputFilterEnable> knownValues = EnumSet.allOf(InputFilterEnable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputFilterEnable.class, InputFilterEnable::toString);
    }
}

