/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Codec {
    UNKNOWN("UNKNOWN"),
    AAC("AAC"),
    AC3("AC3"),
    EAC3("EAC3"),
    FLAC("FLAC"),
    MP3("MP3"),
    OPUS("OPUS"),
    PCM("PCM"),
    VORBIS("VORBIS"),
    AV1("AV1"),
    AVC("AVC"),
    HEVC("HEVC"),
    JPEG2000("JPEG2000"),
    MJPEG("MJPEG"),
    MPEG1("MPEG1"),
    MP4_V("MP4V"),
    MPEG2("MPEG2"),
    PRORES("PRORES"),
    THEORA("THEORA"),
    VFW("VFW"),
    VP8("VP8"),
    VP9("VP9"),
    QTRLE("QTRLE"),
    C608("C608"),
    C708("C708"),
    WEBVTT("WEBVTT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Codec> VALUE_MAP;
    private final String value;

    private Codec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Codec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Codec> knownValues() {
        EnumSet<Codec> knownValues = EnumSet.allOf(Codec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Codec.class, Codec::toString);
    }
}

