/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlaceAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlacerControl;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlacerMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deinterlacer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deinterlacer> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Algorithm").getter(Deinterlacer.getter(Deinterlacer::algorithmAsString)).setter(Deinterlacer.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Control").getter(Deinterlacer.getter(Deinterlacer::controlAsString)).setter(Deinterlacer.setter(Builder::control)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(Deinterlacer.getter(Deinterlacer::modeAsString)).setter(Deinterlacer.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, CONTROL_FIELD, MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Deinterlacer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String control;
    private final String mode;

    private Deinterlacer(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.control = builder.control;
        this.mode = builder.mode;
    }

    public final DeinterlaceAlgorithm algorithm() {
        return DeinterlaceAlgorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final DeinterlacerControl control() {
        return DeinterlacerControl.fromValue(this.control);
    }

    public final String controlAsString() {
        return this.control;
    }

    public final DeinterlacerMode mode() {
        return DeinterlacerMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deinterlacer)) {
            return false;
        }
        Deinterlacer other = (Deinterlacer)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.controlAsString(), other.controlAsString()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Deinterlacer").add("Algorithm", (Object)this.algorithmAsString()).add("Control", (Object)this.controlAsString()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "Control": {
                return Optional.ofNullable(clazz.cast(this.controlAsString()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("algorithm", ALGORITHM_FIELD);
        map.put("control", CONTROL_FIELD);
        map.put("mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Deinterlacer, T> g) {
        return obj -> g.apply((Deinterlacer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String control;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(Deinterlacer model) {
            this.algorithm(model.algorithm);
            this.control(model.control);
            this.mode(model.mode);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(DeinterlaceAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final String getControl() {
            return this.control;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        @Override
        public final Builder control(DeinterlacerControl control) {
            this.control(control == null ? null : control.toString());
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DeinterlacerMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public Deinterlacer build() {
            return new Deinterlacer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deinterlacer> {
        public Builder algorithm(String var1);

        public Builder algorithm(DeinterlaceAlgorithm var1);

        public Builder control(String var1);

        public Builder control(DeinterlacerControl var1);

        public Builder mode(String var1);

        public Builder mode(DeinterlacerMode var1);
    }
}

