/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FrameControl {
    NEAREST_IDRFRAME("NEAREST_IDRFRAME"),
    NEAREST_IFRAME("NEAREST_IFRAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FrameControl> VALUE_MAP;
    private final String value;

    private FrameControl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FrameControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FrameControl> knownValues() {
        EnumSet<FrameControl> knownValues = EnumSet.allOf(FrameControl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FrameControl.class, FrameControl::toString);
    }
}

