/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.FrameControl;
import software.amazon.awssdk.services.mediaconvert.model.VideoSelectorMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PassthroughSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PassthroughSettings> {
    private static final SdkField<String> FRAME_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameControl").getter(PassthroughSettings.getter(PassthroughSettings::frameControlAsString)).setter(PassthroughSettings.setter(Builder::frameControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameControl").build()}).build();
    private static final SdkField<String> VIDEO_SELECTOR_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoSelectorMode").getter(PassthroughSettings.getter(PassthroughSettings::videoSelectorModeAsString)).setter(PassthroughSettings.setter(Builder::videoSelectorMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelectorMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_CONTROL_FIELD, VIDEO_SELECTOR_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PassthroughSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String frameControl;
    private final String videoSelectorMode;

    private PassthroughSettings(BuilderImpl builder) {
        this.frameControl = builder.frameControl;
        this.videoSelectorMode = builder.videoSelectorMode;
    }

    public final FrameControl frameControl() {
        return FrameControl.fromValue(this.frameControl);
    }

    public final String frameControlAsString() {
        return this.frameControl;
    }

    public final VideoSelectorMode videoSelectorMode() {
        return VideoSelectorMode.fromValue(this.videoSelectorMode);
    }

    public final String videoSelectorModeAsString() {
        return this.videoSelectorMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelectorModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PassthroughSettings)) {
            return false;
        }
        PassthroughSettings other = (PassthroughSettings)obj;
        return Objects.equals(this.frameControlAsString(), other.frameControlAsString()) && Objects.equals(this.videoSelectorModeAsString(), other.videoSelectorModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PassthroughSettings").add("FrameControl", (Object)this.frameControlAsString()).add("VideoSelectorMode", (Object)this.videoSelectorModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FrameControl": {
                return Optional.ofNullable(clazz.cast(this.frameControlAsString()));
            }
            case "VideoSelectorMode": {
                return Optional.ofNullable(clazz.cast(this.videoSelectorModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("frameControl", FRAME_CONTROL_FIELD);
        map.put("videoSelectorMode", VIDEO_SELECTOR_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PassthroughSettings, T> g) {
        return obj -> g.apply((PassthroughSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frameControl;
        private String videoSelectorMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PassthroughSettings model) {
            this.frameControl(model.frameControl);
            this.videoSelectorMode(model.videoSelectorMode);
        }

        public final String getFrameControl() {
            return this.frameControl;
        }

        public final void setFrameControl(String frameControl) {
            this.frameControl = frameControl;
        }

        @Override
        public final Builder frameControl(String frameControl) {
            this.frameControl = frameControl;
            return this;
        }

        @Override
        public final Builder frameControl(FrameControl frameControl) {
            this.frameControl(frameControl == null ? null : frameControl.toString());
            return this;
        }

        public final String getVideoSelectorMode() {
            return this.videoSelectorMode;
        }

        public final void setVideoSelectorMode(String videoSelectorMode) {
            this.videoSelectorMode = videoSelectorMode;
        }

        @Override
        public final Builder videoSelectorMode(String videoSelectorMode) {
            this.videoSelectorMode = videoSelectorMode;
            return this;
        }

        @Override
        public final Builder videoSelectorMode(VideoSelectorMode videoSelectorMode) {
            this.videoSelectorMode(videoSelectorMode == null ? null : videoSelectorMode.toString());
            return this;
        }

        public PassthroughSettings build() {
            return new PassthroughSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PassthroughSettings> {
        public Builder frameControl(String var1);

        public Builder frameControl(FrameControl var1);

        public Builder videoSelectorMode(String var1);

        public Builder videoSelectorMode(VideoSelectorMode var1);
    }
}

