/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconvert.MediaConvertAsyncClient;
import software.amazon.awssdk.services.mediaconvert.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.mediaconvert.model.Endpoint;

public class DescribeEndpointsPublisher
implements SdkPublisher<DescribeEndpointsResponse> {
    private final MediaConvertAsyncClient client;
    private final DescribeEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEndpointsPublisher(MediaConvertAsyncClient client, DescribeEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEndpointsPublisher(MediaConvertAsyncClient client, DescribeEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Endpoint> endpoints() {
        Function<DescribeEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEndpointsResponseFetcher
    implements AsyncPageFetcher<DescribeEndpointsResponse> {
        private DescribeEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEndpointsResponse> nextPage(DescribeEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointsPublisher.this.client.describeEndpoints(DescribeEndpointsPublisher.this.firstRequest);
            }
            return DescribeEndpointsPublisher.this.client.describeEndpoints((DescribeEndpointsRequest)((Object)DescribeEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

