/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Mpeg2 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mpeg2Settings implements SdkPojo, Serializable, ToCopyableBuilder<Mpeg2Settings.Builder, Mpeg2Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdaptiveQuantization").getter(getter(Mpeg2Settings::adaptiveQuantizationAsString))
            .setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfdSignaling").getter(getter(Mpeg2Settings::afdSignalingAsString)).setter(setter(Builder::afdSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()).build();

    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorMetadata").getter(getter(Mpeg2Settings::colorMetadataAsString))
            .setter(setter(Builder::colorMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()).build();

    private static final SdkField<String> COLOR_SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorSpace").getter(getter(Mpeg2Settings::colorSpaceAsString)).setter(setter(Builder::colorSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpace").build()).build();

    private static final SdkField<String> DISPLAY_ASPECT_RATIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayAspectRatio").getter(getter(Mpeg2Settings::displayAspectRatioAsString))
            .setter(setter(Builder::displayAspectRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayAspectRatio").build())
            .build();

    private static final SdkField<Mpeg2FilterSettings> FILTER_SETTINGS_FIELD = SdkField
            .<Mpeg2FilterSettings> builder(MarshallingType.SDK_POJO).memberName("FilterSettings")
            .getter(getter(Mpeg2Settings::filterSettings)).setter(setter(Builder::filterSettings))
            .constructor(Mpeg2FilterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()).build();

    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FixedAfd").getter(getter(Mpeg2Settings::fixedAfdAsString)).setter(setter(Builder::fixedAfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(Mpeg2Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(Mpeg2Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopClosedCadence").getter(getter(Mpeg2Settings::gopClosedCadence))
            .setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Integer> GOP_NUM_B_FRAMES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopNumBFrames").getter(getter(Mpeg2Settings::gopNumBFrames)).setter(setter(Builder::gopNumBFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopNumBFrames").build()).build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(Mpeg2Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopSizeUnits").getter(getter(Mpeg2Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanType").getter(getter(Mpeg2Settings::scanTypeAsString)).setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final SdkField<String> SUBGOP_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubgopLength").getter(getter(Mpeg2Settings::subgopLengthAsString)).setter(setter(Builder::subgopLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subgopLength").build()).build();

    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimecodeInsertion").getter(getter(Mpeg2Settings::timecodeInsertionAsString))
            .setter(setter(Builder::timecodeInsertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()).build();

    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField
            .<TimecodeBurninSettings> builder(MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings")
            .getter(getter(Mpeg2Settings::timecodeBurninSettings)).setter(setter(Builder::timecodeBurninSettings))
            .constructor(TimecodeBurninSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            AFD_SIGNALING_FIELD, COLOR_METADATA_FIELD, COLOR_SPACE_FIELD, DISPLAY_ASPECT_RATIO_FIELD, FILTER_SETTINGS_FIELD,
            FIXED_AFD_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_CLOSED_CADENCE_FIELD,
            GOP_NUM_B_FRAMES_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, SCAN_TYPE_FIELD, SUBGOP_LENGTH_FIELD,
            TIMECODE_INSERTION_FIELD, TIMECODE_BURNIN_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final String afdSignaling;

    private final String colorMetadata;

    private final String colorSpace;

    private final String displayAspectRatio;

    private final Mpeg2FilterSettings filterSettings;

    private final String fixedAfd;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Integer gopClosedCadence;

    private final Integer gopNumBFrames;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final String scanType;

    private final String subgopLength;

    private final String timecodeInsertion;

    private final TimecodeBurninSettings timecodeBurninSettings;

    private Mpeg2Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.afdSignaling = builder.afdSignaling;
        this.colorMetadata = builder.colorMetadata;
        this.colorSpace = builder.colorSpace;
        this.displayAspectRatio = builder.displayAspectRatio;
        this.filterSettings = builder.filterSettings;
        this.fixedAfd = builder.fixedAfd;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopNumBFrames = builder.gopNumBFrames;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.scanType = builder.scanType;
        this.subgopLength = builder.subgopLength;
        this.timecodeInsertion = builder.timecodeInsertion;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
    }

    /**
     * Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its
     * strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows
     * intra-frame quantizers to vary, which might improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link Mpeg2AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its
     *         strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows
     *         intra-frame quantizers to vary, which might improve visual quality.
     * @see Mpeg2AdaptiveQuantization
     */
    public final Mpeg2AdaptiveQuantization adaptiveQuantization() {
        return Mpeg2AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its
     * strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows
     * intra-frame quantizers to vary, which might improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link Mpeg2AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its
     *         strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows
     *         intra-frame quantizers to vary, which might improve visual quality.
     * @see Mpeg2AdaptiveQuantization
     */
    public final String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling
     * is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will try to preserve
     * the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will use the value you
     * specify in fixedAFD.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD
     *         signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will
     *         try to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will
     *         use the value you specify in fixedAFD.
     * @see AfdSignaling
     */
    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(afdSignaling);
    }

    /**
     * Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling
     * is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will try to preserve
     * the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will use the value you
     * specify in fixedAFD.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD
     *         signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will
     *         try to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will
     *         use the value you specify in fixedAFD.
     * @see AfdSignaling
     */
    public final String afdSignalingAsString() {
        return afdSignaling;
    }

    /**
     * Specifies whether to include the color space metadata. The metadata describes the color space that applies to the
     * video (the colorSpace field). We recommend that you insert the metadata.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link Mpeg2ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Specifies whether to include the color space metadata. The metadata describes the color space that
     *         applies to the video (the colorSpace field). We recommend that you insert the metadata.
     * @see Mpeg2ColorMetadata
     */
    public final Mpeg2ColorMetadata colorMetadata() {
        return Mpeg2ColorMetadata.fromValue(colorMetadata);
    }

    /**
     * Specifies whether to include the color space metadata. The metadata describes the color space that applies to the
     * video (the colorSpace field). We recommend that you insert the metadata.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link Mpeg2ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Specifies whether to include the color space metadata. The metadata describes the color space that
     *         applies to the video (the colorSpace field). We recommend that you insert the metadata.
     * @see Mpeg2ColorMetadata
     */
    public final String colorMetadataAsString() {
        return colorMetadata;
    }

    /**
     * Choose the type of color space conversion to apply to the output. For detailed information on setting up both the
     * input and the output to obtain the desired color space in the output, see the section on \"MediaLive Features -
     * Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of the input content - do
     * not convert it. AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorSpace} will
     * return {@link Mpeg2ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorSpaceAsString}.
     * </p>
     * 
     * @return Choose the type of color space conversion to apply to the output. For detailed information on setting up
     *         both the input and the output to obtain the desired color space in the output, see the section on
     *         \"MediaLive Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color
     *         space of the input content - do not convert it. AUTO:Convert all content that is SD to rec 601, and
     *         convert all content that is HD to rec 709.
     * @see Mpeg2ColorSpace
     */
    public final Mpeg2ColorSpace colorSpace() {
        return Mpeg2ColorSpace.fromValue(colorSpace);
    }

    /**
     * Choose the type of color space conversion to apply to the output. For detailed information on setting up both the
     * input and the output to obtain the desired color space in the output, see the section on \"MediaLive Features -
     * Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of the input content - do
     * not convert it. AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorSpace} will
     * return {@link Mpeg2ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorSpaceAsString}.
     * </p>
     * 
     * @return Choose the type of color space conversion to apply to the output. For detailed information on setting up
     *         both the input and the output to obtain the desired color space in the output, see the section on
     *         \"MediaLive Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color
     *         space of the input content - do not convert it. AUTO:Convert all content that is SD to rec 601, and
     *         convert all content that is HD to rec 709.
     * @see Mpeg2ColorSpace
     */
    public final String colorSpaceAsString() {
        return colorSpace;
    }

    /**
     * Sets the pixel aspect ratio for the encode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #displayAspectRatio} will return {@link Mpeg2DisplayRatio#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #displayAspectRatioAsString}.
     * </p>
     * 
     * @return Sets the pixel aspect ratio for the encode.
     * @see Mpeg2DisplayRatio
     */
    public final Mpeg2DisplayRatio displayAspectRatio() {
        return Mpeg2DisplayRatio.fromValue(displayAspectRatio);
    }

    /**
     * Sets the pixel aspect ratio for the encode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #displayAspectRatio} will return {@link Mpeg2DisplayRatio#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #displayAspectRatioAsString}.
     * </p>
     * 
     * @return Sets the pixel aspect ratio for the encode.
     * @see Mpeg2DisplayRatio
     */
    public final String displayAspectRatioAsString() {
        return displayAspectRatio;
    }

    /**
     * Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not
     * choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source content that is noisy
     * (when it has excessive digital artifacts) and source content that is clean. When the content is noisy, the filter
     * cleans up the source content before the encoding phase, with these two effects: First, it improves the output
     * video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive
     * does not waste bits on encoding noise. When the content is reasonably clean, the filter tends to decrease the
     * bitrate.
     * 
     * @return Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do
     *         not choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source content
     *         that is noisy (when it has excessive digital artifacts) and source content that is clean. When the
     *         content is noisy, the filter cleans up the source content before the encoding phase, with these two
     *         effects: First, it improves the output video quality because the content has been cleaned up. Secondly,
     *         it decreases the bandwidth because MediaLive does not waste bits on encoding noise. When the content is
     *         reasonably clean, the filter tends to decrease the bitrate.
     */
    public final Mpeg2FilterSettings filterSettings() {
        return filterSettings;
    }

    /**
     * Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames
     * of the video encode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all
     *         frames of the video encode.
     * @see FixedAfd
     */
    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(fixedAfd);
    }

    /**
     * Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames
     * of the video encode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all
     *         frames of the video encode.
     * @see FixedAfd
     */
    public final String fixedAfdAsString() {
        return fixedAfd;
    }

    /**
     * description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the
     * denominator. For example, 24000 / 1001 = 23.976 FPS.
     * 
     * @return description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by
     *         the denominator. For example, 24000 / 1001 = 23.976 FPS.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For
     * example, 24000 / 1001 = 23.976 FPS.
     * 
     * @return The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator.
     *         For example, 24000 / 1001 = 23.976 FPS.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * MPEG2: default is open GOP.
     * 
     * @return MPEG2: default is open GOP.
     */
    public final Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame
     * is, use the default.
     * 
     * @return Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a
     *         B-frame is, use the default.
     */
    public final Integer gopNumBFrames() {
        return gopNumBFrames;
    }

    /**
     * Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do
     * not know what GOP is, use the default. If gopSizeUnits is frames, then the gopSize must be an integer and must be
     * greater than or equal to 1. If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to
     * be an integer.
     * 
     * @return Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If
     *         you do not know what GOP is, use the default. If gopSizeUnits is frames, then the gopSize must be an
     *         integer and must be greater than or equal to 1. If gopSizeUnits is seconds, the gopSize must be greater
     *         than 0, but does not need to be an integer.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan
     * to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the
     * gop size to a frame count.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link Mpeg2GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do
     *         not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will
     *         internally convert the gop size to a frame count.
     * @see Mpeg2GopSizeUnits
     */
    public final Mpeg2GopSizeUnits gopSizeUnits() {
        return Mpeg2GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan
     * to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the
     * gop size to a frame count.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link Mpeg2GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do
     *         not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will
     *         internally convert the gop size to a frame count.
     * @see Mpeg2GopSizeUnits
     */
    public final String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link Mpeg2ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
     * @see Mpeg2ScanType
     */
    public final Mpeg2ScanType scanType() {
        return Mpeg2ScanType.fromValue(scanType);
    }

    /**
     * Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link Mpeg2ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
     * @see Mpeg2ScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    /**
     * Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of B-frames
     * in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of B-frames in each
     * sub-GOP, to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subgopLength} will
     * return {@link Mpeg2SubGopLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subgopLengthAsString}.
     * </p>
     * 
     * @return Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of
     *         B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of
     *         B-frames in each sub-GOP, to improve visual quality.
     * @see Mpeg2SubGopLength
     */
    public final Mpeg2SubGopLength subgopLength() {
        return Mpeg2SubGopLength.fromValue(subgopLength);
    }

    /**
     * Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of B-frames
     * in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of B-frames in each
     * sub-GOP, to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subgopLength} will
     * return {@link Mpeg2SubGopLength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subgopLengthAsString}.
     * </p>
     * 
     * @return Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of
     *         B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of
     *         B-frames in each sub-GOP, to improve visual quality.
     * @see Mpeg2SubGopLength
     */
    public final String subgopLengthAsString() {
        return subgopLength;
    }

    /**
     * Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the
     * input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in the
     * MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode metadata in the GOP
     * header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link Mpeg2TimecodeInsertionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up
     *         the input and the output for a timecode, see the section on \"MediaLive Features - Timecode
     *         configuration\" in the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include
     *         timecode metadata in the GOP header.
     * @see Mpeg2TimecodeInsertionBehavior
     */
    public final Mpeg2TimecodeInsertionBehavior timecodeInsertion() {
        return Mpeg2TimecodeInsertionBehavior.fromValue(timecodeInsertion);
    }

    /**
     * Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the
     * input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in the
     * MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode metadata in the GOP
     * header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link Mpeg2TimecodeInsertionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up
     *         the input and the output for a timecode, see the section on \"MediaLive Features - Timecode
     *         configuration\" in the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include
     *         timecode metadata in the GOP header.
     * @see Mpeg2TimecodeInsertionBehavior
     */
    public final String timecodeInsertionAsString() {
        return timecodeInsertion;
    }

    /**
     * Timecode burn-in settings
     * 
     * @return Timecode burn-in settings
     */
    public final TimecodeBurninSettings timecodeBurninSettings() {
        return timecodeBurninSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayAspectRatioAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(gopNumBFrames());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subgopLengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeInsertionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeBurninSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mpeg2Settings)) {
            return false;
        }
        Mpeg2Settings other = (Mpeg2Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(afdSignalingAsString(), other.afdSignalingAsString())
                && Objects.equals(colorMetadataAsString(), other.colorMetadataAsString())
                && Objects.equals(colorSpaceAsString(), other.colorSpaceAsString())
                && Objects.equals(displayAspectRatioAsString(), other.displayAspectRatioAsString())
                && Objects.equals(filterSettings(), other.filterSettings())
                && Objects.equals(fixedAfdAsString(), other.fixedAfdAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence())
                && Objects.equals(gopNumBFrames(), other.gopNumBFrames()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(scanTypeAsString(), other.scanTypeAsString())
                && Objects.equals(subgopLengthAsString(), other.subgopLengthAsString())
                && Objects.equals(timecodeInsertionAsString(), other.timecodeInsertionAsString())
                && Objects.equals(timecodeBurninSettings(), other.timecodeBurninSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Mpeg2Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("AfdSignaling", afdSignalingAsString()).add("ColorMetadata", colorMetadataAsString())
                .add("ColorSpace", colorSpaceAsString()).add("DisplayAspectRatio", displayAspectRatioAsString())
                .add("FilterSettings", filterSettings()).add("FixedAfd", fixedAfdAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopClosedCadence", gopClosedCadence()).add("GopNumBFrames", gopNumBFrames()).add("GopSize", gopSize())
                .add("GopSizeUnits", gopSizeUnitsAsString()).add("ScanType", scanTypeAsString())
                .add("SubgopLength", subgopLengthAsString()).add("TimecodeInsertion", timecodeInsertionAsString())
                .add("TimecodeBurninSettings", timecodeBurninSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "AfdSignaling":
            return Optional.ofNullable(clazz.cast(afdSignalingAsString()));
        case "ColorMetadata":
            return Optional.ofNullable(clazz.cast(colorMetadataAsString()));
        case "ColorSpace":
            return Optional.ofNullable(clazz.cast(colorSpaceAsString()));
        case "DisplayAspectRatio":
            return Optional.ofNullable(clazz.cast(displayAspectRatioAsString()));
        case "FilterSettings":
            return Optional.ofNullable(clazz.cast(filterSettings()));
        case "FixedAfd":
            return Optional.ofNullable(clazz.cast(fixedAfdAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "GopNumBFrames":
            return Optional.ofNullable(clazz.cast(gopNumBFrames()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "ScanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        case "SubgopLength":
            return Optional.ofNullable(clazz.cast(subgopLengthAsString()));
        case "TimecodeInsertion":
            return Optional.ofNullable(clazz.cast(timecodeInsertionAsString()));
        case "TimecodeBurninSettings":
            return Optional.ofNullable(clazz.cast(timecodeBurninSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mpeg2Settings, T> g) {
        return obj -> g.apply((Mpeg2Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mpeg2Settings> {
        /**
         * Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its
         * strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows
         * intra-frame quantizers to vary, which might improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set
         *        its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive
         *        allows intra-frame quantizers to vary, which might improve visual quality.
         * @see Mpeg2AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its
         * strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows
         * intra-frame quantizers to vary, which might improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set
         *        its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive
         *        allows intra-frame quantizers to vary, which might improve visual quality.
         * @see Mpeg2AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2AdaptiveQuantization
         */
        Builder adaptiveQuantization(Mpeg2AdaptiveQuantization adaptiveQuantization);

        /**
         * Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD
         * signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will try
         * to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will use the
         * value you specify in fixedAFD.
         * 
         * @param afdSignaling
         *        Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD
         *        signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive
         *        will try to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED:
         *        MediaLive will use the value you specify in fixedAFD.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(String afdSignaling);

        /**
         * Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD
         * signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will try
         * to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will use the
         * value you specify in fixedAFD.
         * 
         * @param afdSignaling
         *        Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD
         *        signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive
         *        will try to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED:
         *        MediaLive will use the value you specify in fixedAFD.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(AfdSignaling afdSignaling);

        /**
         * Specifies whether to include the color space metadata. The metadata describes the color space that applies to
         * the video (the colorSpace field). We recommend that you insert the metadata.
         * 
         * @param colorMetadata
         *        Specifies whether to include the color space metadata. The metadata describes the color space that
         *        applies to the video (the colorSpace field). We recommend that you insert the metadata.
         * @see Mpeg2ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ColorMetadata
         */
        Builder colorMetadata(String colorMetadata);

        /**
         * Specifies whether to include the color space metadata. The metadata describes the color space that applies to
         * the video (the colorSpace field). We recommend that you insert the metadata.
         * 
         * @param colorMetadata
         *        Specifies whether to include the color space metadata. The metadata describes the color space that
         *        applies to the video (the colorSpace field). We recommend that you insert the metadata.
         * @see Mpeg2ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ColorMetadata
         */
        Builder colorMetadata(Mpeg2ColorMetadata colorMetadata);

        /**
         * Choose the type of color space conversion to apply to the output. For detailed information on setting up both
         * the input and the output to obtain the desired color space in the output, see the section on \"MediaLive
         * Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of the input
         * content - do not convert it. AUTO:Convert all content that is SD to rec 601, and convert all content that is
         * HD to rec 709.
         * 
         * @param colorSpace
         *        Choose the type of color space conversion to apply to the output. For detailed information on setting
         *        up both the input and the output to obtain the desired color space in the output, see the section on
         *        \"MediaLive Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color
         *        space of the input content - do not convert it. AUTO:Convert all content that is SD to rec 601, and
         *        convert all content that is HD to rec 709.
         * @see Mpeg2ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ColorSpace
         */
        Builder colorSpace(String colorSpace);

        /**
         * Choose the type of color space conversion to apply to the output. For detailed information on setting up both
         * the input and the output to obtain the desired color space in the output, see the section on \"MediaLive
         * Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of the input
         * content - do not convert it. AUTO:Convert all content that is SD to rec 601, and convert all content that is
         * HD to rec 709.
         * 
         * @param colorSpace
         *        Choose the type of color space conversion to apply to the output. For detailed information on setting
         *        up both the input and the output to obtain the desired color space in the output, see the section on
         *        \"MediaLive Features - Video - color space\" in the MediaLive User Guide. PASSTHROUGH: Keep the color
         *        space of the input content - do not convert it. AUTO:Convert all content that is SD to rec 601, and
         *        convert all content that is HD to rec 709.
         * @see Mpeg2ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ColorSpace
         */
        Builder colorSpace(Mpeg2ColorSpace colorSpace);

        /**
         * Sets the pixel aspect ratio for the encode.
         * 
         * @param displayAspectRatio
         *        Sets the pixel aspect ratio for the encode.
         * @see Mpeg2DisplayRatio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2DisplayRatio
         */
        Builder displayAspectRatio(String displayAspectRatio);

        /**
         * Sets the pixel aspect ratio for the encode.
         * 
         * @param displayAspectRatio
         *        Sets the pixel aspect ratio for the encode.
         * @see Mpeg2DisplayRatio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2DisplayRatio
         */
        Builder displayAspectRatio(Mpeg2DisplayRatio displayAspectRatio);

        /**
         * Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not
         * choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source content that is
         * noisy (when it has excessive digital artifacts) and source content that is clean. When the content is noisy,
         * the filter cleans up the source content before the encoding phase, with these two effects: First, it improves
         * the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth
         * because MediaLive does not waste bits on encoding noise. When the content is reasonably clean, the filter
         * tends to decrease the bitrate.
         * 
         * @param filterSettings
         *        Optionally specify a noise reduction filter, which can improve quality of compressed content. If you
         *        do not choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source
         *        content that is noisy (when it has excessive digital artifacts) and source content that is clean. When
         *        the content is noisy, the filter cleans up the source content before the encoding phase, with these
         *        two effects: First, it improves the output video quality because the content has been cleaned up.
         *        Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise. When the
         *        content is reasonably clean, the filter tends to decrease the bitrate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterSettings(Mpeg2FilterSettings filterSettings);

        /**
         * Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not
         * choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source content that is
         * noisy (when it has excessive digital artifacts) and source content that is clean. When the content is noisy,
         * the filter cleans up the source content before the encoding phase, with these two effects: First, it improves
         * the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth
         * because MediaLive does not waste bits on encoding noise. When the content is reasonably clean, the filter
         * tends to decrease the bitrate. This is a convenience method that creates an instance of the
         * {@link Mpeg2FilterSettings.Builder} avoiding the need to create one manually via
         * {@link Mpeg2FilterSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Mpeg2FilterSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #filterSettings(Mpeg2FilterSettings)}.
         * 
         * @param filterSettings
         *        a consumer that will call methods on {@link Mpeg2FilterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterSettings(Mpeg2FilterSettings)
         */
        default Builder filterSettings(Consumer<Mpeg2FilterSettings.Builder> filterSettings) {
            return filterSettings(Mpeg2FilterSettings.builder().applyMutation(filterSettings).build());
        }

        /**
         * Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all
         * frames of the video encode.
         * 
         * @param fixedAfd
         *        Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on
         *        all frames of the video encode.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(String fixedAfd);

        /**
         * Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all
         * frames of the video encode.
         * 
         * @param fixedAfd
         *        Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on
         *        all frames of the video encode.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(FixedAfd fixedAfd);

        /**
         * description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the
         * denominator. For example, 24000 / 1001 = 23.976 FPS.
         * 
         * @param framerateDenominator
         *        description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by
         *        the denominator. For example, 24000 / 1001 = 23.976 FPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For
         * example, 24000 / 1001 = 23.976 FPS.
         * 
         * @param framerateNumerator
         *        The framerate numerator. For example, 24000. The framerate is the numerator divided by the
         *        denominator. For example, 24000 / 1001 = 23.976 FPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * MPEG2: default is open GOP.
         * 
         * @param gopClosedCadence
         *        MPEG2: default is open GOP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a
         * B-frame is, use the default.
         * 
         * @param gopNumBFrames
         *        Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what
         *        a B-frame is, use the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopNumBFrames(Integer gopNumBFrames);

        /**
         * Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you
         * do not know what GOP is, use the default. If gopSizeUnits is frames, then the gopSize must be an integer and
         * must be greater than or equal to 1. If gopSizeUnits is seconds, the gopSize must be greater than 0, but does
         * not need to be an integer.
         * 
         * @param gopSize
         *        Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits.
         *        If you do not know what GOP is, use the default. If gopSizeUnits is frames, then the gopSize must be
         *        an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, the gopSize must be
         *        greater than 0, but does not need to be an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not
         * plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally
         * convert the gop size to a frame count.
         * 
         * @param gopSizeUnits
         *        Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you
         *        do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will
         *        internally convert the gop size to a frame count.
         * @see Mpeg2GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not
         * plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally
         * convert the gop size to a frame count.
         * 
         * @param gopSizeUnits
         *        Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you
         *        do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will
         *        internally convert the gop size to a frame count.
         * @see Mpeg2GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2GopSizeUnits
         */
        Builder gopSizeUnits(Mpeg2GopSizeUnits gopSizeUnits);

        /**
         * Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
         * 
         * @param scanType
         *        Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
         * @see Mpeg2ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ScanType
         */
        Builder scanType(String scanType);

        /**
         * Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
         * 
         * @param scanType
         *        Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
         * @see Mpeg2ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2ScanType
         */
        Builder scanType(Mpeg2ScanType scanType);

        /**
         * Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of
         * B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of
         * B-frames in each sub-GOP, to improve visual quality.
         * 
         * @param subgopLength
         *        Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number
         *        of B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number
         *        of B-frames in each sub-GOP, to improve visual quality.
         * @see Mpeg2SubGopLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SubGopLength
         */
        Builder subgopLength(String subgopLength);

        /**
         * Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of
         * B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of
         * B-frames in each sub-GOP, to improve visual quality.
         * 
         * @param subgopLength
         *        Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number
         *        of B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number
         *        of B-frames in each sub-GOP, to improve visual quality.
         * @see Mpeg2SubGopLength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2SubGopLength
         */
        Builder subgopLength(Mpeg2SubGopLength subgopLength);

        /**
         * Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the
         * input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in
         * the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode metadata in the
         * GOP header.
         * 
         * @param timecodeInsertion
         *        Determines how MediaLive inserts timecodes in the output video. For detailed information about setting
         *        up the input and the output for a timecode, see the section on \"MediaLive Features - Timecode
         *        configuration\" in the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include
         *        timecode metadata in the GOP header.
         * @see Mpeg2TimecodeInsertionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2TimecodeInsertionBehavior
         */
        Builder timecodeInsertion(String timecodeInsertion);

        /**
         * Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the
         * input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in
         * the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode metadata in the
         * GOP header.
         * 
         * @param timecodeInsertion
         *        Determines how MediaLive inserts timecodes in the output video. For detailed information about setting
         *        up the input and the output for a timecode, see the section on \"MediaLive Features - Timecode
         *        configuration\" in the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include
         *        timecode metadata in the GOP header.
         * @see Mpeg2TimecodeInsertionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mpeg2TimecodeInsertionBehavior
         */
        Builder timecodeInsertion(Mpeg2TimecodeInsertionBehavior timecodeInsertion);

        /**
         * Timecode burn-in settings
         * 
         * @param timecodeBurninSettings
         *        Timecode burn-in settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings);

        /**
         * Timecode burn-in settings This is a convenience method that creates an instance of the
         * {@link TimecodeBurninSettings.Builder} avoiding the need to create one manually via
         * {@link TimecodeBurninSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimecodeBurninSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #timecodeBurninSettings(TimecodeBurninSettings)}.
         * 
         * @param timecodeBurninSettings
         *        a consumer that will call methods on {@link TimecodeBurninSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeBurninSettings(TimecodeBurninSettings)
         */
        default Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return timecodeBurninSettings(TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private String afdSignaling;

        private String colorMetadata;

        private String colorSpace;

        private String displayAspectRatio;

        private Mpeg2FilterSettings filterSettings;

        private String fixedAfd;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Integer gopClosedCadence;

        private Integer gopNumBFrames;

        private Double gopSize;

        private String gopSizeUnits;

        private String scanType;

        private String subgopLength;

        private String timecodeInsertion;

        private TimecodeBurninSettings timecodeBurninSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Mpeg2Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            afdSignaling(model.afdSignaling);
            colorMetadata(model.colorMetadata);
            colorSpace(model.colorSpace);
            displayAspectRatio(model.displayAspectRatio);
            filterSettings(model.filterSettings);
            fixedAfd(model.fixedAfd);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopClosedCadence(model.gopClosedCadence);
            gopNumBFrames(model.gopNumBFrames);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            scanType(model.scanType);
            subgopLength(model.subgopLength);
            timecodeInsertion(model.timecodeInsertion);
            timecodeBurninSettings(model.timecodeBurninSettings);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(Mpeg2AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getAfdSignaling() {
            return afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getColorMetadata() {
            return colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(Mpeg2ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final String getColorSpace() {
            return colorSpace;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(Mpeg2ColorSpace colorSpace) {
            this.colorSpace(colorSpace == null ? null : colorSpace.toString());
            return this;
        }

        public final String getDisplayAspectRatio() {
            return displayAspectRatio;
        }

        public final void setDisplayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
        }

        @Override
        public final Builder displayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
            return this;
        }

        @Override
        public final Builder displayAspectRatio(Mpeg2DisplayRatio displayAspectRatio) {
            this.displayAspectRatio(displayAspectRatio == null ? null : displayAspectRatio.toString());
            return this;
        }

        public final Mpeg2FilterSettings.Builder getFilterSettings() {
            return filterSettings != null ? filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(Mpeg2FilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        public final Builder filterSettings(Mpeg2FilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final String getFixedAfd() {
            return fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Integer getGopNumBFrames() {
            return gopNumBFrames;
        }

        public final void setGopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
        }

        @Override
        public final Builder gopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
            return this;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(Mpeg2GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(Mpeg2ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final String getSubgopLength() {
            return subgopLength;
        }

        public final void setSubgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
        }

        @Override
        public final Builder subgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
            return this;
        }

        @Override
        public final Builder subgopLength(Mpeg2SubGopLength subgopLength) {
            this.subgopLength(subgopLength == null ? null : subgopLength.toString());
            return this;
        }

        public final String getTimecodeInsertion() {
            return timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(Mpeg2TimecodeInsertionBehavior timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return timecodeBurninSettings != null ? timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        @Override
        public Mpeg2Settings build() {
            return new Mpeg2Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
