/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Nielsen CBET
 */
@Generated("software.amazon.awssdk:codegen")
public final class NielsenCBET implements SdkPojo, Serializable, ToCopyableBuilder<NielsenCBET.Builder, NielsenCBET> {
    private static final SdkField<String> CBET_CHECK_DIGIT_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CbetCheckDigitString").getter(getter(NielsenCBET::cbetCheckDigitString))
            .setter(setter(Builder::cbetCheckDigitString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cbetCheckDigitString").build())
            .build();

    private static final SdkField<String> CBET_STEPASIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CbetStepaside").getter(getter(NielsenCBET::cbetStepasideAsString))
            .setter(setter(Builder::cbetStepaside))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cbetStepaside").build()).build();

    private static final SdkField<String> CSID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Csid")
            .getter(getter(NielsenCBET::csid)).setter(setter(Builder::csid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CBET_CHECK_DIGIT_STRING_FIELD,
            CBET_STEPASIDE_FIELD, CSID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cbetCheckDigitString;

    private final String cbetStepaside;

    private final String csid;

    private NielsenCBET(BuilderImpl builder) {
        this.cbetCheckDigitString = builder.cbetCheckDigitString;
        this.cbetStepaside = builder.cbetStepaside;
        this.csid = builder.csid;
    }

    /**
     * Enter the CBET check digits to use in the watermark.
     * 
     * @return Enter the CBET check digits to use in the watermark.
     */
    public final String cbetCheckDigitString() {
        return cbetCheckDigitString;
    }

    /**
     * Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cbetStepaside}
     * will return {@link NielsenWatermarksCbetStepaside#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #cbetStepasideAsString}.
     * </p>
     * 
     * @return Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
     * @see NielsenWatermarksCbetStepaside
     */
    public final NielsenWatermarksCbetStepaside cbetStepaside() {
        return NielsenWatermarksCbetStepaside.fromValue(cbetStepaside);
    }

    /**
     * Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cbetStepaside}
     * will return {@link NielsenWatermarksCbetStepaside#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #cbetStepasideAsString}.
     * </p>
     * 
     * @return Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
     * @see NielsenWatermarksCbetStepaside
     */
    public final String cbetStepasideAsString() {
        return cbetStepaside;
    }

    /**
     * Enter the CBET Source ID (CSID) to use in the watermark
     * 
     * @return Enter the CBET Source ID (CSID) to use in the watermark
     */
    public final String csid() {
        return csid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cbetCheckDigitString());
        hashCode = 31 * hashCode + Objects.hashCode(cbetStepasideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(csid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenCBET)) {
            return false;
        }
        NielsenCBET other = (NielsenCBET) obj;
        return Objects.equals(cbetCheckDigitString(), other.cbetCheckDigitString())
                && Objects.equals(cbetStepasideAsString(), other.cbetStepasideAsString()) && Objects.equals(csid(), other.csid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NielsenCBET").add("CbetCheckDigitString", cbetCheckDigitString())
                .add("CbetStepaside", cbetStepasideAsString()).add("Csid", csid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CbetCheckDigitString":
            return Optional.ofNullable(clazz.cast(cbetCheckDigitString()));
        case "CbetStepaside":
            return Optional.ofNullable(clazz.cast(cbetStepasideAsString()));
        case "Csid":
            return Optional.ofNullable(clazz.cast(csid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NielsenCBET, T> g) {
        return obj -> g.apply((NielsenCBET) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NielsenCBET> {
        /**
         * Enter the CBET check digits to use in the watermark.
         * 
         * @param cbetCheckDigitString
         *        Enter the CBET check digits to use in the watermark.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cbetCheckDigitString(String cbetCheckDigitString);

        /**
         * Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
         * 
         * @param cbetStepaside
         *        Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
         * @see NielsenWatermarksCbetStepaside
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenWatermarksCbetStepaside
         */
        Builder cbetStepaside(String cbetStepaside);

        /**
         * Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
         * 
         * @param cbetStepaside
         *        Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
         * @see NielsenWatermarksCbetStepaside
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenWatermarksCbetStepaside
         */
        Builder cbetStepaside(NielsenWatermarksCbetStepaside cbetStepaside);

        /**
         * Enter the CBET Source ID (CSID) to use in the watermark
         * 
         * @param csid
         *        Enter the CBET Source ID (CSID) to use in the watermark
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csid(String csid);
    }

    static final class BuilderImpl implements Builder {
        private String cbetCheckDigitString;

        private String cbetStepaside;

        private String csid;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenCBET model) {
            cbetCheckDigitString(model.cbetCheckDigitString);
            cbetStepaside(model.cbetStepaside);
            csid(model.csid);
        }

        public final String getCbetCheckDigitString() {
            return cbetCheckDigitString;
        }

        public final void setCbetCheckDigitString(String cbetCheckDigitString) {
            this.cbetCheckDigitString = cbetCheckDigitString;
        }

        @Override
        public final Builder cbetCheckDigitString(String cbetCheckDigitString) {
            this.cbetCheckDigitString = cbetCheckDigitString;
            return this;
        }

        public final String getCbetStepaside() {
            return cbetStepaside;
        }

        public final void setCbetStepaside(String cbetStepaside) {
            this.cbetStepaside = cbetStepaside;
        }

        @Override
        public final Builder cbetStepaside(String cbetStepaside) {
            this.cbetStepaside = cbetStepaside;
            return this;
        }

        @Override
        public final Builder cbetStepaside(NielsenWatermarksCbetStepaside cbetStepaside) {
            this.cbetStepaside(cbetStepaside == null ? null : cbetStepaside.toString());
            return this;
        }

        public final String getCsid() {
            return csid;
        }

        public final void setCsid(String csid) {
            this.csid = csid;
        }

        @Override
        public final Builder csid(String csid) {
            this.csid = csid;
            return this;
        }

        @Override
        public NielsenCBET build() {
            return new NielsenCBET(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
