/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output Locking Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputLockingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputLockingSettings.Builder, OutputLockingSettings> {
    private static final SdkField<EpochLockingSettings> EPOCH_LOCKING_SETTINGS_FIELD = SdkField
            .<EpochLockingSettings> builder(MarshallingType.SDK_POJO).memberName("EpochLockingSettings")
            .getter(getter(OutputLockingSettings::epochLockingSettings)).setter(setter(Builder::epochLockingSettings))
            .constructor(EpochLockingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epochLockingSettings").build())
            .build();

    private static final SdkField<PipelineLockingSettings> PIPELINE_LOCKING_SETTINGS_FIELD = SdkField
            .<PipelineLockingSettings> builder(MarshallingType.SDK_POJO).memberName("PipelineLockingSettings")
            .getter(getter(OutputLockingSettings::pipelineLockingSettings)).setter(setter(Builder::pipelineLockingSettings))
            .constructor(PipelineLockingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineLockingSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPOCH_LOCKING_SETTINGS_FIELD,
            PIPELINE_LOCKING_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final EpochLockingSettings epochLockingSettings;

    private final PipelineLockingSettings pipelineLockingSettings;

    private OutputLockingSettings(BuilderImpl builder) {
        this.epochLockingSettings = builder.epochLockingSettings;
        this.pipelineLockingSettings = builder.pipelineLockingSettings;
    }

    /**
     * Returns the value of the EpochLockingSettings property for this object.
     * 
     * @return The value of the EpochLockingSettings property for this object.
     */
    public final EpochLockingSettings epochLockingSettings() {
        return epochLockingSettings;
    }

    /**
     * Returns the value of the PipelineLockingSettings property for this object.
     * 
     * @return The value of the PipelineLockingSettings property for this object.
     */
    public final PipelineLockingSettings pipelineLockingSettings() {
        return pipelineLockingSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(epochLockingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineLockingSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputLockingSettings)) {
            return false;
        }
        OutputLockingSettings other = (OutputLockingSettings) obj;
        return Objects.equals(epochLockingSettings(), other.epochLockingSettings())
                && Objects.equals(pipelineLockingSettings(), other.pipelineLockingSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputLockingSettings").add("EpochLockingSettings", epochLockingSettings())
                .add("PipelineLockingSettings", pipelineLockingSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EpochLockingSettings":
            return Optional.ofNullable(clazz.cast(epochLockingSettings()));
        case "PipelineLockingSettings":
            return Optional.ofNullable(clazz.cast(pipelineLockingSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputLockingSettings, T> g) {
        return obj -> g.apply((OutputLockingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputLockingSettings> {
        /**
         * Sets the value of the EpochLockingSettings property for this object.
         *
         * @param epochLockingSettings
         *        The new value for the EpochLockingSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epochLockingSettings(EpochLockingSettings epochLockingSettings);

        /**
         * Sets the value of the EpochLockingSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EpochLockingSettings.Builder} avoiding
         * the need to create one manually via {@link EpochLockingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EpochLockingSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #epochLockingSettings(EpochLockingSettings)}.
         * 
         * @param epochLockingSettings
         *        a consumer that will call methods on {@link EpochLockingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #epochLockingSettings(EpochLockingSettings)
         */
        default Builder epochLockingSettings(Consumer<EpochLockingSettings.Builder> epochLockingSettings) {
            return epochLockingSettings(EpochLockingSettings.builder().applyMutation(epochLockingSettings).build());
        }

        /**
         * Sets the value of the PipelineLockingSettings property for this object.
         *
         * @param pipelineLockingSettings
         *        The new value for the PipelineLockingSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineLockingSettings(PipelineLockingSettings pipelineLockingSettings);

        /**
         * Sets the value of the PipelineLockingSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PipelineLockingSettings.Builder} avoiding
         * the need to create one manually via {@link PipelineLockingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineLockingSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #pipelineLockingSettings(PipelineLockingSettings)}.
         * 
         * @param pipelineLockingSettings
         *        a consumer that will call methods on {@link PipelineLockingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineLockingSettings(PipelineLockingSettings)
         */
        default Builder pipelineLockingSettings(Consumer<PipelineLockingSettings.Builder> pipelineLockingSettings) {
            return pipelineLockingSettings(PipelineLockingSettings.builder().applyMutation(pipelineLockingSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EpochLockingSettings epochLockingSettings;

        private PipelineLockingSettings pipelineLockingSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputLockingSettings model) {
            epochLockingSettings(model.epochLockingSettings);
            pipelineLockingSettings(model.pipelineLockingSettings);
        }

        public final EpochLockingSettings.Builder getEpochLockingSettings() {
            return epochLockingSettings != null ? epochLockingSettings.toBuilder() : null;
        }

        public final void setEpochLockingSettings(EpochLockingSettings.BuilderImpl epochLockingSettings) {
            this.epochLockingSettings = epochLockingSettings != null ? epochLockingSettings.build() : null;
        }

        @Override
        public final Builder epochLockingSettings(EpochLockingSettings epochLockingSettings) {
            this.epochLockingSettings = epochLockingSettings;
            return this;
        }

        public final PipelineLockingSettings.Builder getPipelineLockingSettings() {
            return pipelineLockingSettings != null ? pipelineLockingSettings.toBuilder() : null;
        }

        public final void setPipelineLockingSettings(PipelineLockingSettings.BuilderImpl pipelineLockingSettings) {
            this.pipelineLockingSettings = pipelineLockingSettings != null ? pipelineLockingSettings.build() : null;
        }

        @Override
        public final Builder pipelineLockingSettings(PipelineLockingSettings pipelineLockingSettings) {
            this.pipelineLockingSettings = pipelineLockingSettings;
            return this;
        }

        @Override
        public OutputLockingSettings build() {
            return new OutputLockingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
