/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Holds the settings for a single schedule action.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleActionSettings.Builder, ScheduleActionSettings> {
    private static final SdkField<HlsId3SegmentTaggingScheduleActionSettings> HLS_ID3_SEGMENT_TAGGING_SETTINGS_FIELD = SdkField
            .<HlsId3SegmentTaggingScheduleActionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("HlsId3SegmentTaggingSettings")
            .getter(getter(ScheduleActionSettings::hlsId3SegmentTaggingSettings))
            .setter(setter(Builder::hlsId3SegmentTaggingSettings))
            .constructor(HlsId3SegmentTaggingScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsId3SegmentTaggingSettings")
                    .build()).build();

    private static final SdkField<HlsTimedMetadataScheduleActionSettings> HLS_TIMED_METADATA_SETTINGS_FIELD = SdkField
            .<HlsTimedMetadataScheduleActionSettings> builder(MarshallingType.SDK_POJO).memberName("HlsTimedMetadataSettings")
            .getter(getter(ScheduleActionSettings::hlsTimedMetadataSettings)).setter(setter(Builder::hlsTimedMetadataSettings))
            .constructor(HlsTimedMetadataScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsTimedMetadataSettings").build())
            .build();

    private static final SdkField<InputPrepareScheduleActionSettings> INPUT_PREPARE_SETTINGS_FIELD = SdkField
            .<InputPrepareScheduleActionSettings> builder(MarshallingType.SDK_POJO).memberName("InputPrepareSettings")
            .getter(getter(ScheduleActionSettings::inputPrepareSettings)).setter(setter(Builder::inputPrepareSettings))
            .constructor(InputPrepareScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPrepareSettings").build())
            .build();

    private static final SdkField<InputSwitchScheduleActionSettings> INPUT_SWITCH_SETTINGS_FIELD = SdkField
            .<InputSwitchScheduleActionSettings> builder(MarshallingType.SDK_POJO).memberName("InputSwitchSettings")
            .getter(getter(ScheduleActionSettings::inputSwitchSettings)).setter(setter(Builder::inputSwitchSettings))
            .constructor(InputSwitchScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSwitchSettings").build())
            .build();

    private static final SdkField<MotionGraphicsActivateScheduleActionSettings> MOTION_GRAPHICS_IMAGE_ACTIVATE_SETTINGS_FIELD = SdkField
            .<MotionGraphicsActivateScheduleActionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MotionGraphicsImageActivateSettings")
            .getter(getter(ScheduleActionSettings::motionGraphicsImageActivateSettings))
            .setter(setter(Builder::motionGraphicsImageActivateSettings))
            .constructor(MotionGraphicsActivateScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("motionGraphicsImageActivateSettings").build()).build();

    private static final SdkField<MotionGraphicsDeactivateScheduleActionSettings> MOTION_GRAPHICS_IMAGE_DEACTIVATE_SETTINGS_FIELD = SdkField
            .<MotionGraphicsDeactivateScheduleActionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MotionGraphicsImageDeactivateSettings")
            .getter(getter(ScheduleActionSettings::motionGraphicsImageDeactivateSettings))
            .setter(setter(Builder::motionGraphicsImageDeactivateSettings))
            .constructor(MotionGraphicsDeactivateScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("motionGraphicsImageDeactivateSettings").build()).build();

    private static final SdkField<PauseStateScheduleActionSettings> PAUSE_STATE_SETTINGS_FIELD = SdkField
            .<PauseStateScheduleActionSettings> builder(MarshallingType.SDK_POJO).memberName("PauseStateSettings")
            .getter(getter(ScheduleActionSettings::pauseStateSettings)).setter(setter(Builder::pauseStateSettings))
            .constructor(PauseStateScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pauseStateSettings").build())
            .build();

    private static final SdkField<Scte35InputScheduleActionSettings> SCTE35_INPUT_SETTINGS_FIELD = SdkField
            .<Scte35InputScheduleActionSettings> builder(MarshallingType.SDK_POJO).memberName("Scte35InputSettings")
            .getter(getter(ScheduleActionSettings::scte35InputSettings)).setter(setter(Builder::scte35InputSettings))
            .constructor(Scte35InputScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35InputSettings").build())
            .build();

    private static final SdkField<Scte35ReturnToNetworkScheduleActionSettings> SCTE35_RETURN_TO_NETWORK_SETTINGS_FIELD = SdkField
            .<Scte35ReturnToNetworkScheduleActionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Scte35ReturnToNetworkSettings")
            .getter(getter(ScheduleActionSettings::scte35ReturnToNetworkSettings))
            .setter(setter(Builder::scte35ReturnToNetworkSettings))
            .constructor(Scte35ReturnToNetworkScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35ReturnToNetworkSettings")
                    .build()).build();

    private static final SdkField<Scte35SpliceInsertScheduleActionSettings> SCTE35_SPLICE_INSERT_SETTINGS_FIELD = SdkField
            .<Scte35SpliceInsertScheduleActionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("Scte35SpliceInsertSettings")
            .getter(getter(ScheduleActionSettings::scte35SpliceInsertSettings))
            .setter(setter(Builder::scte35SpliceInsertSettings))
            .constructor(Scte35SpliceInsertScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35SpliceInsertSettings").build())
            .build();

    private static final SdkField<Scte35TimeSignalScheduleActionSettings> SCTE35_TIME_SIGNAL_SETTINGS_FIELD = SdkField
            .<Scte35TimeSignalScheduleActionSettings> builder(MarshallingType.SDK_POJO).memberName("Scte35TimeSignalSettings")
            .getter(getter(ScheduleActionSettings::scte35TimeSignalSettings)).setter(setter(Builder::scte35TimeSignalSettings))
            .constructor(Scte35TimeSignalScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35TimeSignalSettings").build())
            .build();

    private static final SdkField<StaticImageActivateScheduleActionSettings> STATIC_IMAGE_ACTIVATE_SETTINGS_FIELD = SdkField
            .<StaticImageActivateScheduleActionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("StaticImageActivateSettings")
            .getter(getter(ScheduleActionSettings::staticImageActivateSettings))
            .setter(setter(Builder::staticImageActivateSettings))
            .constructor(StaticImageActivateScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticImageActivateSettings")
                    .build()).build();

    private static final SdkField<StaticImageDeactivateScheduleActionSettings> STATIC_IMAGE_DEACTIVATE_SETTINGS_FIELD = SdkField
            .<StaticImageDeactivateScheduleActionSettings> builder(MarshallingType.SDK_POJO)
            .memberName("StaticImageDeactivateSettings")
            .getter(getter(ScheduleActionSettings::staticImageDeactivateSettings))
            .setter(setter(Builder::staticImageDeactivateSettings))
            .constructor(StaticImageDeactivateScheduleActionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticImageDeactivateSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HLS_ID3_SEGMENT_TAGGING_SETTINGS_FIELD, HLS_TIMED_METADATA_SETTINGS_FIELD, INPUT_PREPARE_SETTINGS_FIELD,
            INPUT_SWITCH_SETTINGS_FIELD, MOTION_GRAPHICS_IMAGE_ACTIVATE_SETTINGS_FIELD,
            MOTION_GRAPHICS_IMAGE_DEACTIVATE_SETTINGS_FIELD, PAUSE_STATE_SETTINGS_FIELD, SCTE35_INPUT_SETTINGS_FIELD,
            SCTE35_RETURN_TO_NETWORK_SETTINGS_FIELD, SCTE35_SPLICE_INSERT_SETTINGS_FIELD, SCTE35_TIME_SIGNAL_SETTINGS_FIELD,
            STATIC_IMAGE_ACTIVATE_SETTINGS_FIELD, STATIC_IMAGE_DEACTIVATE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final HlsId3SegmentTaggingScheduleActionSettings hlsId3SegmentTaggingSettings;

    private final HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings;

    private final InputPrepareScheduleActionSettings inputPrepareSettings;

    private final InputSwitchScheduleActionSettings inputSwitchSettings;

    private final MotionGraphicsActivateScheduleActionSettings motionGraphicsImageActivateSettings;

    private final MotionGraphicsDeactivateScheduleActionSettings motionGraphicsImageDeactivateSettings;

    private final PauseStateScheduleActionSettings pauseStateSettings;

    private final Scte35InputScheduleActionSettings scte35InputSettings;

    private final Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings;

    private final Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings;

    private final Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings;

    private final StaticImageActivateScheduleActionSettings staticImageActivateSettings;

    private final StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings;

    private ScheduleActionSettings(BuilderImpl builder) {
        this.hlsId3SegmentTaggingSettings = builder.hlsId3SegmentTaggingSettings;
        this.hlsTimedMetadataSettings = builder.hlsTimedMetadataSettings;
        this.inputPrepareSettings = builder.inputPrepareSettings;
        this.inputSwitchSettings = builder.inputSwitchSettings;
        this.motionGraphicsImageActivateSettings = builder.motionGraphicsImageActivateSettings;
        this.motionGraphicsImageDeactivateSettings = builder.motionGraphicsImageDeactivateSettings;
        this.pauseStateSettings = builder.pauseStateSettings;
        this.scte35InputSettings = builder.scte35InputSettings;
        this.scte35ReturnToNetworkSettings = builder.scte35ReturnToNetworkSettings;
        this.scte35SpliceInsertSettings = builder.scte35SpliceInsertSettings;
        this.scte35TimeSignalSettings = builder.scte35TimeSignalSettings;
        this.staticImageActivateSettings = builder.staticImageActivateSettings;
        this.staticImageDeactivateSettings = builder.staticImageDeactivateSettings;
    }

    /**
     * Action to insert HLS ID3 segment tagging
     * 
     * @return Action to insert HLS ID3 segment tagging
     */
    public final HlsId3SegmentTaggingScheduleActionSettings hlsId3SegmentTaggingSettings() {
        return hlsId3SegmentTaggingSettings;
    }

    /**
     * Action to insert HLS metadata
     * 
     * @return Action to insert HLS metadata
     */
    public final HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings() {
        return hlsTimedMetadataSettings;
    }

    /**
     * Action to prepare an input for a future immediate input switch
     * 
     * @return Action to prepare an input for a future immediate input switch
     */
    public final InputPrepareScheduleActionSettings inputPrepareSettings() {
        return inputPrepareSettings;
    }

    /**
     * Action to switch the input
     * 
     * @return Action to switch the input
     */
    public final InputSwitchScheduleActionSettings inputSwitchSettings() {
        return inputSwitchSettings;
    }

    /**
     * Action to activate a motion graphics image overlay
     * 
     * @return Action to activate a motion graphics image overlay
     */
    public final MotionGraphicsActivateScheduleActionSettings motionGraphicsImageActivateSettings() {
        return motionGraphicsImageActivateSettings;
    }

    /**
     * Action to deactivate a motion graphics image overlay
     * 
     * @return Action to deactivate a motion graphics image overlay
     */
    public final MotionGraphicsDeactivateScheduleActionSettings motionGraphicsImageDeactivateSettings() {
        return motionGraphicsImageDeactivateSettings;
    }

    /**
     * Action to pause or unpause one or both channel pipelines
     * 
     * @return Action to pause or unpause one or both channel pipelines
     */
    public final PauseStateScheduleActionSettings pauseStateSettings() {
        return pauseStateSettings;
    }

    /**
     * Action to specify scte35 input
     * 
     * @return Action to specify scte35 input
     */
    public final Scte35InputScheduleActionSettings scte35InputSettings() {
        return scte35InputSettings;
    }

    /**
     * Action to insert SCTE-35 return_to_network message
     * 
     * @return Action to insert SCTE-35 return_to_network message
     */
    public final Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings() {
        return scte35ReturnToNetworkSettings;
    }

    /**
     * Action to insert SCTE-35 splice_insert message
     * 
     * @return Action to insert SCTE-35 splice_insert message
     */
    public final Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings() {
        return scte35SpliceInsertSettings;
    }

    /**
     * Action to insert SCTE-35 time_signal message
     * 
     * @return Action to insert SCTE-35 time_signal message
     */
    public final Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings() {
        return scte35TimeSignalSettings;
    }

    /**
     * Action to activate a static image overlay
     * 
     * @return Action to activate a static image overlay
     */
    public final StaticImageActivateScheduleActionSettings staticImageActivateSettings() {
        return staticImageActivateSettings;
    }

    /**
     * Action to deactivate a static image overlay
     * 
     * @return Action to deactivate a static image overlay
     */
    public final StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings() {
        return staticImageDeactivateSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hlsId3SegmentTaggingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsTimedMetadataSettings());
        hashCode = 31 * hashCode + Objects.hashCode(inputPrepareSettings());
        hashCode = 31 * hashCode + Objects.hashCode(inputSwitchSettings());
        hashCode = 31 * hashCode + Objects.hashCode(motionGraphicsImageActivateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(motionGraphicsImageDeactivateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(pauseStateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte35InputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte35ReturnToNetworkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte35SpliceInsertSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte35TimeSignalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(staticImageActivateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(staticImageDeactivateSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleActionSettings)) {
            return false;
        }
        ScheduleActionSettings other = (ScheduleActionSettings) obj;
        return Objects.equals(hlsId3SegmentTaggingSettings(), other.hlsId3SegmentTaggingSettings())
                && Objects.equals(hlsTimedMetadataSettings(), other.hlsTimedMetadataSettings())
                && Objects.equals(inputPrepareSettings(), other.inputPrepareSettings())
                && Objects.equals(inputSwitchSettings(), other.inputSwitchSettings())
                && Objects.equals(motionGraphicsImageActivateSettings(), other.motionGraphicsImageActivateSettings())
                && Objects.equals(motionGraphicsImageDeactivateSettings(), other.motionGraphicsImageDeactivateSettings())
                && Objects.equals(pauseStateSettings(), other.pauseStateSettings())
                && Objects.equals(scte35InputSettings(), other.scte35InputSettings())
                && Objects.equals(scte35ReturnToNetworkSettings(), other.scte35ReturnToNetworkSettings())
                && Objects.equals(scte35SpliceInsertSettings(), other.scte35SpliceInsertSettings())
                && Objects.equals(scte35TimeSignalSettings(), other.scte35TimeSignalSettings())
                && Objects.equals(staticImageActivateSettings(), other.staticImageActivateSettings())
                && Objects.equals(staticImageDeactivateSettings(), other.staticImageDeactivateSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleActionSettings").add("HlsId3SegmentTaggingSettings", hlsId3SegmentTaggingSettings())
                .add("HlsTimedMetadataSettings", hlsTimedMetadataSettings()).add("InputPrepareSettings", inputPrepareSettings())
                .add("InputSwitchSettings", inputSwitchSettings())
                .add("MotionGraphicsImageActivateSettings", motionGraphicsImageActivateSettings())
                .add("MotionGraphicsImageDeactivateSettings", motionGraphicsImageDeactivateSettings())
                .add("PauseStateSettings", pauseStateSettings()).add("Scte35InputSettings", scte35InputSettings())
                .add("Scte35ReturnToNetworkSettings", scte35ReturnToNetworkSettings())
                .add("Scte35SpliceInsertSettings", scte35SpliceInsertSettings())
                .add("Scte35TimeSignalSettings", scte35TimeSignalSettings())
                .add("StaticImageActivateSettings", staticImageActivateSettings())
                .add("StaticImageDeactivateSettings", staticImageDeactivateSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HlsId3SegmentTaggingSettings":
            return Optional.ofNullable(clazz.cast(hlsId3SegmentTaggingSettings()));
        case "HlsTimedMetadataSettings":
            return Optional.ofNullable(clazz.cast(hlsTimedMetadataSettings()));
        case "InputPrepareSettings":
            return Optional.ofNullable(clazz.cast(inputPrepareSettings()));
        case "InputSwitchSettings":
            return Optional.ofNullable(clazz.cast(inputSwitchSettings()));
        case "MotionGraphicsImageActivateSettings":
            return Optional.ofNullable(clazz.cast(motionGraphicsImageActivateSettings()));
        case "MotionGraphicsImageDeactivateSettings":
            return Optional.ofNullable(clazz.cast(motionGraphicsImageDeactivateSettings()));
        case "PauseStateSettings":
            return Optional.ofNullable(clazz.cast(pauseStateSettings()));
        case "Scte35InputSettings":
            return Optional.ofNullable(clazz.cast(scte35InputSettings()));
        case "Scte35ReturnToNetworkSettings":
            return Optional.ofNullable(clazz.cast(scte35ReturnToNetworkSettings()));
        case "Scte35SpliceInsertSettings":
            return Optional.ofNullable(clazz.cast(scte35SpliceInsertSettings()));
        case "Scte35TimeSignalSettings":
            return Optional.ofNullable(clazz.cast(scte35TimeSignalSettings()));
        case "StaticImageActivateSettings":
            return Optional.ofNullable(clazz.cast(staticImageActivateSettings()));
        case "StaticImageDeactivateSettings":
            return Optional.ofNullable(clazz.cast(staticImageDeactivateSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleActionSettings, T> g) {
        return obj -> g.apply((ScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleActionSettings> {
        /**
         * Action to insert HLS ID3 segment tagging
         * 
         * @param hlsId3SegmentTaggingSettings
         *        Action to insert HLS ID3 segment tagging
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsId3SegmentTaggingSettings(HlsId3SegmentTaggingScheduleActionSettings hlsId3SegmentTaggingSettings);

        /**
         * Action to insert HLS ID3 segment tagging This is a convenience method that creates an instance of the
         * {@link HlsId3SegmentTaggingScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link HlsId3SegmentTaggingScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsId3SegmentTaggingScheduleActionSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #hlsId3SegmentTaggingSettings(HlsId3SegmentTaggingScheduleActionSettings)}.
         * 
         * @param hlsId3SegmentTaggingSettings
         *        a consumer that will call methods on {@link HlsId3SegmentTaggingScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsId3SegmentTaggingSettings(HlsId3SegmentTaggingScheduleActionSettings)
         */
        default Builder hlsId3SegmentTaggingSettings(
                Consumer<HlsId3SegmentTaggingScheduleActionSettings.Builder> hlsId3SegmentTaggingSettings) {
            return hlsId3SegmentTaggingSettings(HlsId3SegmentTaggingScheduleActionSettings.builder()
                    .applyMutation(hlsId3SegmentTaggingSettings).build());
        }

        /**
         * Action to insert HLS metadata
         * 
         * @param hlsTimedMetadataSettings
         *        Action to insert HLS metadata
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings);

        /**
         * Action to insert HLS metadata This is a convenience method that creates an instance of the
         * {@link HlsTimedMetadataScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link HlsTimedMetadataScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsTimedMetadataScheduleActionSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #hlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings)}.
         * 
         * @param hlsTimedMetadataSettings
         *        a consumer that will call methods on {@link HlsTimedMetadataScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings)
         */
        default Builder hlsTimedMetadataSettings(Consumer<HlsTimedMetadataScheduleActionSettings.Builder> hlsTimedMetadataSettings) {
            return hlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings.builder()
                    .applyMutation(hlsTimedMetadataSettings).build());
        }

        /**
         * Action to prepare an input for a future immediate input switch
         * 
         * @param inputPrepareSettings
         *        Action to prepare an input for a future immediate input switch
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPrepareSettings(InputPrepareScheduleActionSettings inputPrepareSettings);

        /**
         * Action to prepare an input for a future immediate input switch This is a convenience method that creates an
         * instance of the {@link InputPrepareScheduleActionSettings.Builder} avoiding the need to create one manually
         * via {@link InputPrepareScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputPrepareScheduleActionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #inputPrepareSettings(InputPrepareScheduleActionSettings)}.
         * 
         * @param inputPrepareSettings
         *        a consumer that will call methods on {@link InputPrepareScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputPrepareSettings(InputPrepareScheduleActionSettings)
         */
        default Builder inputPrepareSettings(Consumer<InputPrepareScheduleActionSettings.Builder> inputPrepareSettings) {
            return inputPrepareSettings(InputPrepareScheduleActionSettings.builder().applyMutation(inputPrepareSettings).build());
        }

        /**
         * Action to switch the input
         * 
         * @param inputSwitchSettings
         *        Action to switch the input
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSwitchSettings(InputSwitchScheduleActionSettings inputSwitchSettings);

        /**
         * Action to switch the input This is a convenience method that creates an instance of the
         * {@link InputSwitchScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link InputSwitchScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputSwitchScheduleActionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #inputSwitchSettings(InputSwitchScheduleActionSettings)}.
         * 
         * @param inputSwitchSettings
         *        a consumer that will call methods on {@link InputSwitchScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSwitchSettings(InputSwitchScheduleActionSettings)
         */
        default Builder inputSwitchSettings(Consumer<InputSwitchScheduleActionSettings.Builder> inputSwitchSettings) {
            return inputSwitchSettings(InputSwitchScheduleActionSettings.builder().applyMutation(inputSwitchSettings).build());
        }

        /**
         * Action to activate a motion graphics image overlay
         * 
         * @param motionGraphicsImageActivateSettings
         *        Action to activate a motion graphics image overlay
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder motionGraphicsImageActivateSettings(
                MotionGraphicsActivateScheduleActionSettings motionGraphicsImageActivateSettings);

        /**
         * Action to activate a motion graphics image overlay This is a convenience method that creates an instance of
         * the {@link MotionGraphicsActivateScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link MotionGraphicsActivateScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MotionGraphicsActivateScheduleActionSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #motionGraphicsImageActivateSettings(MotionGraphicsActivateScheduleActionSettings)}.
         * 
         * @param motionGraphicsImageActivateSettings
         *        a consumer that will call methods on {@link MotionGraphicsActivateScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #motionGraphicsImageActivateSettings(MotionGraphicsActivateScheduleActionSettings)
         */
        default Builder motionGraphicsImageActivateSettings(
                Consumer<MotionGraphicsActivateScheduleActionSettings.Builder> motionGraphicsImageActivateSettings) {
            return motionGraphicsImageActivateSettings(MotionGraphicsActivateScheduleActionSettings.builder()
                    .applyMutation(motionGraphicsImageActivateSettings).build());
        }

        /**
         * Action to deactivate a motion graphics image overlay
         * 
         * @param motionGraphicsImageDeactivateSettings
         *        Action to deactivate a motion graphics image overlay
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder motionGraphicsImageDeactivateSettings(
                MotionGraphicsDeactivateScheduleActionSettings motionGraphicsImageDeactivateSettings);

        /**
         * Action to deactivate a motion graphics image overlay This is a convenience method that creates an instance of
         * the {@link MotionGraphicsDeactivateScheduleActionSettings.Builder} avoiding the need to create one manually
         * via {@link MotionGraphicsDeactivateScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MotionGraphicsDeactivateScheduleActionSettings.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #motionGraphicsImageDeactivateSettings(MotionGraphicsDeactivateScheduleActionSettings)}.
         * 
         * @param motionGraphicsImageDeactivateSettings
         *        a consumer that will call methods on {@link MotionGraphicsDeactivateScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #motionGraphicsImageDeactivateSettings(MotionGraphicsDeactivateScheduleActionSettings)
         */
        default Builder motionGraphicsImageDeactivateSettings(
                Consumer<MotionGraphicsDeactivateScheduleActionSettings.Builder> motionGraphicsImageDeactivateSettings) {
            return motionGraphicsImageDeactivateSettings(MotionGraphicsDeactivateScheduleActionSettings.builder()
                    .applyMutation(motionGraphicsImageDeactivateSettings).build());
        }

        /**
         * Action to pause or unpause one or both channel pipelines
         * 
         * @param pauseStateSettings
         *        Action to pause or unpause one or both channel pipelines
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pauseStateSettings(PauseStateScheduleActionSettings pauseStateSettings);

        /**
         * Action to pause or unpause one or both channel pipelines This is a convenience method that creates an
         * instance of the {@link PauseStateScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link PauseStateScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PauseStateScheduleActionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #pauseStateSettings(PauseStateScheduleActionSettings)}.
         * 
         * @param pauseStateSettings
         *        a consumer that will call methods on {@link PauseStateScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pauseStateSettings(PauseStateScheduleActionSettings)
         */
        default Builder pauseStateSettings(Consumer<PauseStateScheduleActionSettings.Builder> pauseStateSettings) {
            return pauseStateSettings(PauseStateScheduleActionSettings.builder().applyMutation(pauseStateSettings).build());
        }

        /**
         * Action to specify scte35 input
         * 
         * @param scte35InputSettings
         *        Action to specify scte35 input
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35InputSettings(Scte35InputScheduleActionSettings scte35InputSettings);

        /**
         * Action to specify scte35 input This is a convenience method that creates an instance of the
         * {@link Scte35InputScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link Scte35InputScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scte35InputScheduleActionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #scte35InputSettings(Scte35InputScheduleActionSettings)}.
         * 
         * @param scte35InputSettings
         *        a consumer that will call methods on {@link Scte35InputScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte35InputSettings(Scte35InputScheduleActionSettings)
         */
        default Builder scte35InputSettings(Consumer<Scte35InputScheduleActionSettings.Builder> scte35InputSettings) {
            return scte35InputSettings(Scte35InputScheduleActionSettings.builder().applyMutation(scte35InputSettings).build());
        }

        /**
         * Action to insert SCTE-35 return_to_network message
         * 
         * @param scte35ReturnToNetworkSettings
         *        Action to insert SCTE-35 return_to_network message
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35ReturnToNetworkSettings(Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings);

        /**
         * Action to insert SCTE-35 return_to_network message This is a convenience method that creates an instance of
         * the {@link Scte35ReturnToNetworkScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link Scte35ReturnToNetworkScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scte35ReturnToNetworkScheduleActionSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #scte35ReturnToNetworkSettings(Scte35ReturnToNetworkScheduleActionSettings)}.
         * 
         * @param scte35ReturnToNetworkSettings
         *        a consumer that will call methods on {@link Scte35ReturnToNetworkScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte35ReturnToNetworkSettings(Scte35ReturnToNetworkScheduleActionSettings)
         */
        default Builder scte35ReturnToNetworkSettings(
                Consumer<Scte35ReturnToNetworkScheduleActionSettings.Builder> scte35ReturnToNetworkSettings) {
            return scte35ReturnToNetworkSettings(Scte35ReturnToNetworkScheduleActionSettings.builder()
                    .applyMutation(scte35ReturnToNetworkSettings).build());
        }

        /**
         * Action to insert SCTE-35 splice_insert message
         * 
         * @param scte35SpliceInsertSettings
         *        Action to insert SCTE-35 splice_insert message
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings);

        /**
         * Action to insert SCTE-35 splice_insert message This is a convenience method that creates an instance of the
         * {@link Scte35SpliceInsertScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link Scte35SpliceInsertScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scte35SpliceInsertScheduleActionSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #scte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings)}.
         * 
         * @param scte35SpliceInsertSettings
         *        a consumer that will call methods on {@link Scte35SpliceInsertScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings)
         */
        default Builder scte35SpliceInsertSettings(
                Consumer<Scte35SpliceInsertScheduleActionSettings.Builder> scte35SpliceInsertSettings) {
            return scte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings.builder()
                    .applyMutation(scte35SpliceInsertSettings).build());
        }

        /**
         * Action to insert SCTE-35 time_signal message
         * 
         * @param scte35TimeSignalSettings
         *        Action to insert SCTE-35 time_signal message
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings);

        /**
         * Action to insert SCTE-35 time_signal message This is a convenience method that creates an instance of the
         * {@link Scte35TimeSignalScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link Scte35TimeSignalScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scte35TimeSignalScheduleActionSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #scte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings)}.
         * 
         * @param scte35TimeSignalSettings
         *        a consumer that will call methods on {@link Scte35TimeSignalScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings)
         */
        default Builder scte35TimeSignalSettings(Consumer<Scte35TimeSignalScheduleActionSettings.Builder> scte35TimeSignalSettings) {
            return scte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings.builder()
                    .applyMutation(scte35TimeSignalSettings).build());
        }

        /**
         * Action to activate a static image overlay
         * 
         * @param staticImageActivateSettings
         *        Action to activate a static image overlay
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticImageActivateSettings(StaticImageActivateScheduleActionSettings staticImageActivateSettings);

        /**
         * Action to activate a static image overlay This is a convenience method that creates an instance of the
         * {@link StaticImageActivateScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link StaticImageActivateScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticImageActivateScheduleActionSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #staticImageActivateSettings(StaticImageActivateScheduleActionSettings)}.
         * 
         * @param staticImageActivateSettings
         *        a consumer that will call methods on {@link StaticImageActivateScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticImageActivateSettings(StaticImageActivateScheduleActionSettings)
         */
        default Builder staticImageActivateSettings(
                Consumer<StaticImageActivateScheduleActionSettings.Builder> staticImageActivateSettings) {
            return staticImageActivateSettings(StaticImageActivateScheduleActionSettings.builder()
                    .applyMutation(staticImageActivateSettings).build());
        }

        /**
         * Action to deactivate a static image overlay
         * 
         * @param staticImageDeactivateSettings
         *        Action to deactivate a static image overlay
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticImageDeactivateSettings(StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings);

        /**
         * Action to deactivate a static image overlay This is a convenience method that creates an instance of the
         * {@link StaticImageDeactivateScheduleActionSettings.Builder} avoiding the need to create one manually via
         * {@link StaticImageDeactivateScheduleActionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticImageDeactivateScheduleActionSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #staticImageDeactivateSettings(StaticImageDeactivateScheduleActionSettings)}.
         * 
         * @param staticImageDeactivateSettings
         *        a consumer that will call methods on {@link StaticImageDeactivateScheduleActionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticImageDeactivateSettings(StaticImageDeactivateScheduleActionSettings)
         */
        default Builder staticImageDeactivateSettings(
                Consumer<StaticImageDeactivateScheduleActionSettings.Builder> staticImageDeactivateSettings) {
            return staticImageDeactivateSettings(StaticImageDeactivateScheduleActionSettings.builder()
                    .applyMutation(staticImageDeactivateSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HlsId3SegmentTaggingScheduleActionSettings hlsId3SegmentTaggingSettings;

        private HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings;

        private InputPrepareScheduleActionSettings inputPrepareSettings;

        private InputSwitchScheduleActionSettings inputSwitchSettings;

        private MotionGraphicsActivateScheduleActionSettings motionGraphicsImageActivateSettings;

        private MotionGraphicsDeactivateScheduleActionSettings motionGraphicsImageDeactivateSettings;

        private PauseStateScheduleActionSettings pauseStateSettings;

        private Scte35InputScheduleActionSettings scte35InputSettings;

        private Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings;

        private Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings;

        private Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings;

        private StaticImageActivateScheduleActionSettings staticImageActivateSettings;

        private StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleActionSettings model) {
            hlsId3SegmentTaggingSettings(model.hlsId3SegmentTaggingSettings);
            hlsTimedMetadataSettings(model.hlsTimedMetadataSettings);
            inputPrepareSettings(model.inputPrepareSettings);
            inputSwitchSettings(model.inputSwitchSettings);
            motionGraphicsImageActivateSettings(model.motionGraphicsImageActivateSettings);
            motionGraphicsImageDeactivateSettings(model.motionGraphicsImageDeactivateSettings);
            pauseStateSettings(model.pauseStateSettings);
            scte35InputSettings(model.scte35InputSettings);
            scte35ReturnToNetworkSettings(model.scte35ReturnToNetworkSettings);
            scte35SpliceInsertSettings(model.scte35SpliceInsertSettings);
            scte35TimeSignalSettings(model.scte35TimeSignalSettings);
            staticImageActivateSettings(model.staticImageActivateSettings);
            staticImageDeactivateSettings(model.staticImageDeactivateSettings);
        }

        public final HlsId3SegmentTaggingScheduleActionSettings.Builder getHlsId3SegmentTaggingSettings() {
            return hlsId3SegmentTaggingSettings != null ? hlsId3SegmentTaggingSettings.toBuilder() : null;
        }

        public final void setHlsId3SegmentTaggingSettings(
                HlsId3SegmentTaggingScheduleActionSettings.BuilderImpl hlsId3SegmentTaggingSettings) {
            this.hlsId3SegmentTaggingSettings = hlsId3SegmentTaggingSettings != null ? hlsId3SegmentTaggingSettings.build()
                    : null;
        }

        @Override
        public final Builder hlsId3SegmentTaggingSettings(HlsId3SegmentTaggingScheduleActionSettings hlsId3SegmentTaggingSettings) {
            this.hlsId3SegmentTaggingSettings = hlsId3SegmentTaggingSettings;
            return this;
        }

        public final HlsTimedMetadataScheduleActionSettings.Builder getHlsTimedMetadataSettings() {
            return hlsTimedMetadataSettings != null ? hlsTimedMetadataSettings.toBuilder() : null;
        }

        public final void setHlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings.BuilderImpl hlsTimedMetadataSettings) {
            this.hlsTimedMetadataSettings = hlsTimedMetadataSettings != null ? hlsTimedMetadataSettings.build() : null;
        }

        @Override
        public final Builder hlsTimedMetadataSettings(HlsTimedMetadataScheduleActionSettings hlsTimedMetadataSettings) {
            this.hlsTimedMetadataSettings = hlsTimedMetadataSettings;
            return this;
        }

        public final InputPrepareScheduleActionSettings.Builder getInputPrepareSettings() {
            return inputPrepareSettings != null ? inputPrepareSettings.toBuilder() : null;
        }

        public final void setInputPrepareSettings(InputPrepareScheduleActionSettings.BuilderImpl inputPrepareSettings) {
            this.inputPrepareSettings = inputPrepareSettings != null ? inputPrepareSettings.build() : null;
        }

        @Override
        public final Builder inputPrepareSettings(InputPrepareScheduleActionSettings inputPrepareSettings) {
            this.inputPrepareSettings = inputPrepareSettings;
            return this;
        }

        public final InputSwitchScheduleActionSettings.Builder getInputSwitchSettings() {
            return inputSwitchSettings != null ? inputSwitchSettings.toBuilder() : null;
        }

        public final void setInputSwitchSettings(InputSwitchScheduleActionSettings.BuilderImpl inputSwitchSettings) {
            this.inputSwitchSettings = inputSwitchSettings != null ? inputSwitchSettings.build() : null;
        }

        @Override
        public final Builder inputSwitchSettings(InputSwitchScheduleActionSettings inputSwitchSettings) {
            this.inputSwitchSettings = inputSwitchSettings;
            return this;
        }

        public final MotionGraphicsActivateScheduleActionSettings.Builder getMotionGraphicsImageActivateSettings() {
            return motionGraphicsImageActivateSettings != null ? motionGraphicsImageActivateSettings.toBuilder() : null;
        }

        public final void setMotionGraphicsImageActivateSettings(
                MotionGraphicsActivateScheduleActionSettings.BuilderImpl motionGraphicsImageActivateSettings) {
            this.motionGraphicsImageActivateSettings = motionGraphicsImageActivateSettings != null ? motionGraphicsImageActivateSettings
                    .build() : null;
        }

        @Override
        public final Builder motionGraphicsImageActivateSettings(
                MotionGraphicsActivateScheduleActionSettings motionGraphicsImageActivateSettings) {
            this.motionGraphicsImageActivateSettings = motionGraphicsImageActivateSettings;
            return this;
        }

        public final MotionGraphicsDeactivateScheduleActionSettings.Builder getMotionGraphicsImageDeactivateSettings() {
            return motionGraphicsImageDeactivateSettings != null ? motionGraphicsImageDeactivateSettings.toBuilder() : null;
        }

        public final void setMotionGraphicsImageDeactivateSettings(
                MotionGraphicsDeactivateScheduleActionSettings.BuilderImpl motionGraphicsImageDeactivateSettings) {
            this.motionGraphicsImageDeactivateSettings = motionGraphicsImageDeactivateSettings != null ? motionGraphicsImageDeactivateSettings
                    .build() : null;
        }

        @Override
        public final Builder motionGraphicsImageDeactivateSettings(
                MotionGraphicsDeactivateScheduleActionSettings motionGraphicsImageDeactivateSettings) {
            this.motionGraphicsImageDeactivateSettings = motionGraphicsImageDeactivateSettings;
            return this;
        }

        public final PauseStateScheduleActionSettings.Builder getPauseStateSettings() {
            return pauseStateSettings != null ? pauseStateSettings.toBuilder() : null;
        }

        public final void setPauseStateSettings(PauseStateScheduleActionSettings.BuilderImpl pauseStateSettings) {
            this.pauseStateSettings = pauseStateSettings != null ? pauseStateSettings.build() : null;
        }

        @Override
        public final Builder pauseStateSettings(PauseStateScheduleActionSettings pauseStateSettings) {
            this.pauseStateSettings = pauseStateSettings;
            return this;
        }

        public final Scte35InputScheduleActionSettings.Builder getScte35InputSettings() {
            return scte35InputSettings != null ? scte35InputSettings.toBuilder() : null;
        }

        public final void setScte35InputSettings(Scte35InputScheduleActionSettings.BuilderImpl scte35InputSettings) {
            this.scte35InputSettings = scte35InputSettings != null ? scte35InputSettings.build() : null;
        }

        @Override
        public final Builder scte35InputSettings(Scte35InputScheduleActionSettings scte35InputSettings) {
            this.scte35InputSettings = scte35InputSettings;
            return this;
        }

        public final Scte35ReturnToNetworkScheduleActionSettings.Builder getScte35ReturnToNetworkSettings() {
            return scte35ReturnToNetworkSettings != null ? scte35ReturnToNetworkSettings.toBuilder() : null;
        }

        public final void setScte35ReturnToNetworkSettings(
                Scte35ReturnToNetworkScheduleActionSettings.BuilderImpl scte35ReturnToNetworkSettings) {
            this.scte35ReturnToNetworkSettings = scte35ReturnToNetworkSettings != null ? scte35ReturnToNetworkSettings.build()
                    : null;
        }

        @Override
        public final Builder scte35ReturnToNetworkSettings(
                Scte35ReturnToNetworkScheduleActionSettings scte35ReturnToNetworkSettings) {
            this.scte35ReturnToNetworkSettings = scte35ReturnToNetworkSettings;
            return this;
        }

        public final Scte35SpliceInsertScheduleActionSettings.Builder getScte35SpliceInsertSettings() {
            return scte35SpliceInsertSettings != null ? scte35SpliceInsertSettings.toBuilder() : null;
        }

        public final void setScte35SpliceInsertSettings(
                Scte35SpliceInsertScheduleActionSettings.BuilderImpl scte35SpliceInsertSettings) {
            this.scte35SpliceInsertSettings = scte35SpliceInsertSettings != null ? scte35SpliceInsertSettings.build() : null;
        }

        @Override
        public final Builder scte35SpliceInsertSettings(Scte35SpliceInsertScheduleActionSettings scte35SpliceInsertSettings) {
            this.scte35SpliceInsertSettings = scte35SpliceInsertSettings;
            return this;
        }

        public final Scte35TimeSignalScheduleActionSettings.Builder getScte35TimeSignalSettings() {
            return scte35TimeSignalSettings != null ? scte35TimeSignalSettings.toBuilder() : null;
        }

        public final void setScte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings.BuilderImpl scte35TimeSignalSettings) {
            this.scte35TimeSignalSettings = scte35TimeSignalSettings != null ? scte35TimeSignalSettings.build() : null;
        }

        @Override
        public final Builder scte35TimeSignalSettings(Scte35TimeSignalScheduleActionSettings scte35TimeSignalSettings) {
            this.scte35TimeSignalSettings = scte35TimeSignalSettings;
            return this;
        }

        public final StaticImageActivateScheduleActionSettings.Builder getStaticImageActivateSettings() {
            return staticImageActivateSettings != null ? staticImageActivateSettings.toBuilder() : null;
        }

        public final void setStaticImageActivateSettings(
                StaticImageActivateScheduleActionSettings.BuilderImpl staticImageActivateSettings) {
            this.staticImageActivateSettings = staticImageActivateSettings != null ? staticImageActivateSettings.build() : null;
        }

        @Override
        public final Builder staticImageActivateSettings(StaticImageActivateScheduleActionSettings staticImageActivateSettings) {
            this.staticImageActivateSettings = staticImageActivateSettings;
            return this;
        }

        public final StaticImageDeactivateScheduleActionSettings.Builder getStaticImageDeactivateSettings() {
            return staticImageDeactivateSettings != null ? staticImageDeactivateSettings.toBuilder() : null;
        }

        public final void setStaticImageDeactivateSettings(
                StaticImageDeactivateScheduleActionSettings.BuilderImpl staticImageDeactivateSettings) {
            this.staticImageDeactivateSettings = staticImageDeactivateSettings != null ? staticImageDeactivateSettings.build()
                    : null;
        }

        @Override
        public final Builder staticImageDeactivateSettings(
                StaticImageDeactivateScheduleActionSettings staticImageDeactivateSettings) {
            this.staticImageDeactivateSettings = staticImageDeactivateSettings;
            return this;
        }

        @Override
        public ScheduleActionSettings build() {
            return new ScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
