/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Corresponds to SCTE-35 delivery_not_restricted_flag parameter. To declare delivery restrictions, include this element
 * and its four "restriction" flags. To declare that there are no restrictions, omit this element.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scte35DeliveryRestrictions implements SdkPojo, Serializable,
        ToCopyableBuilder<Scte35DeliveryRestrictions.Builder, Scte35DeliveryRestrictions> {
    private static final SdkField<String> ARCHIVE_ALLOWED_FLAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveAllowedFlag").getter(getter(Scte35DeliveryRestrictions::archiveAllowedFlagAsString))
            .setter(setter(Builder::archiveAllowedFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveAllowedFlag").build())
            .build();

    private static final SdkField<String> DEVICE_RESTRICTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceRestrictions").getter(getter(Scte35DeliveryRestrictions::deviceRestrictionsAsString))
            .setter(setter(Builder::deviceRestrictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceRestrictions").build())
            .build();

    private static final SdkField<String> NO_REGIONAL_BLACKOUT_FLAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NoRegionalBlackoutFlag").getter(getter(Scte35DeliveryRestrictions::noRegionalBlackoutFlagAsString))
            .setter(setter(Builder::noRegionalBlackoutFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noRegionalBlackoutFlag").build())
            .build();

    private static final SdkField<String> WEB_DELIVERY_ALLOWED_FLAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebDeliveryAllowedFlag").getter(getter(Scte35DeliveryRestrictions::webDeliveryAllowedFlagAsString))
            .setter(setter(Builder::webDeliveryAllowedFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webDeliveryAllowedFlag").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ALLOWED_FLAG_FIELD,
            DEVICE_RESTRICTIONS_FIELD, NO_REGIONAL_BLACKOUT_FLAG_FIELD, WEB_DELIVERY_ALLOWED_FLAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String archiveAllowedFlag;

    private final String deviceRestrictions;

    private final String noRegionalBlackoutFlag;

    private final String webDeliveryAllowedFlag;

    private Scte35DeliveryRestrictions(BuilderImpl builder) {
        this.archiveAllowedFlag = builder.archiveAllowedFlag;
        this.deviceRestrictions = builder.deviceRestrictions;
        this.noRegionalBlackoutFlag = builder.noRegionalBlackoutFlag;
        this.webDeliveryAllowedFlag = builder.webDeliveryAllowedFlag;
    }

    /**
     * Corresponds to SCTE-35 archive_allowed_flag.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #archiveAllowedFlag} will return {@link Scte35ArchiveAllowedFlag#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #archiveAllowedFlagAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 archive_allowed_flag.
     * @see Scte35ArchiveAllowedFlag
     */
    public final Scte35ArchiveAllowedFlag archiveAllowedFlag() {
        return Scte35ArchiveAllowedFlag.fromValue(archiveAllowedFlag);
    }

    /**
     * Corresponds to SCTE-35 archive_allowed_flag.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #archiveAllowedFlag} will return {@link Scte35ArchiveAllowedFlag#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #archiveAllowedFlagAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 archive_allowed_flag.
     * @see Scte35ArchiveAllowedFlag
     */
    public final String archiveAllowedFlagAsString() {
        return archiveAllowedFlag;
    }

    /**
     * Corresponds to SCTE-35 device_restrictions parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceRestrictions} will return {@link Scte35DeviceRestrictions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceRestrictionsAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 device_restrictions parameter.
     * @see Scte35DeviceRestrictions
     */
    public final Scte35DeviceRestrictions deviceRestrictions() {
        return Scte35DeviceRestrictions.fromValue(deviceRestrictions);
    }

    /**
     * Corresponds to SCTE-35 device_restrictions parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceRestrictions} will return {@link Scte35DeviceRestrictions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceRestrictionsAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 device_restrictions parameter.
     * @see Scte35DeviceRestrictions
     */
    public final String deviceRestrictionsAsString() {
        return deviceRestrictions;
    }

    /**
     * Corresponds to SCTE-35 no_regional_blackout_flag parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noRegionalBlackoutFlag} will return {@link Scte35NoRegionalBlackoutFlag#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #noRegionalBlackoutFlagAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 no_regional_blackout_flag parameter.
     * @see Scte35NoRegionalBlackoutFlag
     */
    public final Scte35NoRegionalBlackoutFlag noRegionalBlackoutFlag() {
        return Scte35NoRegionalBlackoutFlag.fromValue(noRegionalBlackoutFlag);
    }

    /**
     * Corresponds to SCTE-35 no_regional_blackout_flag parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #noRegionalBlackoutFlag} will return {@link Scte35NoRegionalBlackoutFlag#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #noRegionalBlackoutFlagAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 no_regional_blackout_flag parameter.
     * @see Scte35NoRegionalBlackoutFlag
     */
    public final String noRegionalBlackoutFlagAsString() {
        return noRegionalBlackoutFlag;
    }

    /**
     * Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webDeliveryAllowedFlag} will return {@link Scte35WebDeliveryAllowedFlag#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #webDeliveryAllowedFlagAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
     * @see Scte35WebDeliveryAllowedFlag
     */
    public final Scte35WebDeliveryAllowedFlag webDeliveryAllowedFlag() {
        return Scte35WebDeliveryAllowedFlag.fromValue(webDeliveryAllowedFlag);
    }

    /**
     * Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webDeliveryAllowedFlag} will return {@link Scte35WebDeliveryAllowedFlag#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #webDeliveryAllowedFlagAsString}.
     * </p>
     * 
     * @return Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
     * @see Scte35WebDeliveryAllowedFlag
     */
    public final String webDeliveryAllowedFlagAsString() {
        return webDeliveryAllowedFlag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveAllowedFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceRestrictionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(noRegionalBlackoutFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webDeliveryAllowedFlagAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scte35DeliveryRestrictions)) {
            return false;
        }
        Scte35DeliveryRestrictions other = (Scte35DeliveryRestrictions) obj;
        return Objects.equals(archiveAllowedFlagAsString(), other.archiveAllowedFlagAsString())
                && Objects.equals(deviceRestrictionsAsString(), other.deviceRestrictionsAsString())
                && Objects.equals(noRegionalBlackoutFlagAsString(), other.noRegionalBlackoutFlagAsString())
                && Objects.equals(webDeliveryAllowedFlagAsString(), other.webDeliveryAllowedFlagAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scte35DeliveryRestrictions").add("ArchiveAllowedFlag", archiveAllowedFlagAsString())
                .add("DeviceRestrictions", deviceRestrictionsAsString())
                .add("NoRegionalBlackoutFlag", noRegionalBlackoutFlagAsString())
                .add("WebDeliveryAllowedFlag", webDeliveryAllowedFlagAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveAllowedFlag":
            return Optional.ofNullable(clazz.cast(archiveAllowedFlagAsString()));
        case "DeviceRestrictions":
            return Optional.ofNullable(clazz.cast(deviceRestrictionsAsString()));
        case "NoRegionalBlackoutFlag":
            return Optional.ofNullable(clazz.cast(noRegionalBlackoutFlagAsString()));
        case "WebDeliveryAllowedFlag":
            return Optional.ofNullable(clazz.cast(webDeliveryAllowedFlagAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scte35DeliveryRestrictions, T> g) {
        return obj -> g.apply((Scte35DeliveryRestrictions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scte35DeliveryRestrictions> {
        /**
         * Corresponds to SCTE-35 archive_allowed_flag.
         * 
         * @param archiveAllowedFlag
         *        Corresponds to SCTE-35 archive_allowed_flag.
         * @see Scte35ArchiveAllowedFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35ArchiveAllowedFlag
         */
        Builder archiveAllowedFlag(String archiveAllowedFlag);

        /**
         * Corresponds to SCTE-35 archive_allowed_flag.
         * 
         * @param archiveAllowedFlag
         *        Corresponds to SCTE-35 archive_allowed_flag.
         * @see Scte35ArchiveAllowedFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35ArchiveAllowedFlag
         */
        Builder archiveAllowedFlag(Scte35ArchiveAllowedFlag archiveAllowedFlag);

        /**
         * Corresponds to SCTE-35 device_restrictions parameter.
         * 
         * @param deviceRestrictions
         *        Corresponds to SCTE-35 device_restrictions parameter.
         * @see Scte35DeviceRestrictions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35DeviceRestrictions
         */
        Builder deviceRestrictions(String deviceRestrictions);

        /**
         * Corresponds to SCTE-35 device_restrictions parameter.
         * 
         * @param deviceRestrictions
         *        Corresponds to SCTE-35 device_restrictions parameter.
         * @see Scte35DeviceRestrictions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35DeviceRestrictions
         */
        Builder deviceRestrictions(Scte35DeviceRestrictions deviceRestrictions);

        /**
         * Corresponds to SCTE-35 no_regional_blackout_flag parameter.
         * 
         * @param noRegionalBlackoutFlag
         *        Corresponds to SCTE-35 no_regional_blackout_flag parameter.
         * @see Scte35NoRegionalBlackoutFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35NoRegionalBlackoutFlag
         */
        Builder noRegionalBlackoutFlag(String noRegionalBlackoutFlag);

        /**
         * Corresponds to SCTE-35 no_regional_blackout_flag parameter.
         * 
         * @param noRegionalBlackoutFlag
         *        Corresponds to SCTE-35 no_regional_blackout_flag parameter.
         * @see Scte35NoRegionalBlackoutFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35NoRegionalBlackoutFlag
         */
        Builder noRegionalBlackoutFlag(Scte35NoRegionalBlackoutFlag noRegionalBlackoutFlag);

        /**
         * Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
         * 
         * @param webDeliveryAllowedFlag
         *        Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
         * @see Scte35WebDeliveryAllowedFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35WebDeliveryAllowedFlag
         */
        Builder webDeliveryAllowedFlag(String webDeliveryAllowedFlag);

        /**
         * Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
         * 
         * @param webDeliveryAllowedFlag
         *        Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
         * @see Scte35WebDeliveryAllowedFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35WebDeliveryAllowedFlag
         */
        Builder webDeliveryAllowedFlag(Scte35WebDeliveryAllowedFlag webDeliveryAllowedFlag);
    }

    static final class BuilderImpl implements Builder {
        private String archiveAllowedFlag;

        private String deviceRestrictions;

        private String noRegionalBlackoutFlag;

        private String webDeliveryAllowedFlag;

        private BuilderImpl() {
        }

        private BuilderImpl(Scte35DeliveryRestrictions model) {
            archiveAllowedFlag(model.archiveAllowedFlag);
            deviceRestrictions(model.deviceRestrictions);
            noRegionalBlackoutFlag(model.noRegionalBlackoutFlag);
            webDeliveryAllowedFlag(model.webDeliveryAllowedFlag);
        }

        public final String getArchiveAllowedFlag() {
            return archiveAllowedFlag;
        }

        public final void setArchiveAllowedFlag(String archiveAllowedFlag) {
            this.archiveAllowedFlag = archiveAllowedFlag;
        }

        @Override
        public final Builder archiveAllowedFlag(String archiveAllowedFlag) {
            this.archiveAllowedFlag = archiveAllowedFlag;
            return this;
        }

        @Override
        public final Builder archiveAllowedFlag(Scte35ArchiveAllowedFlag archiveAllowedFlag) {
            this.archiveAllowedFlag(archiveAllowedFlag == null ? null : archiveAllowedFlag.toString());
            return this;
        }

        public final String getDeviceRestrictions() {
            return deviceRestrictions;
        }

        public final void setDeviceRestrictions(String deviceRestrictions) {
            this.deviceRestrictions = deviceRestrictions;
        }

        @Override
        public final Builder deviceRestrictions(String deviceRestrictions) {
            this.deviceRestrictions = deviceRestrictions;
            return this;
        }

        @Override
        public final Builder deviceRestrictions(Scte35DeviceRestrictions deviceRestrictions) {
            this.deviceRestrictions(deviceRestrictions == null ? null : deviceRestrictions.toString());
            return this;
        }

        public final String getNoRegionalBlackoutFlag() {
            return noRegionalBlackoutFlag;
        }

        public final void setNoRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
        }

        @Override
        public final Builder noRegionalBlackoutFlag(String noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag = noRegionalBlackoutFlag;
            return this;
        }

        @Override
        public final Builder noRegionalBlackoutFlag(Scte35NoRegionalBlackoutFlag noRegionalBlackoutFlag) {
            this.noRegionalBlackoutFlag(noRegionalBlackoutFlag == null ? null : noRegionalBlackoutFlag.toString());
            return this;
        }

        public final String getWebDeliveryAllowedFlag() {
            return webDeliveryAllowedFlag;
        }

        public final void setWebDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
        }

        @Override
        public final Builder webDeliveryAllowedFlag(String webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag = webDeliveryAllowedFlag;
            return this;
        }

        @Override
        public final Builder webDeliveryAllowedFlag(Scte35WebDeliveryAllowedFlag webDeliveryAllowedFlag) {
            this.webDeliveryAllowedFlag(webDeliveryAllowedFlag == null ? null : webDeliveryAllowedFlag.toString());
            return this;
        }

        @Override
        public Scte35DeliveryRestrictions build() {
            return new Scte35DeliveryRestrictions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
