/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateSummary;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse;

public class ListEventBridgeRuleTemplatesPublisher
implements SdkPublisher<ListEventBridgeRuleTemplatesResponse> {
    private final MediaLiveAsyncClient client;
    private final ListEventBridgeRuleTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventBridgeRuleTemplatesPublisher(MediaLiveAsyncClient client, ListEventBridgeRuleTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventBridgeRuleTemplatesPublisher(MediaLiveAsyncClient client, ListEventBridgeRuleTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventBridgeRuleTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventBridgeRuleTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventBridgeRuleTemplateSummary> eventBridgeRuleTemplates() {
        Function<ListEventBridgeRuleTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventBridgeRuleTemplates() != null) {
                return response.eventBridgeRuleTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventBridgeRuleTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventBridgeRuleTemplatesResponseFetcher
    implements AsyncPageFetcher<ListEventBridgeRuleTemplatesResponse> {
        private ListEventBridgeRuleTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListEventBridgeRuleTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventBridgeRuleTemplatesResponse> nextPage(ListEventBridgeRuleTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListEventBridgeRuleTemplatesPublisher.this.client.listEventBridgeRuleTemplates(ListEventBridgeRuleTemplatesPublisher.this.firstRequest);
            }
            return ListEventBridgeRuleTemplatesPublisher.this.client.listEventBridgeRuleTemplates((ListEventBridgeRuleTemplatesRequest)((Object)ListEventBridgeRuleTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

