/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsBasicPutSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsBasicPutSettings> {
    private static final SdkField<Integer> CONNECTION_RETRY_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionRetryInterval").getter(HlsBasicPutSettings.getter(HlsBasicPutSettings::connectionRetryInterval)).setter(HlsBasicPutSettings.setter(Builder::connectionRetryInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionRetryInterval").build()}).build();
    private static final SdkField<Integer> FILECACHE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FilecacheDuration").getter(HlsBasicPutSettings.getter(HlsBasicPutSettings::filecacheDuration)).setter(HlsBasicPutSettings.setter(Builder::filecacheDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filecacheDuration").build()}).build();
    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumRetries").getter(HlsBasicPutSettings.getter(HlsBasicPutSettings::numRetries)).setter(HlsBasicPutSettings.setter(Builder::numRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRetries").build()}).build();
    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RestartDelay").getter(HlsBasicPutSettings.getter(HlsBasicPutSettings::restartDelay)).setter(HlsBasicPutSettings.setter(Builder::restartDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_RETRY_INTERVAL_FIELD, FILECACHE_DURATION_FIELD, NUM_RETRIES_FIELD, RESTART_DELAY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HlsBasicPutSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer connectionRetryInterval;
    private final Integer filecacheDuration;
    private final Integer numRetries;
    private final Integer restartDelay;

    private HlsBasicPutSettings(BuilderImpl builder) {
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.filecacheDuration = builder.filecacheDuration;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
    }

    public final Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public final Integer filecacheDuration() {
        return this.filecacheDuration;
    }

    public final Integer numRetries() {
        return this.numRetries;
    }

    public final Integer restartDelay() {
        return this.restartDelay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsBasicPutSettings)) {
            return false;
        }
        HlsBasicPutSettings other = (HlsBasicPutSettings)obj;
        return Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.filecacheDuration(), other.filecacheDuration()) && Objects.equals(this.numRetries(), other.numRetries()) && Objects.equals(this.restartDelay(), other.restartDelay());
    }

    public final String toString() {
        return ToString.builder((String)"HlsBasicPutSettings").add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("FilecacheDuration", (Object)this.filecacheDuration()).add("NumRetries", (Object)this.numRetries()).add("RestartDelay", (Object)this.restartDelay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionRetryInterval": {
                return Optional.ofNullable(clazz.cast(this.connectionRetryInterval()));
            }
            case "FilecacheDuration": {
                return Optional.ofNullable(clazz.cast(this.filecacheDuration()));
            }
            case "NumRetries": {
                return Optional.ofNullable(clazz.cast(this.numRetries()));
            }
            case "RestartDelay": {
                return Optional.ofNullable(clazz.cast(this.restartDelay()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("connectionRetryInterval", CONNECTION_RETRY_INTERVAL_FIELD);
        map.put("filecacheDuration", FILECACHE_DURATION_FIELD);
        map.put("numRetries", NUM_RETRIES_FIELD);
        map.put("restartDelay", RESTART_DELAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HlsBasicPutSettings, T> g) {
        return obj -> g.apply((HlsBasicPutSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer connectionRetryInterval;
        private Integer filecacheDuration;
        private Integer numRetries;
        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsBasicPutSettings model) {
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.filecacheDuration(model.filecacheDuration);
            this.numRetries(model.numRetries);
            this.restartDelay(model.restartDelay);
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final Integer getFilecacheDuration() {
            return this.filecacheDuration;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public HlsBasicPutSettings build() {
            return new HlsBasicPutSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsBasicPutSettings> {
        public Builder connectionRetryInterval(Integer var1);

        public Builder filecacheDuration(Integer var1);

        public Builder numRetries(Integer var1);

        public Builder restartDelay(Integer var1);
    }
}

