/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings;
import software.amazon.awssdk.services.medialive.model.Fmp4HlsSettings;
import software.amazon.awssdk.services.medialive.model.FrameCaptureHlsSettings;
import software.amazon.awssdk.services.medialive.model.StandardHlsSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsSettings> {
    private static final SdkField<AudioOnlyHlsSettings> AUDIO_ONLY_HLS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioOnlyHlsSettings").getter(HlsSettings.getter(HlsSettings::audioOnlyHlsSettings)).setter(HlsSettings.setter(Builder::audioOnlyHlsSettings)).constructor(AudioOnlyHlsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyHlsSettings").build()}).build();
    private static final SdkField<Fmp4HlsSettings> FMP4_HLS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Fmp4HlsSettings").getter(HlsSettings.getter(HlsSettings::fmp4HlsSettings)).setter(HlsSettings.setter(Builder::fmp4HlsSettings)).constructor(Fmp4HlsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fmp4HlsSettings").build()}).build();
    private static final SdkField<FrameCaptureHlsSettings> FRAME_CAPTURE_HLS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameCaptureHlsSettings").getter(HlsSettings.getter(HlsSettings::frameCaptureHlsSettings)).setter(HlsSettings.setter(Builder::frameCaptureHlsSettings)).constructor(FrameCaptureHlsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureHlsSettings").build()}).build();
    private static final SdkField<StandardHlsSettings> STANDARD_HLS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StandardHlsSettings").getter(HlsSettings.getter(HlsSettings::standardHlsSettings)).setter(HlsSettings.setter(Builder::standardHlsSettings)).constructor(StandardHlsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardHlsSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_ONLY_HLS_SETTINGS_FIELD, FMP4_HLS_SETTINGS_FIELD, FRAME_CAPTURE_HLS_SETTINGS_FIELD, STANDARD_HLS_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HlsSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AudioOnlyHlsSettings audioOnlyHlsSettings;
    private final Fmp4HlsSettings fmp4HlsSettings;
    private final FrameCaptureHlsSettings frameCaptureHlsSettings;
    private final StandardHlsSettings standardHlsSettings;

    private HlsSettings(BuilderImpl builder) {
        this.audioOnlyHlsSettings = builder.audioOnlyHlsSettings;
        this.fmp4HlsSettings = builder.fmp4HlsSettings;
        this.frameCaptureHlsSettings = builder.frameCaptureHlsSettings;
        this.standardHlsSettings = builder.standardHlsSettings;
    }

    public final AudioOnlyHlsSettings audioOnlyHlsSettings() {
        return this.audioOnlyHlsSettings;
    }

    public final Fmp4HlsSettings fmp4HlsSettings() {
        return this.fmp4HlsSettings;
    }

    public final FrameCaptureHlsSettings frameCaptureHlsSettings() {
        return this.frameCaptureHlsSettings;
    }

    public final StandardHlsSettings standardHlsSettings() {
        return this.standardHlsSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyHlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fmp4HlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureHlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardHlsSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsSettings)) {
            return false;
        }
        HlsSettings other = (HlsSettings)obj;
        return Objects.equals(this.audioOnlyHlsSettings(), other.audioOnlyHlsSettings()) && Objects.equals(this.fmp4HlsSettings(), other.fmp4HlsSettings()) && Objects.equals(this.frameCaptureHlsSettings(), other.frameCaptureHlsSettings()) && Objects.equals(this.standardHlsSettings(), other.standardHlsSettings());
    }

    public final String toString() {
        return ToString.builder((String)"HlsSettings").add("AudioOnlyHlsSettings", (Object)this.audioOnlyHlsSettings()).add("Fmp4HlsSettings", (Object)this.fmp4HlsSettings()).add("FrameCaptureHlsSettings", (Object)this.frameCaptureHlsSettings()).add("StandardHlsSettings", (Object)this.standardHlsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioOnlyHlsSettings": {
                return Optional.ofNullable(clazz.cast(this.audioOnlyHlsSettings()));
            }
            case "Fmp4HlsSettings": {
                return Optional.ofNullable(clazz.cast(this.fmp4HlsSettings()));
            }
            case "FrameCaptureHlsSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureHlsSettings()));
            }
            case "StandardHlsSettings": {
                return Optional.ofNullable(clazz.cast(this.standardHlsSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audioOnlyHlsSettings", AUDIO_ONLY_HLS_SETTINGS_FIELD);
        map.put("fmp4HlsSettings", FMP4_HLS_SETTINGS_FIELD);
        map.put("frameCaptureHlsSettings", FRAME_CAPTURE_HLS_SETTINGS_FIELD);
        map.put("standardHlsSettings", STANDARD_HLS_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HlsSettings, T> g) {
        return obj -> g.apply((HlsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioOnlyHlsSettings audioOnlyHlsSettings;
        private Fmp4HlsSettings fmp4HlsSettings;
        private FrameCaptureHlsSettings frameCaptureHlsSettings;
        private StandardHlsSettings standardHlsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsSettings model) {
            this.audioOnlyHlsSettings(model.audioOnlyHlsSettings);
            this.fmp4HlsSettings(model.fmp4HlsSettings);
            this.frameCaptureHlsSettings(model.frameCaptureHlsSettings);
            this.standardHlsSettings(model.standardHlsSettings);
        }

        public final AudioOnlyHlsSettings.Builder getAudioOnlyHlsSettings() {
            return this.audioOnlyHlsSettings != null ? this.audioOnlyHlsSettings.toBuilder() : null;
        }

        public final void setAudioOnlyHlsSettings(AudioOnlyHlsSettings.BuilderImpl audioOnlyHlsSettings) {
            this.audioOnlyHlsSettings = audioOnlyHlsSettings != null ? audioOnlyHlsSettings.build() : null;
        }

        @Override
        public final Builder audioOnlyHlsSettings(AudioOnlyHlsSettings audioOnlyHlsSettings) {
            this.audioOnlyHlsSettings = audioOnlyHlsSettings;
            return this;
        }

        public final Fmp4HlsSettings.Builder getFmp4HlsSettings() {
            return this.fmp4HlsSettings != null ? this.fmp4HlsSettings.toBuilder() : null;
        }

        public final void setFmp4HlsSettings(Fmp4HlsSettings.BuilderImpl fmp4HlsSettings) {
            this.fmp4HlsSettings = fmp4HlsSettings != null ? fmp4HlsSettings.build() : null;
        }

        @Override
        public final Builder fmp4HlsSettings(Fmp4HlsSettings fmp4HlsSettings) {
            this.fmp4HlsSettings = fmp4HlsSettings;
            return this;
        }

        public final FrameCaptureHlsSettings.Builder getFrameCaptureHlsSettings() {
            return this.frameCaptureHlsSettings != null ? this.frameCaptureHlsSettings.toBuilder() : null;
        }

        public final void setFrameCaptureHlsSettings(FrameCaptureHlsSettings.BuilderImpl frameCaptureHlsSettings) {
            this.frameCaptureHlsSettings = frameCaptureHlsSettings != null ? frameCaptureHlsSettings.build() : null;
        }

        @Override
        public final Builder frameCaptureHlsSettings(FrameCaptureHlsSettings frameCaptureHlsSettings) {
            this.frameCaptureHlsSettings = frameCaptureHlsSettings;
            return this;
        }

        public final StandardHlsSettings.Builder getStandardHlsSettings() {
            return this.standardHlsSettings != null ? this.standardHlsSettings.toBuilder() : null;
        }

        public final void setStandardHlsSettings(StandardHlsSettings.BuilderImpl standardHlsSettings) {
            this.standardHlsSettings = standardHlsSettings != null ? standardHlsSettings.build() : null;
        }

        @Override
        public final Builder standardHlsSettings(StandardHlsSettings standardHlsSettings) {
            this.standardHlsSettings = standardHlsSettings;
            return this;
        }

        public HlsSettings build() {
            return new HlsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsSettings> {
        public Builder audioOnlyHlsSettings(AudioOnlyHlsSettings var1);

        default public Builder audioOnlyHlsSettings(Consumer<AudioOnlyHlsSettings.Builder> audioOnlyHlsSettings) {
            return this.audioOnlyHlsSettings((AudioOnlyHlsSettings)((AudioOnlyHlsSettings.Builder)AudioOnlyHlsSettings.builder().applyMutation(audioOnlyHlsSettings)).build());
        }

        public Builder fmp4HlsSettings(Fmp4HlsSettings var1);

        default public Builder fmp4HlsSettings(Consumer<Fmp4HlsSettings.Builder> fmp4HlsSettings) {
            return this.fmp4HlsSettings((Fmp4HlsSettings)((Fmp4HlsSettings.Builder)Fmp4HlsSettings.builder().applyMutation(fmp4HlsSettings)).build());
        }

        public Builder frameCaptureHlsSettings(FrameCaptureHlsSettings var1);

        default public Builder frameCaptureHlsSettings(Consumer<FrameCaptureHlsSettings.Builder> frameCaptureHlsSettings) {
            return this.frameCaptureHlsSettings((FrameCaptureHlsSettings)((FrameCaptureHlsSettings.Builder)FrameCaptureHlsSettings.builder().applyMutation(frameCaptureHlsSettings)).build());
        }

        public Builder standardHlsSettings(StandardHlsSettings var1);

        default public Builder standardHlsSettings(Consumer<StandardHlsSettings.Builder> standardHlsSettings) {
            return this.standardHlsSettings((StandardHlsSettings)((StandardHlsSettings.Builder)StandardHlsSettings.builder().applyMutation(standardHlsSettings)).build());
        }
    }
}

