/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.CdnAuthConfigurationCdnIdentifierSecretArnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CdnAuthConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CdnAuthConfiguration> {
    private static final SdkField<List<String>> CDN_IDENTIFIER_SECRET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CdnIdentifierSecretArns").getter(CdnAuthConfiguration.getter(CdnAuthConfiguration::cdnIdentifierSecretArns)).setter(CdnAuthConfiguration.setter(Builder::cdnIdentifierSecretArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnIdentifierSecretArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECRETS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsRoleArn").getter(CdnAuthConfiguration.getter(CdnAuthConfiguration::secretsRoleArn)).setter(CdnAuthConfiguration.setter(Builder::secretsRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDN_IDENTIFIER_SECRET_ARNS_FIELD, SECRETS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CdnAuthConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> cdnIdentifierSecretArns;
    private final String secretsRoleArn;

    private CdnAuthConfiguration(BuilderImpl builder) {
        this.cdnIdentifierSecretArns = builder.cdnIdentifierSecretArns;
        this.secretsRoleArn = builder.secretsRoleArn;
    }

    public final boolean hasCdnIdentifierSecretArns() {
        return this.cdnIdentifierSecretArns != null && !(this.cdnIdentifierSecretArns instanceof SdkAutoConstructList);
    }

    public final List<String> cdnIdentifierSecretArns() {
        return this.cdnIdentifierSecretArns;
    }

    public final String secretsRoleArn() {
        return this.secretsRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCdnIdentifierSecretArns() ? this.cdnIdentifierSecretArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdnAuthConfiguration)) {
            return false;
        }
        CdnAuthConfiguration other = (CdnAuthConfiguration)obj;
        return this.hasCdnIdentifierSecretArns() == other.hasCdnIdentifierSecretArns() && Objects.equals(this.cdnIdentifierSecretArns(), other.cdnIdentifierSecretArns()) && Objects.equals(this.secretsRoleArn(), other.secretsRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CdnAuthConfiguration").add("CdnIdentifierSecretArns", this.hasCdnIdentifierSecretArns() ? this.cdnIdentifierSecretArns() : null).add("SecretsRoleArn", (Object)this.secretsRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CdnIdentifierSecretArns": {
                return Optional.ofNullable(clazz.cast(this.cdnIdentifierSecretArns()));
            }
            case "SecretsRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CdnIdentifierSecretArns", CDN_IDENTIFIER_SECRET_ARNS_FIELD);
        map.put("SecretsRoleArn", SECRETS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CdnAuthConfiguration, T> g) {
        return obj -> g.apply((CdnAuthConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cdnIdentifierSecretArns = DefaultSdkAutoConstructList.getInstance();
        private String secretsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CdnAuthConfiguration model) {
            this.cdnIdentifierSecretArns(model.cdnIdentifierSecretArns);
            this.secretsRoleArn(model.secretsRoleArn);
        }

        public final Collection<String> getCdnIdentifierSecretArns() {
            if (this.cdnIdentifierSecretArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cdnIdentifierSecretArns;
        }

        public final void setCdnIdentifierSecretArns(Collection<String> cdnIdentifierSecretArns) {
            this.cdnIdentifierSecretArns = CdnAuthConfigurationCdnIdentifierSecretArnsListCopier.copy(cdnIdentifierSecretArns);
        }

        @Override
        public final Builder cdnIdentifierSecretArns(Collection<String> cdnIdentifierSecretArns) {
            this.cdnIdentifierSecretArns = CdnAuthConfigurationCdnIdentifierSecretArnsListCopier.copy(cdnIdentifierSecretArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cdnIdentifierSecretArns(String ... cdnIdentifierSecretArns) {
            this.cdnIdentifierSecretArns(Arrays.asList(cdnIdentifierSecretArns));
            return this;
        }

        public final String getSecretsRoleArn() {
            return this.secretsRoleArn;
        }

        public final void setSecretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
        }

        @Override
        public final Builder secretsRoleArn(String secretsRoleArn) {
            this.secretsRoleArn = secretsRoleArn;
            return this;
        }

        public CdnAuthConfiguration build() {
            return new CdnAuthConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CdnAuthConfiguration> {
        public Builder cdnIdentifierSecretArns(Collection<String> var1);

        public Builder cdnIdentifierSecretArns(String ... var1);

        public Builder secretsRoleArn(String var1);
    }
}

