/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediapackagev2.model.InputSwitchConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.InputType;
import software.amazon.awssdk.services.mediapackagev2.model.MediaPackageV2Request;
import software.amazon.awssdk.services.mediapackagev2.model.OutputHeaderConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelRequest
extends MediaPackageV2Request
implements ToCopyableBuilder<Builder, CreateChannelRequest> {
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(CreateChannelRequest.getter(CreateChannelRequest::channelGroupName)).setter(CreateChannelRequest.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(CreateChannelRequest.getter(CreateChannelRequest::channelName)).setter(CreateChannelRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateChannelRequest.getter(CreateChannelRequest::clientToken)).setter(CreateChannelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-client-token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputType").getter(CreateChannelRequest.getter(CreateChannelRequest::inputTypeAsString)).setter(CreateChannelRequest.setter(Builder::inputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateChannelRequest.getter(CreateChannelRequest::description)).setter(CreateChannelRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<InputSwitchConfiguration> INPUT_SWITCH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSwitchConfiguration").getter(CreateChannelRequest.getter(CreateChannelRequest::inputSwitchConfiguration)).setter(CreateChannelRequest.setter(Builder::inputSwitchConfiguration)).constructor(InputSwitchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSwitchConfiguration").build()}).build();
    private static final SdkField<OutputHeaderConfiguration> OUTPUT_HEADER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputHeaderConfiguration").getter(CreateChannelRequest.getter(CreateChannelRequest::outputHeaderConfiguration)).setter(CreateChannelRequest.setter(Builder::outputHeaderConfiguration)).constructor(OutputHeaderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputHeaderConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateChannelRequest.getter(CreateChannelRequest::tags)).setter(CreateChannelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, CLIENT_TOKEN_FIELD, INPUT_TYPE_FIELD, DESCRIPTION_FIELD, INPUT_SWITCH_CONFIGURATION_FIELD, OUTPUT_HEADER_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateChannelRequest.memberNameToFieldInitializer();
    private final String channelGroupName;
    private final String channelName;
    private final String clientToken;
    private final String inputType;
    private final String description;
    private final InputSwitchConfiguration inputSwitchConfiguration;
    private final OutputHeaderConfiguration outputHeaderConfiguration;
    private final Map<String, String> tags;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.clientToken = builder.clientToken;
        this.inputType = builder.inputType;
        this.description = builder.description;
        this.inputSwitchConfiguration = builder.inputSwitchConfiguration;
        this.outputHeaderConfiguration = builder.outputHeaderConfiguration;
        this.tags = builder.tags;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final InputType inputType() {
        return InputType.fromValue(this.inputType);
    }

    public final String inputTypeAsString() {
        return this.inputType;
    }

    public final String description() {
        return this.description;
    }

    public final InputSwitchConfiguration inputSwitchConfiguration() {
        return this.inputSwitchConfiguration;
    }

    public final OutputHeaderConfiguration outputHeaderConfiguration() {
        return this.outputHeaderConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSwitchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputHeaderConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)((Object)obj);
        return Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.inputTypeAsString(), other.inputTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.inputSwitchConfiguration(), other.inputSwitchConfiguration()) && Objects.equals(this.outputHeaderConfiguration(), other.outputHeaderConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateChannelRequest").add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("ClientToken", (Object)this.clientToken()).add("InputType", (Object)this.inputTypeAsString()).add("Description", (Object)this.description()).add("InputSwitchConfiguration", (Object)this.inputSwitchConfiguration()).add("OutputHeaderConfiguration", (Object)this.outputHeaderConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "InputType": {
                return Optional.ofNullable(clazz.cast(this.inputTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InputSwitchConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputSwitchConfiguration()));
            }
            case "OutputHeaderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputHeaderConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChannelGroupName", CHANNEL_GROUP_NAME_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("x-amzn-client-token", CLIENT_TOKEN_FIELD);
        map.put("InputType", INPUT_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InputSwitchConfiguration", INPUT_SWITCH_CONFIGURATION_FIELD);
        map.put("OutputHeaderConfiguration", OUTPUT_HEADER_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageV2Request.BuilderImpl
    implements Builder {
        private String channelGroupName;
        private String channelName;
        private String clientToken;
        private String inputType;
        private String description;
        private InputSwitchConfiguration inputSwitchConfiguration;
        private OutputHeaderConfiguration outputHeaderConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.clientToken(model.clientToken);
            this.inputType(model.inputType);
            this.description(model.description);
            this.inputSwitchConfiguration(model.inputSwitchConfiguration);
            this.outputHeaderConfiguration(model.outputHeaderConfiguration);
            this.tags(model.tags);
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInputType() {
            return this.inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(InputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final InputSwitchConfiguration.Builder getInputSwitchConfiguration() {
            return this.inputSwitchConfiguration != null ? this.inputSwitchConfiguration.toBuilder() : null;
        }

        public final void setInputSwitchConfiguration(InputSwitchConfiguration.BuilderImpl inputSwitchConfiguration) {
            this.inputSwitchConfiguration = inputSwitchConfiguration != null ? inputSwitchConfiguration.build() : null;
        }

        @Override
        public final Builder inputSwitchConfiguration(InputSwitchConfiguration inputSwitchConfiguration) {
            this.inputSwitchConfiguration = inputSwitchConfiguration;
            return this;
        }

        public final OutputHeaderConfiguration.Builder getOutputHeaderConfiguration() {
            return this.outputHeaderConfiguration != null ? this.outputHeaderConfiguration.toBuilder() : null;
        }

        public final void setOutputHeaderConfiguration(OutputHeaderConfiguration.BuilderImpl outputHeaderConfiguration) {
            this.outputHeaderConfiguration = outputHeaderConfiguration != null ? outputHeaderConfiguration.build() : null;
        }

        @Override
        public final Builder outputHeaderConfiguration(OutputHeaderConfiguration outputHeaderConfiguration) {
            this.outputHeaderConfiguration = outputHeaderConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaPackageV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelRequest> {
        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder clientToken(String var1);

        public Builder inputType(String var1);

        public Builder inputType(InputType var1);

        public Builder description(String var1);

        public Builder inputSwitchConfiguration(InputSwitchConfiguration var1);

        default public Builder inputSwitchConfiguration(Consumer<InputSwitchConfiguration.Builder> inputSwitchConfiguration) {
            return this.inputSwitchConfiguration((InputSwitchConfiguration)((InputSwitchConfiguration.Builder)InputSwitchConfiguration.builder().applyMutation(inputSwitchConfiguration)).build());
        }

        public Builder outputHeaderConfiguration(OutputHeaderConfiguration var1);

        default public Builder outputHeaderConfiguration(Consumer<OutputHeaderConfiguration.Builder> outputHeaderConfiguration) {
            return this.outputHeaderConfiguration((OutputHeaderConfiguration)((OutputHeaderConfiguration.Builder)OutputHeaderConfiguration.builder().applyMutation(outputHeaderConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

