/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.DashBaseUrl;
import software.amazon.awssdk.services.mediapackagev2.model.DashBaseUrlsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.DashCompactness;
import software.amazon.awssdk.services.mediapackagev2.model.DashDrmSignaling;
import software.amazon.awssdk.services.mediapackagev2.model.DashDvbSettings;
import software.amazon.awssdk.services.mediapackagev2.model.DashPeriodTrigger;
import software.amazon.awssdk.services.mediapackagev2.model.DashPeriodTriggersCopier;
import software.amazon.awssdk.services.mediapackagev2.model.DashProfile;
import software.amazon.awssdk.services.mediapackagev2.model.DashProfilesCopier;
import software.amazon.awssdk.services.mediapackagev2.model.DashProgramInformation;
import software.amazon.awssdk.services.mediapackagev2.model.DashSegmentTemplateFormat;
import software.amazon.awssdk.services.mediapackagev2.model.DashSubtitleConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.DashUtcTiming;
import software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ScteDash;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDashManifestConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateDashManifestConfiguration> {
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::manifestName)).setter(CreateDashManifestConfiguration.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()}).build();
    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManifestWindowSeconds").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::manifestWindowSeconds)).setter(CreateDashManifestConfiguration.setter(Builder::manifestWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build()}).build();
    private static final SdkField<FilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterConfiguration").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::filterConfiguration)).setter(CreateDashManifestConfiguration.setter(Builder::filterConfiguration)).constructor(FilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConfiguration").build()}).build();
    private static final SdkField<Integer> MIN_UPDATE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinUpdatePeriodSeconds").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::minUpdatePeriodSeconds)).setter(CreateDashManifestConfiguration.setter(Builder::minUpdatePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUpdatePeriodSeconds").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBufferTimeSeconds").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::minBufferTimeSeconds)).setter(CreateDashManifestConfiguration.setter(Builder::minBufferTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinBufferTimeSeconds").build()}).build();
    private static final SdkField<Integer> SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuggestedPresentationDelaySeconds").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::suggestedPresentationDelaySeconds)).setter(CreateDashManifestConfiguration.setter(Builder::suggestedPresentationDelaySeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedPresentationDelaySeconds").build()}).build();
    private static final SdkField<String> SEGMENT_TEMPLATE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentTemplateFormat").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::segmentTemplateFormatAsString)).setter(CreateDashManifestConfiguration.setter(Builder::segmentTemplateFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentTemplateFormat").build()}).build();
    private static final SdkField<List<String>> PERIOD_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PeriodTriggers").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::periodTriggersAsStrings)).setter(CreateDashManifestConfiguration.setter(Builder::periodTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ScteDash> SCTE_DASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScteDash").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::scteDash)).setter(CreateDashManifestConfiguration.setter(Builder::scteDash)).constructor(ScteDash::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScteDash").build()}).build();
    private static final SdkField<String> DRM_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DrmSignaling").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::drmSignalingAsString)).setter(CreateDashManifestConfiguration.setter(Builder::drmSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrmSignaling").build()}).build();
    private static final SdkField<DashUtcTiming> UTC_TIMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UtcTiming").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::utcTiming)).setter(CreateDashManifestConfiguration.setter(Builder::utcTiming)).constructor(DashUtcTiming::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtcTiming").build()}).build();
    private static final SdkField<List<String>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Profiles").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::profilesAsStrings)).setter(CreateDashManifestConfiguration.setter(Builder::profilesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DashBaseUrl>> BASE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaseUrls").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::baseUrls)).setter(CreateDashManifestConfiguration.setter(Builder::baseUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashBaseUrl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DashProgramInformation> PROGRAM_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgramInformation").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::programInformation)).setter(CreateDashManifestConfiguration.setter(Builder::programInformation)).constructor(DashProgramInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramInformation").build()}).build();
    private static final SdkField<DashDvbSettings> DVB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DvbSettings").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::dvbSettings)).setter(CreateDashManifestConfiguration.setter(Builder::dvbSettings)).constructor(DashDvbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DvbSettings").build()}).build();
    private static final SdkField<String> COMPACTNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compactness").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::compactnessAsString)).setter(CreateDashManifestConfiguration.setter(Builder::compactness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compactness").build()}).build();
    private static final SdkField<DashSubtitleConfiguration> SUBTITLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubtitleConfiguration").getter(CreateDashManifestConfiguration.getter(CreateDashManifestConfiguration::subtitleConfiguration)).setter(CreateDashManifestConfiguration.setter(Builder::subtitleConfiguration)).constructor(DashSubtitleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubtitleConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_NAME_FIELD, MANIFEST_WINDOW_SECONDS_FIELD, FILTER_CONFIGURATION_FIELD, MIN_UPDATE_PERIOD_SECONDS_FIELD, MIN_BUFFER_TIME_SECONDS_FIELD, SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD, SEGMENT_TEMPLATE_FORMAT_FIELD, PERIOD_TRIGGERS_FIELD, SCTE_DASH_FIELD, DRM_SIGNALING_FIELD, UTC_TIMING_FIELD, PROFILES_FIELD, BASE_URLS_FIELD, PROGRAM_INFORMATION_FIELD, DVB_SETTINGS_FIELD, COMPACTNESS_FIELD, SUBTITLE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDashManifestConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String manifestName;
    private final Integer manifestWindowSeconds;
    private final FilterConfiguration filterConfiguration;
    private final Integer minUpdatePeriodSeconds;
    private final Integer minBufferTimeSeconds;
    private final Integer suggestedPresentationDelaySeconds;
    private final String segmentTemplateFormat;
    private final List<String> periodTriggers;
    private final ScteDash scteDash;
    private final String drmSignaling;
    private final DashUtcTiming utcTiming;
    private final List<String> profiles;
    private final List<DashBaseUrl> baseUrls;
    private final DashProgramInformation programInformation;
    private final DashDvbSettings dvbSettings;
    private final String compactness;
    private final DashSubtitleConfiguration subtitleConfiguration;

    private CreateDashManifestConfiguration(BuilderImpl builder) {
        this.manifestName = builder.manifestName;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.filterConfiguration = builder.filterConfiguration;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
        this.segmentTemplateFormat = builder.segmentTemplateFormat;
        this.periodTriggers = builder.periodTriggers;
        this.scteDash = builder.scteDash;
        this.drmSignaling = builder.drmSignaling;
        this.utcTiming = builder.utcTiming;
        this.profiles = builder.profiles;
        this.baseUrls = builder.baseUrls;
        this.programInformation = builder.programInformation;
        this.dvbSettings = builder.dvbSettings;
        this.compactness = builder.compactness;
        this.subtitleConfiguration = builder.subtitleConfiguration;
    }

    public final String manifestName() {
        return this.manifestName;
    }

    public final Integer manifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public final FilterConfiguration filterConfiguration() {
        return this.filterConfiguration;
    }

    public final Integer minUpdatePeriodSeconds() {
        return this.minUpdatePeriodSeconds;
    }

    public final Integer minBufferTimeSeconds() {
        return this.minBufferTimeSeconds;
    }

    public final Integer suggestedPresentationDelaySeconds() {
        return this.suggestedPresentationDelaySeconds;
    }

    public final DashSegmentTemplateFormat segmentTemplateFormat() {
        return DashSegmentTemplateFormat.fromValue(this.segmentTemplateFormat);
    }

    public final String segmentTemplateFormatAsString() {
        return this.segmentTemplateFormat;
    }

    public final List<DashPeriodTrigger> periodTriggers() {
        return DashPeriodTriggersCopier.copyStringToEnum(this.periodTriggers);
    }

    public final boolean hasPeriodTriggers() {
        return this.periodTriggers != null && !(this.periodTriggers instanceof SdkAutoConstructList);
    }

    public final List<String> periodTriggersAsStrings() {
        return this.periodTriggers;
    }

    public final ScteDash scteDash() {
        return this.scteDash;
    }

    public final DashDrmSignaling drmSignaling() {
        return DashDrmSignaling.fromValue(this.drmSignaling);
    }

    public final String drmSignalingAsString() {
        return this.drmSignaling;
    }

    public final DashUtcTiming utcTiming() {
        return this.utcTiming;
    }

    public final List<DashProfile> profiles() {
        return DashProfilesCopier.copyStringToEnum(this.profiles);
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructList);
    }

    public final List<String> profilesAsStrings() {
        return this.profiles;
    }

    public final boolean hasBaseUrls() {
        return this.baseUrls != null && !(this.baseUrls instanceof SdkAutoConstructList);
    }

    public final List<DashBaseUrl> baseUrls() {
        return this.baseUrls;
    }

    public final DashProgramInformation programInformation() {
        return this.programInformation;
    }

    public final DashDvbSettings dvbSettings() {
        return this.dvbSettings;
    }

    public final DashCompactness compactness() {
        return DashCompactness.fromValue(this.compactness);
    }

    public final String compactnessAsString() {
        return this.compactness;
    }

    public final DashSubtitleConfiguration subtitleConfiguration() {
        return this.subtitleConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.suggestedPresentationDelaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentTemplateFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeriodTriggers() ? this.periodTriggersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scteDash());
        hashCode = 31 * hashCode + Objects.hashCode(this.drmSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.utcTiming());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profilesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaseUrls() ? this.baseUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.programInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.compactnessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitleConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashManifestConfiguration)) {
            return false;
        }
        CreateDashManifestConfiguration other = (CreateDashManifestConfiguration)obj;
        return Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.manifestWindowSeconds(), other.manifestWindowSeconds()) && Objects.equals(this.filterConfiguration(), other.filterConfiguration()) && Objects.equals(this.minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds()) && Objects.equals(this.minBufferTimeSeconds(), other.minBufferTimeSeconds()) && Objects.equals(this.suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds()) && Objects.equals(this.segmentTemplateFormatAsString(), other.segmentTemplateFormatAsString()) && this.hasPeriodTriggers() == other.hasPeriodTriggers() && Objects.equals(this.periodTriggersAsStrings(), other.periodTriggersAsStrings()) && Objects.equals(this.scteDash(), other.scteDash()) && Objects.equals(this.drmSignalingAsString(), other.drmSignalingAsString()) && Objects.equals(this.utcTiming(), other.utcTiming()) && this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profilesAsStrings(), other.profilesAsStrings()) && this.hasBaseUrls() == other.hasBaseUrls() && Objects.equals(this.baseUrls(), other.baseUrls()) && Objects.equals(this.programInformation(), other.programInformation()) && Objects.equals(this.dvbSettings(), other.dvbSettings()) && Objects.equals(this.compactnessAsString(), other.compactnessAsString()) && Objects.equals(this.subtitleConfiguration(), other.subtitleConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDashManifestConfiguration").add("ManifestName", (Object)this.manifestName()).add("ManifestWindowSeconds", (Object)this.manifestWindowSeconds()).add("FilterConfiguration", (Object)this.filterConfiguration()).add("MinUpdatePeriodSeconds", (Object)this.minUpdatePeriodSeconds()).add("MinBufferTimeSeconds", (Object)this.minBufferTimeSeconds()).add("SuggestedPresentationDelaySeconds", (Object)this.suggestedPresentationDelaySeconds()).add("SegmentTemplateFormat", (Object)this.segmentTemplateFormatAsString()).add("PeriodTriggers", this.hasPeriodTriggers() ? this.periodTriggersAsStrings() : null).add("ScteDash", (Object)this.scteDash()).add("DrmSignaling", (Object)this.drmSignalingAsString()).add("UtcTiming", (Object)this.utcTiming()).add("Profiles", this.hasProfiles() ? this.profilesAsStrings() : null).add("BaseUrls", this.hasBaseUrls() ? this.baseUrls() : null).add("ProgramInformation", (Object)this.programInformation()).add("DvbSettings", (Object)this.dvbSettings()).add("Compactness", (Object)this.compactnessAsString()).add("SubtitleConfiguration", (Object)this.subtitleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "ManifestWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.manifestWindowSeconds()));
            }
            case "FilterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.filterConfiguration()));
            }
            case "MinUpdatePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.minUpdatePeriodSeconds()));
            }
            case "MinBufferTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.minBufferTimeSeconds()));
            }
            case "SuggestedPresentationDelaySeconds": {
                return Optional.ofNullable(clazz.cast(this.suggestedPresentationDelaySeconds()));
            }
            case "SegmentTemplateFormat": {
                return Optional.ofNullable(clazz.cast(this.segmentTemplateFormatAsString()));
            }
            case "PeriodTriggers": {
                return Optional.ofNullable(clazz.cast(this.periodTriggersAsStrings()));
            }
            case "ScteDash": {
                return Optional.ofNullable(clazz.cast(this.scteDash()));
            }
            case "DrmSignaling": {
                return Optional.ofNullable(clazz.cast(this.drmSignalingAsString()));
            }
            case "UtcTiming": {
                return Optional.ofNullable(clazz.cast(this.utcTiming()));
            }
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profilesAsStrings()));
            }
            case "BaseUrls": {
                return Optional.ofNullable(clazz.cast(this.baseUrls()));
            }
            case "ProgramInformation": {
                return Optional.ofNullable(clazz.cast(this.programInformation()));
            }
            case "DvbSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbSettings()));
            }
            case "Compactness": {
                return Optional.ofNullable(clazz.cast(this.compactnessAsString()));
            }
            case "SubtitleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.subtitleConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManifestName", MANIFEST_NAME_FIELD);
        map.put("ManifestWindowSeconds", MANIFEST_WINDOW_SECONDS_FIELD);
        map.put("FilterConfiguration", FILTER_CONFIGURATION_FIELD);
        map.put("MinUpdatePeriodSeconds", MIN_UPDATE_PERIOD_SECONDS_FIELD);
        map.put("MinBufferTimeSeconds", MIN_BUFFER_TIME_SECONDS_FIELD);
        map.put("SuggestedPresentationDelaySeconds", SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD);
        map.put("SegmentTemplateFormat", SEGMENT_TEMPLATE_FORMAT_FIELD);
        map.put("PeriodTriggers", PERIOD_TRIGGERS_FIELD);
        map.put("ScteDash", SCTE_DASH_FIELD);
        map.put("DrmSignaling", DRM_SIGNALING_FIELD);
        map.put("UtcTiming", UTC_TIMING_FIELD);
        map.put("Profiles", PROFILES_FIELD);
        map.put("BaseUrls", BASE_URLS_FIELD);
        map.put("ProgramInformation", PROGRAM_INFORMATION_FIELD);
        map.put("DvbSettings", DVB_SETTINGS_FIELD);
        map.put("Compactness", COMPACTNESS_FIELD);
        map.put("SubtitleConfiguration", SUBTITLE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDashManifestConfiguration, T> g) {
        return obj -> g.apply((CreateDashManifestConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestName;
        private Integer manifestWindowSeconds;
        private FilterConfiguration filterConfiguration;
        private Integer minUpdatePeriodSeconds;
        private Integer minBufferTimeSeconds;
        private Integer suggestedPresentationDelaySeconds;
        private String segmentTemplateFormat;
        private List<String> periodTriggers = DefaultSdkAutoConstructList.getInstance();
        private ScteDash scteDash;
        private String drmSignaling;
        private DashUtcTiming utcTiming;
        private List<String> profiles = DefaultSdkAutoConstructList.getInstance();
        private List<DashBaseUrl> baseUrls = DefaultSdkAutoConstructList.getInstance();
        private DashProgramInformation programInformation;
        private DashDvbSettings dvbSettings;
        private String compactness;
        private DashSubtitleConfiguration subtitleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashManifestConfiguration model) {
            this.manifestName(model.manifestName);
            this.manifestWindowSeconds(model.manifestWindowSeconds);
            this.filterConfiguration(model.filterConfiguration);
            this.minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            this.minBufferTimeSeconds(model.minBufferTimeSeconds);
            this.suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
            this.segmentTemplateFormat(model.segmentTemplateFormat);
            this.periodTriggersWithStrings(model.periodTriggers);
            this.scteDash(model.scteDash);
            this.drmSignaling(model.drmSignaling);
            this.utcTiming(model.utcTiming);
            this.profilesWithStrings(model.profiles);
            this.baseUrls(model.baseUrls);
            this.programInformation(model.programInformation);
            this.dvbSettings(model.dvbSettings);
            this.compactness(model.compactness);
            this.subtitleConfiguration(model.subtitleConfiguration);
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return this.manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final FilterConfiguration.Builder getFilterConfiguration() {
            return this.filterConfiguration != null ? this.filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(FilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(FilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return this.minUpdatePeriodSeconds;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final Integer getMinBufferTimeSeconds() {
            return this.minBufferTimeSeconds;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return this.suggestedPresentationDelaySeconds;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        public final String getSegmentTemplateFormat() {
            return this.segmentTemplateFormat;
        }

        public final void setSegmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
        }

        @Override
        public final Builder segmentTemplateFormat(String segmentTemplateFormat) {
            this.segmentTemplateFormat = segmentTemplateFormat;
            return this;
        }

        @Override
        public final Builder segmentTemplateFormat(DashSegmentTemplateFormat segmentTemplateFormat) {
            this.segmentTemplateFormat(segmentTemplateFormat == null ? null : segmentTemplateFormat.toString());
            return this;
        }

        public final Collection<String> getPeriodTriggers() {
            if (this.periodTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.periodTriggers;
        }

        public final void setPeriodTriggers(Collection<String> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copy(periodTriggers);
        }

        @Override
        public final Builder periodTriggersWithStrings(Collection<String> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copy(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggersWithStrings(String ... periodTriggers) {
            this.periodTriggersWithStrings(Arrays.asList(periodTriggers));
            return this;
        }

        @Override
        public final Builder periodTriggers(Collection<DashPeriodTrigger> periodTriggers) {
            this.periodTriggers = DashPeriodTriggersCopier.copyEnumToString(periodTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder periodTriggers(DashPeriodTrigger ... periodTriggers) {
            this.periodTriggers(Arrays.asList(periodTriggers));
            return this;
        }

        public final ScteDash.Builder getScteDash() {
            return this.scteDash != null ? this.scteDash.toBuilder() : null;
        }

        public final void setScteDash(ScteDash.BuilderImpl scteDash) {
            this.scteDash = scteDash != null ? scteDash.build() : null;
        }

        @Override
        public final Builder scteDash(ScteDash scteDash) {
            this.scteDash = scteDash;
            return this;
        }

        public final String getDrmSignaling() {
            return this.drmSignaling;
        }

        public final void setDrmSignaling(String drmSignaling) {
            this.drmSignaling = drmSignaling;
        }

        @Override
        public final Builder drmSignaling(String drmSignaling) {
            this.drmSignaling = drmSignaling;
            return this;
        }

        @Override
        public final Builder drmSignaling(DashDrmSignaling drmSignaling) {
            this.drmSignaling(drmSignaling == null ? null : drmSignaling.toString());
            return this;
        }

        public final DashUtcTiming.Builder getUtcTiming() {
            return this.utcTiming != null ? this.utcTiming.toBuilder() : null;
        }

        public final void setUtcTiming(DashUtcTiming.BuilderImpl utcTiming) {
            this.utcTiming = utcTiming != null ? utcTiming.build() : null;
        }

        @Override
        public final Builder utcTiming(DashUtcTiming utcTiming) {
            this.utcTiming = utcTiming;
            return this;
        }

        public final Collection<String> getProfiles() {
            if (this.profiles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profiles;
        }

        public final void setProfiles(Collection<String> profiles) {
            this.profiles = DashProfilesCopier.copy(profiles);
        }

        @Override
        public final Builder profilesWithStrings(Collection<String> profiles) {
            this.profiles = DashProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilesWithStrings(String ... profiles) {
            this.profilesWithStrings(Arrays.asList(profiles));
            return this;
        }

        @Override
        public final Builder profiles(Collection<DashProfile> profiles) {
            this.profiles = DashProfilesCopier.copyEnumToString(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(DashProfile ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        public final List<DashBaseUrl.Builder> getBaseUrls() {
            List<DashBaseUrl.Builder> result = DashBaseUrlsCopier.copyToBuilder(this.baseUrls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaseUrls(Collection<DashBaseUrl.BuilderImpl> baseUrls) {
            this.baseUrls = DashBaseUrlsCopier.copyFromBuilder(baseUrls);
        }

        @Override
        public final Builder baseUrls(Collection<DashBaseUrl> baseUrls) {
            this.baseUrls = DashBaseUrlsCopier.copy(baseUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseUrls(DashBaseUrl ... baseUrls) {
            this.baseUrls(Arrays.asList(baseUrls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baseUrls(Consumer<DashBaseUrl.Builder> ... baseUrls) {
            this.baseUrls(Stream.of(baseUrls).map(c -> (DashBaseUrl)((DashBaseUrl.Builder)DashBaseUrl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DashProgramInformation.Builder getProgramInformation() {
            return this.programInformation != null ? this.programInformation.toBuilder() : null;
        }

        public final void setProgramInformation(DashProgramInformation.BuilderImpl programInformation) {
            this.programInformation = programInformation != null ? programInformation.build() : null;
        }

        @Override
        public final Builder programInformation(DashProgramInformation programInformation) {
            this.programInformation = programInformation;
            return this;
        }

        public final DashDvbSettings.Builder getDvbSettings() {
            return this.dvbSettings != null ? this.dvbSettings.toBuilder() : null;
        }

        public final void setDvbSettings(DashDvbSettings.BuilderImpl dvbSettings) {
            this.dvbSettings = dvbSettings != null ? dvbSettings.build() : null;
        }

        @Override
        public final Builder dvbSettings(DashDvbSettings dvbSettings) {
            this.dvbSettings = dvbSettings;
            return this;
        }

        public final String getCompactness() {
            return this.compactness;
        }

        public final void setCompactness(String compactness) {
            this.compactness = compactness;
        }

        @Override
        public final Builder compactness(String compactness) {
            this.compactness = compactness;
            return this;
        }

        @Override
        public final Builder compactness(DashCompactness compactness) {
            this.compactness(compactness == null ? null : compactness.toString());
            return this;
        }

        public final DashSubtitleConfiguration.Builder getSubtitleConfiguration() {
            return this.subtitleConfiguration != null ? this.subtitleConfiguration.toBuilder() : null;
        }

        public final void setSubtitleConfiguration(DashSubtitleConfiguration.BuilderImpl subtitleConfiguration) {
            this.subtitleConfiguration = subtitleConfiguration != null ? subtitleConfiguration.build() : null;
        }

        @Override
        public final Builder subtitleConfiguration(DashSubtitleConfiguration subtitleConfiguration) {
            this.subtitleConfiguration = subtitleConfiguration;
            return this;
        }

        public CreateDashManifestConfiguration build() {
            return new CreateDashManifestConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateDashManifestConfiguration> {
        public Builder manifestName(String var1);

        public Builder manifestWindowSeconds(Integer var1);

        public Builder filterConfiguration(FilterConfiguration var1);

        default public Builder filterConfiguration(Consumer<FilterConfiguration.Builder> filterConfiguration) {
            return this.filterConfiguration((FilterConfiguration)((FilterConfiguration.Builder)FilterConfiguration.builder().applyMutation(filterConfiguration)).build());
        }

        public Builder minUpdatePeriodSeconds(Integer var1);

        public Builder minBufferTimeSeconds(Integer var1);

        public Builder suggestedPresentationDelaySeconds(Integer var1);

        public Builder segmentTemplateFormat(String var1);

        public Builder segmentTemplateFormat(DashSegmentTemplateFormat var1);

        public Builder periodTriggersWithStrings(Collection<String> var1);

        public Builder periodTriggersWithStrings(String ... var1);

        public Builder periodTriggers(Collection<DashPeriodTrigger> var1);

        public Builder periodTriggers(DashPeriodTrigger ... var1);

        public Builder scteDash(ScteDash var1);

        default public Builder scteDash(Consumer<ScteDash.Builder> scteDash) {
            return this.scteDash((ScteDash)((ScteDash.Builder)ScteDash.builder().applyMutation(scteDash)).build());
        }

        public Builder drmSignaling(String var1);

        public Builder drmSignaling(DashDrmSignaling var1);

        public Builder utcTiming(DashUtcTiming var1);

        default public Builder utcTiming(Consumer<DashUtcTiming.Builder> utcTiming) {
            return this.utcTiming((DashUtcTiming)((DashUtcTiming.Builder)DashUtcTiming.builder().applyMutation(utcTiming)).build());
        }

        public Builder profilesWithStrings(Collection<String> var1);

        public Builder profilesWithStrings(String ... var1);

        public Builder profiles(Collection<DashProfile> var1);

        public Builder profiles(DashProfile ... var1);

        public Builder baseUrls(Collection<DashBaseUrl> var1);

        public Builder baseUrls(DashBaseUrl ... var1);

        public Builder baseUrls(Consumer<DashBaseUrl.Builder> ... var1);

        public Builder programInformation(DashProgramInformation var1);

        default public Builder programInformation(Consumer<DashProgramInformation.Builder> programInformation) {
            return this.programInformation((DashProgramInformation)((DashProgramInformation.Builder)DashProgramInformation.builder().applyMutation(programInformation)).build());
        }

        public Builder dvbSettings(DashDvbSettings var1);

        default public Builder dvbSettings(Consumer<DashDvbSettings.Builder> dvbSettings) {
            return this.dvbSettings((DashDvbSettings)((DashDvbSettings.Builder)DashDvbSettings.builder().applyMutation(dvbSettings)).build());
        }

        public Builder compactness(String var1);

        public Builder compactness(DashCompactness var1);

        public Builder subtitleConfiguration(DashSubtitleConfiguration var1);

        default public Builder subtitleConfiguration(Consumer<DashSubtitleConfiguration.Builder> subtitleConfiguration) {
            return this.subtitleConfiguration((DashSubtitleConfiguration)((DashSubtitleConfiguration.Builder)DashSubtitleConfiguration.builder().applyMutation(subtitleConfiguration)).build());
        }
    }
}

