/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2Client;
import software.amazon.awssdk.services.mediapackagev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediapackagev2.model.HarvestJob;
import software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsRequest;
import software.amazon.awssdk.services.mediapackagev2.model.ListHarvestJobsResponse;

public class ListHarvestJobsIterable
implements SdkIterable<ListHarvestJobsResponse> {
    private final MediaPackageV2Client client;
    private final ListHarvestJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHarvestJobsIterable(MediaPackageV2Client client, ListHarvestJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHarvestJobsResponseFetcher();
    }

    public Iterator<ListHarvestJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HarvestJob> items() {
        Function<ListHarvestJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHarvestJobsResponseFetcher
    implements SyncPageFetcher<ListHarvestJobsResponse> {
        private ListHarvestJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListHarvestJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHarvestJobsResponse nextPage(ListHarvestJobsResponse previousPage) {
            if (previousPage == null) {
                return ListHarvestJobsIterable.this.client.listHarvestJobs(ListHarvestJobsIterable.this.firstRequest);
            }
            return ListHarvestJobsIterable.this.client.listHarvestJobs((ListHarvestJobsRequest)((Object)ListHarvestJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

