/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastore;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mediastore.model.ContainerInUseException;
import software.amazon.awssdk.services.mediastore.model.ContainerNotFoundException;
import software.amazon.awssdk.services.mediastore.model.CorsPolicyNotFoundException;
import software.amazon.awssdk.services.mediastore.model.CreateContainerRequest;
import software.amazon.awssdk.services.mediastore.model.CreateContainerResponse;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest;
import software.amazon.awssdk.services.mediastore.model.DeleteContainerResponse;
import software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest;
import software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyResponse;
import software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest;
import software.amazon.awssdk.services.mediastore.model.DescribeContainerResponse;
import software.amazon.awssdk.services.mediastore.model.GetContainerPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.GetContainerPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.GetCorsPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest;
import software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyResponse;
import software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.GetMetricPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediastore.model.LimitExceededException;
import software.amazon.awssdk.services.mediastore.model.ListContainersRequest;
import software.amazon.awssdk.services.mediastore.model.ListContainersResponse;
import software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediastore.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediastore.model.MediaStoreException;
import software.amazon.awssdk.services.mediastore.model.PolicyNotFoundException;
import software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.PutContainerPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.PutCorsPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest;
import software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyResponse;
import software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest;
import software.amazon.awssdk.services.mediastore.model.PutMetricPolicyResponse;
import software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest;
import software.amazon.awssdk.services.mediastore.model.StartAccessLoggingResponse;
import software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest;
import software.amazon.awssdk.services.mediastore.model.StopAccessLoggingResponse;
import software.amazon.awssdk.services.mediastore.model.TagResourceRequest;
import software.amazon.awssdk.services.mediastore.model.TagResourceResponse;
import software.amazon.awssdk.services.mediastore.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediastore.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable;

/**
 * Service client for accessing MediaStore. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * An AWS Elemental MediaStore container is a namespace that holds folders and objects. You use a container endpoint to
 * create, read, and delete objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaStoreClient extends AwsClient {
    String SERVICE_NAME = "mediastore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mediastore";

    /**
     * <p>
     * Creates a storage container to hold objects. A container is similar to a bucket in the Amazon S3 service.
     * </p>
     *
     * @param createContainerRequest
     * @return Result of the CreateContainer operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws LimitExceededException
     *         A service limit has been exceeded.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.CreateContainer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainer" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateContainerResponse createContainer(CreateContainerRequest createContainerRequest)
            throws ContainerInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a storage container to hold objects. A container is similar to a bucket in the Amazon S3 service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContainerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateContainerRequest#builder()}
     * </p>
     *
     * @param createContainerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.CreateContainerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContainer operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws LimitExceededException
     *         A service limit has been exceeded.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.CreateContainer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/CreateContainer" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateContainerResponse createContainer(Consumer<CreateContainerRequest.Builder> createContainerRequest)
            throws ContainerInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return createContainer(CreateContainerRequest.builder().applyMutation(createContainerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified container. Before you make a <code>DeleteContainer</code> request, delete any objects in
     * the container or in any folders in the container. You can delete only empty containers.
     * </p>
     *
     * @param deleteContainerRequest
     * @return Result of the DeleteContainer operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteContainer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteContainerResponse deleteContainer(DeleteContainerRequest deleteContainerRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified container. Before you make a <code>DeleteContainer</code> request, delete any objects in
     * the container or in any folders in the container. You can delete only empty containers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContainerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteContainerRequest#builder()}
     * </p>
     *
     * @param deleteContainerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.DeleteContainerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContainer operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteContainer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainer" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteContainerResponse deleteContainer(Consumer<DeleteContainerRequest.Builder> deleteContainerRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return deleteContainer(DeleteContainerRequest.builder().applyMutation(deleteContainerRequest).build());
    }

    /**
     * <p>
     * Deletes the access policy that is associated with the specified container.
     * </p>
     *
     * @param deleteContainerPolicyRequest
     * @return Result of the DeleteContainerPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteContainerPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContainerPolicyResponse deleteContainerPolicy(DeleteContainerPolicyRequest deleteContainerPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the access policy that is associated with the specified container.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContainerPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteContainerPolicyRequest#builder()}
     * </p>
     *
     * @param deleteContainerPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContainerPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteContainerPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteContainerPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContainerPolicyResponse deleteContainerPolicy(
            Consumer<DeleteContainerPolicyRequest.Builder> deleteContainerPolicyRequest) throws ContainerInUseException,
            ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return deleteContainerPolicy(DeleteContainerPolicyRequest.builder().applyMutation(deleteContainerPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the cross-origin resource sharing (CORS) configuration information that is set for the container.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>MediaStore:DeleteCorsPolicy</code> action.
     * The container owner has this permission by default and can grant this permission to others.
     * </p>
     *
     * @param deleteCorsPolicyRequest
     * @return Result of the DeleteCorsPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws CorsPolicyNotFoundException
     *         The CORS policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteCorsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteCorsPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCorsPolicyResponse deleteCorsPolicy(DeleteCorsPolicyRequest deleteCorsPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, CorsPolicyNotFoundException,
            InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the cross-origin resource sharing (CORS) configuration information that is set for the container.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>MediaStore:DeleteCorsPolicy</code> action.
     * The container owner has this permission by default and can grant this permission to others.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCorsPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCorsPolicyRequest#builder()}
     * </p>
     *
     * @param deleteCorsPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCorsPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws CorsPolicyNotFoundException
     *         The CORS policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteCorsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteCorsPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCorsPolicyResponse deleteCorsPolicy(Consumer<DeleteCorsPolicyRequest.Builder> deleteCorsPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, CorsPolicyNotFoundException,
            InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        return deleteCorsPolicy(DeleteCorsPolicyRequest.builder().applyMutation(deleteCorsPolicyRequest).build());
    }

    /**
     * <p>
     * Removes an object lifecycle policy from a container. It takes up to 20 minutes for the change to take effect.
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     * @return Result of the DeleteLifecyclePolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLifecyclePolicyResponse deleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an object lifecycle policy from a container. It takes up to 20 minutes for the change to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.DeleteLifecyclePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLifecyclePolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLifecyclePolicyResponse deleteLifecyclePolicy(
            Consumer<DeleteLifecyclePolicyRequest.Builder> deleteLifecyclePolicyRequest) throws ContainerInUseException,
            ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.builder().applyMutation(deleteLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the metric policy that is associated with the specified container. If there is no metric policy
     * associated with the container, MediaStore doesn't send metrics to CloudWatch.
     * </p>
     *
     * @param deleteMetricPolicyRequest
     * @return Result of the DeleteMetricPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteMetricPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteMetricPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMetricPolicyResponse deleteMetricPolicy(DeleteMetricPolicyRequest deleteMetricPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the metric policy that is associated with the specified container. If there is no metric policy
     * associated with the container, MediaStore doesn't send metrics to CloudWatch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMetricPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMetricPolicyRequest#builder()}
     * </p>
     *
     * @param deleteMetricPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMetricPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DeleteMetricPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DeleteMetricPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMetricPolicyResponse deleteMetricPolicy(Consumer<DeleteMetricPolicyRequest.Builder> deleteMetricPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        return deleteMetricPolicy(DeleteMetricPolicyRequest.builder().applyMutation(deleteMetricPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties of the requested container. This request is commonly used to retrieve the endpoint of a
     * container. An endpoint is a value assigned by the service when a new container is created. A container's endpoint
     * does not change after it has been assigned. The <code>DescribeContainer</code> request returns a single
     * <code>Container</code> object based on <code>ContainerName</code>. To return all <code>Container</code> objects
     * that are associated with a specified AWS account, use <a>ListContainers</a>.
     * </p>
     *
     * @param describeContainerRequest
     * @return Result of the DescribeContainer operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DescribeContainer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainer" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContainerResponse describeContainer(DescribeContainerRequest describeContainerRequest)
            throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties of the requested container. This request is commonly used to retrieve the endpoint of a
     * container. An endpoint is a value assigned by the service when a new container is created. A container's endpoint
     * does not change after it has been assigned. The <code>DescribeContainer</code> request returns a single
     * <code>Container</code> object based on <code>ContainerName</code>. To return all <code>Container</code> objects
     * that are associated with a specified AWS account, use <a>ListContainers</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContainerRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContainerRequest#builder()}
     * </p>
     *
     * @param describeContainerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.DescribeContainerRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContainer operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.DescribeContainer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/DescribeContainer" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContainerResponse describeContainer(Consumer<DescribeContainerRequest.Builder> describeContainerRequest)
            throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            MediaStoreException {
        return describeContainer(DescribeContainerRequest.builder().applyMutation(describeContainerRequest).build());
    }

    /**
     * <p>
     * Retrieves the access policy for the specified container. For information about the data that is included in an
     * access policy, see the <a href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management
     * User Guide</a>.
     * </p>
     *
     * @param getContainerPolicyRequest
     * @return Result of the GetContainerPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetContainerPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContainerPolicyResponse getContainerPolicy(GetContainerPolicyRequest getContainerPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the access policy for the specified container. For information about the data that is included in an
     * access policy, see the <a href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management
     * User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContainerPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetContainerPolicyRequest#builder()}
     * </p>
     *
     * @param getContainerPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.GetContainerPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetContainerPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetContainerPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContainerPolicyResponse getContainerPolicy(Consumer<GetContainerPolicyRequest.Builder> getContainerPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        return getContainerPolicy(GetContainerPolicyRequest.builder().applyMutation(getContainerPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the cross-origin resource sharing (CORS) configuration information that is set for the container.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>MediaStore:GetCorsPolicy</code> action. By
     * default, the container owner has this permission and can grant it to others.
     * </p>
     *
     * @param getCorsPolicyRequest
     * @return Result of the GetCorsPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws CorsPolicyNotFoundException
     *         The CORS policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetCorsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetCorsPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCorsPolicyResponse getCorsPolicy(GetCorsPolicyRequest getCorsPolicyRequest) throws ContainerInUseException,
            ContainerNotFoundException, CorsPolicyNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the cross-origin resource sharing (CORS) configuration information that is set for the container.
     * </p>
     * <p>
     * To use this operation, you must have permission to perform the <code>MediaStore:GetCorsPolicy</code> action. By
     * default, the container owner has this permission and can grant it to others.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCorsPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetCorsPolicyRequest#builder()}
     * </p>
     *
     * @param getCorsPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest.Builder} to create a request.
     * @return Result of the GetCorsPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws CorsPolicyNotFoundException
     *         The CORS policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetCorsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetCorsPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCorsPolicyResponse getCorsPolicy(Consumer<GetCorsPolicyRequest.Builder> getCorsPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, CorsPolicyNotFoundException,
            InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        return getCorsPolicy(GetCorsPolicyRequest.builder().applyMutation(getCorsPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the object lifecycle policy that is assigned to a container.
     * </p>
     *
     * @param getLifecyclePolicyRequest
     * @return Result of the GetLifecyclePolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetLifecyclePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyResponse getLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the object lifecycle policy that is assigned to a container.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param getLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetLifecyclePolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetLifecyclePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLifecyclePolicyResponse getLifecyclePolicy(Consumer<GetLifecyclePolicyRequest.Builder> getLifecyclePolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, PolicyNotFoundException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        return getLifecyclePolicy(GetLifecyclePolicyRequest.builder().applyMutation(getLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Returns the metric policy for the specified container.
     * </p>
     *
     * @param getMetricPolicyRequest
     * @return Result of the GetMetricPolicy operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetMetricPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetMetricPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMetricPolicyResponse getMetricPolicy(GetMetricPolicyRequest getMetricPolicyRequest)
            throws ContainerNotFoundException, PolicyNotFoundException, ContainerInUseException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metric policy for the specified container.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetMetricPolicyRequest#builder()}
     * </p>
     *
     * @param getMetricPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetMetricPolicy operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws PolicyNotFoundException
     *         The policy that you specified in the request does not exist.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.GetMetricPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetMetricPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMetricPolicyResponse getMetricPolicy(Consumer<GetMetricPolicyRequest.Builder> getMetricPolicyRequest)
            throws ContainerNotFoundException, PolicyNotFoundException, ContainerInUseException, InternalServerErrorException,
            AwsServiceException, SdkClientException, MediaStoreException {
        return getMetricPolicy(GetMetricPolicyRequest.builder().applyMutation(getMetricPolicyRequest).build());
    }

    /**
     * <p>
     * Lists the properties of all containers in AWS Elemental MediaStore.
     * </p>
     * <p>
     * You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code>
     * parameter to receive a limited number of containers in each response. In this case, the response includes a
     * token. To get the next set of containers, send the command again, this time with the <code>NextToken</code>
     * parameter (with the returned token as its value). The next set of responses appears, with a token if there are
     * still more containers to receive.
     * </p>
     * <p>
     * See also <a>DescribeContainer</a>, which gets the properties of one container.
     * </p>
     *
     * @param listContainersRequest
     * @return Result of the ListContainers operation returned by the service.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListContainers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContainersResponse listContainers(ListContainersRequest listContainersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the properties of all containers in AWS Elemental MediaStore.
     * </p>
     * <p>
     * You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code>
     * parameter to receive a limited number of containers in each response. In this case, the response includes a
     * token. To get the next set of containers, send the command again, this time with the <code>NextToken</code>
     * parameter (with the returned token as its value). The next set of responses appears, with a token if there are
     * still more containers to receive.
     * </p>
     * <p>
     * See also <a>DescribeContainer</a>, which gets the properties of one container.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainersRequest.Builder} avoiding the need to
     * create one manually via {@link ListContainersRequest#builder()}
     * </p>
     *
     * @param listContainersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.ListContainersRequest.Builder} to create a
     *        request.
     * @return Result of the ListContainers operation returned by the service.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListContainers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContainersResponse listContainers(Consumer<ListContainersRequest.Builder> listContainersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        return listContainers(ListContainersRequest.builder().applyMutation(listContainersRequest).build());
    }

    /**
     * <p>
     * Lists the properties of all containers in AWS Elemental MediaStore.
     * </p>
     * <p>
     * You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code>
     * parameter to receive a limited number of containers in each response. In this case, the response includes a
     * token. To get the next set of containers, send the command again, this time with the <code>NextToken</code>
     * parameter (with the returned token as its value). The next set of responses appears, with a token if there are
     * still more containers to receive.
     * </p>
     * <p>
     * See also <a>DescribeContainer</a>, which gets the properties of one container.
     * </p>
     *
     * @return Result of the ListContainers operation returned by the service.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListContainers
     * @see #listContainers(ListContainersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContainersResponse listContainers() throws InternalServerErrorException, AwsServiceException, SdkClientException,
            MediaStoreException {
        return listContainers(ListContainersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the properties of all containers in AWS Elemental MediaStore.
     * </p>
     * <p>
     * You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code>
     * parameter to receive a limited number of containers in each response. In this case, the response includes a
     * token. To get the next set of containers, send the command again, this time with the <code>NextToken</code>
     * parameter (with the returned token as its value). The next set of responses appears, with a token if there are
     * still more containers to receive.
     * </p>
     * <p>
     * See also <a>DescribeContainer</a>, which gets the properties of one container.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainers(software.amazon.awssdk.services.mediastore.model.ListContainersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client.listContainersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client
     *             .listContainersPaginator(request);
     *     for (software.amazon.awssdk.services.mediastore.model.ListContainersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client.listContainersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainers(software.amazon.awssdk.services.mediastore.model.ListContainersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListContainers
     * @see #listContainersPaginator(ListContainersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContainersIterable listContainersPaginator() throws InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return listContainersPaginator(ListContainersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the properties of all containers in AWS Elemental MediaStore.
     * </p>
     * <p>
     * You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code>
     * parameter to receive a limited number of containers in each response. In this case, the response includes a
     * token. To get the next set of containers, send the command again, this time with the <code>NextToken</code>
     * parameter (with the returned token as its value). The next set of responses appears, with a token if there are
     * still more containers to receive.
     * </p>
     * <p>
     * See also <a>DescribeContainer</a>, which gets the properties of one container.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainers(software.amazon.awssdk.services.mediastore.model.ListContainersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client.listContainersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client
     *             .listContainersPaginator(request);
     *     for (software.amazon.awssdk.services.mediastore.model.ListContainersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client.listContainersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainers(software.amazon.awssdk.services.mediastore.model.ListContainersRequest)} operation.</b>
     * </p>
     *
     * @param listContainersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListContainers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContainersIterable listContainersPaginator(ListContainersRequest listContainersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        return new ListContainersIterable(this, listContainersRequest);
    }

    /**
     * <p>
     * Lists the properties of all containers in AWS Elemental MediaStore.
     * </p>
     * <p>
     * You can query to receive all the containers in one response. Or you can include the <code>MaxResults</code>
     * parameter to receive a limited number of containers in each response. In this case, the response includes a
     * token. To get the next set of containers, send the command again, this time with the <code>NextToken</code>
     * parameter (with the returned token as its value). The next set of responses appears, with a token if there are
     * still more containers to receive.
     * </p>
     * <p>
     * See also <a>DescribeContainer</a>, which gets the properties of one container.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listContainers(software.amazon.awssdk.services.mediastore.model.ListContainersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client.listContainersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client
     *             .listContainersPaginator(request);
     *     for (software.amazon.awssdk.services.mediastore.model.ListContainersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediastore.paginators.ListContainersIterable responses = client.listContainersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainers(software.amazon.awssdk.services.mediastore.model.ListContainersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainersRequest.Builder} avoiding the need to
     * create one manually via {@link ListContainersRequest#builder()}
     * </p>
     *
     * @param listContainersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.ListContainersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListContainers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContainersIterable listContainersPaginator(Consumer<ListContainersRequest.Builder> listContainersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        return listContainersPaginator(ListContainersRequest.builder().applyMutation(listContainersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified container.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified container.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ContainerInUseException,
            ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            MediaStoreException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates an access policy for the specified container to restrict the users and clients that can access it. For
     * information about the data that is included in an access policy, see the <a
     * href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management User Guide</a>.
     * </p>
     * <p>
     * For this release of the REST API, you can create only one policy for a container. If you enter
     * <code>PutContainerPolicy</code> twice, the second command modifies the existing policy.
     * </p>
     *
     * @param putContainerPolicyRequest
     * @return Result of the PutContainerPolicy operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutContainerPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutContainerPolicyResponse putContainerPolicy(PutContainerPolicyRequest putContainerPolicyRequest)
            throws ContainerNotFoundException, ContainerInUseException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access policy for the specified container to restrict the users and clients that can access it. For
     * information about the data that is included in an access policy, see the <a
     * href="https://aws.amazon.com/documentation/iam/">AWS Identity and Access Management User Guide</a>.
     * </p>
     * <p>
     * For this release of the REST API, you can create only one policy for a container. If you enter
     * <code>PutContainerPolicy</code> twice, the second command modifies the existing policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutContainerPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutContainerPolicyRequest#builder()}
     * </p>
     *
     * @param putContainerPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutContainerPolicy operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutContainerPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutContainerPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutContainerPolicyResponse putContainerPolicy(Consumer<PutContainerPolicyRequest.Builder> putContainerPolicyRequest)
            throws ContainerNotFoundException, ContainerInUseException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return putContainerPolicy(PutContainerPolicyRequest.builder().applyMutation(putContainerPolicyRequest).build());
    }

    /**
     * <p>
     * Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service
     * cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to
     * access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest
     * capability.
     * </p>
     * <p>
     * To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules
     * that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to
     * 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses
     * the first applicable rule listed.
     * </p>
     * <p>
     * To learn more about CORS, see <a
     * href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in
     * AWS Elemental MediaStore</a>.
     * </p>
     *
     * @param putCorsPolicyRequest
     * @return Result of the PutCorsPolicy operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutCorsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutCorsPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutCorsPolicyResponse putCorsPolicy(PutCorsPolicyRequest putCorsPolicyRequest) throws ContainerNotFoundException,
            ContainerInUseException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the cross-origin resource sharing (CORS) configuration on a container so that the container can service
     * cross-origin requests. For example, you might want to enable a request whose origin is http://www.example.com to
     * access your AWS Elemental MediaStore container at my.example.container.com by using the browser's XMLHttpRequest
     * capability.
     * </p>
     * <p>
     * To enable CORS on a container, you attach a CORS policy to the container. In the CORS policy, you configure rules
     * that identify origins and the HTTP methods that can be executed on your container. The policy can contain up to
     * 398,000 characters. You can add up to 100 rules to a CORS policy. If more than one rule applies, the service uses
     * the first applicable rule listed.
     * </p>
     * <p>
     * To learn more about CORS, see <a
     * href="https://docs.aws.amazon.com/mediastore/latest/ug/cors-policy.html">Cross-Origin Resource Sharing (CORS) in
     * AWS Elemental MediaStore</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCorsPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutCorsPolicyRequest#builder()}
     * </p>
     *
     * @param putCorsPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.PutCorsPolicyRequest.Builder} to create a request.
     * @return Result of the PutCorsPolicy operation returned by the service.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutCorsPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutCorsPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutCorsPolicyResponse putCorsPolicy(Consumer<PutCorsPolicyRequest.Builder> putCorsPolicyRequest)
            throws ContainerNotFoundException, ContainerInUseException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return putCorsPolicy(PutCorsPolicyRequest.builder().applyMutation(putCorsPolicyRequest).build());
    }

    /**
     * <p>
     * Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the
     * service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take
     * effect.
     * </p>
     * <p>
     * For information about how to construct an object lifecycle policy, see <a
     * href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html">Components of
     * an Object Lifecycle Policy</a>.
     * </p>
     *
     * @param putLifecyclePolicyRequest
     * @return Result of the PutLifecyclePolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutLifecyclePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLifecyclePolicyResponse putLifecyclePolicy(PutLifecyclePolicyRequest putLifecyclePolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Writes an object lifecycle policy to a container. If the container already has an object lifecycle policy, the
     * service replaces the existing policy with the new policy. It takes up to 20 minutes for the change to take
     * effect.
     * </p>
     * <p>
     * For information about how to construct an object lifecycle policy, see <a
     * href="https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html">Components of
     * an Object Lifecycle Policy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param putLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutLifecyclePolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutLifecyclePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLifecyclePolicyResponse putLifecyclePolicy(Consumer<PutLifecyclePolicyRequest.Builder> putLifecyclePolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return putLifecyclePolicy(PutLifecyclePolicyRequest.builder().applyMutation(putLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * The metric policy that you want to add to the container. A metric policy allows AWS Elemental MediaStore to send
     * metrics to Amazon CloudWatch. It takes up to 20 minutes for the new policy to take effect.
     * </p>
     *
     * @param putMetricPolicyRequest
     * @return Result of the PutMetricPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutMetricPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutMetricPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutMetricPolicyResponse putMetricPolicy(PutMetricPolicyRequest putMetricPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The metric policy that you want to add to the container. A metric policy allows AWS Elemental MediaStore to send
     * metrics to Amazon CloudWatch. It takes up to 20 minutes for the new policy to take effect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMetricPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutMetricPolicyRequest#builder()}
     * </p>
     *
     * @param putMetricPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.PutMetricPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutMetricPolicy operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.PutMetricPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutMetricPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutMetricPolicyResponse putMetricPolicy(Consumer<PutMetricPolicyRequest.Builder> putMetricPolicyRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return putMetricPolicy(PutMetricPolicyRequest.builder().applyMutation(putMetricPolicyRequest).build());
    }

    /**
     * <p>
     * Starts access logging on the specified container. When you enable access logging on a container, MediaStore
     * delivers access logs for objects stored in that container to Amazon CloudWatch Logs.
     * </p>
     *
     * @param startAccessLoggingRequest
     * @return Result of the StartAccessLogging operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.StartAccessLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StartAccessLogging" target="_top">AWS
     *      API Documentation</a>
     */
    default StartAccessLoggingResponse startAccessLogging(StartAccessLoggingRequest startAccessLoggingRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts access logging on the specified container. When you enable access logging on a container, MediaStore
     * delivers access logs for objects stored in that container to Amazon CloudWatch Logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAccessLoggingRequest.Builder} avoiding the
     * need to create one manually via {@link StartAccessLoggingRequest#builder()}
     * </p>
     *
     * @param startAccessLoggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest.Builder} to create a
     *        request.
     * @return Result of the StartAccessLogging operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.StartAccessLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StartAccessLogging" target="_top">AWS
     *      API Documentation</a>
     */
    default StartAccessLoggingResponse startAccessLogging(Consumer<StartAccessLoggingRequest.Builder> startAccessLoggingRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return startAccessLogging(StartAccessLoggingRequest.builder().applyMutation(startAccessLoggingRequest).build());
    }

    /**
     * <p>
     * Stops access logging on the specified container. When you stop access logging on a container, MediaStore stops
     * sending access logs to Amazon CloudWatch Logs. These access logs are not saved and are not retrievable.
     * </p>
     *
     * @param stopAccessLoggingRequest
     * @return Result of the StopAccessLogging operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.StopAccessLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StopAccessLogging" target="_top">AWS
     *      API Documentation</a>
     */
    default StopAccessLoggingResponse stopAccessLogging(StopAccessLoggingRequest stopAccessLoggingRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops access logging on the specified container. When you stop access logging on a container, MediaStore stops
     * sending access logs to Amazon CloudWatch Logs. These access logs are not saved and are not retrievable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAccessLoggingRequest.Builder} avoiding the need
     * to create one manually via {@link StopAccessLoggingRequest#builder()}
     * </p>
     *
     * @param stopAccessLoggingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest.Builder} to create a
     *        request.
     * @return Result of the StopAccessLogging operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.StopAccessLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/StopAccessLogging" target="_top">AWS
     *      API Documentation</a>
     */
    default StopAccessLoggingResponse stopAccessLogging(Consumer<StopAccessLoggingRequest.Builder> stopAccessLoggingRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return stopAccessLogging(StopAccessLoggingRequest.builder().applyMutation(stopAccessLoggingRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs that you can associate
     * with AWS resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can
     * specify one or more tags to add to each container. You can add up to 50 tags to each container. For more
     * information about tagging, including naming and usage conventions, see <a
     * href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ContainerInUseException,
            ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs that you can associate
     * with AWS resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can
     * specify one or more tags to add to each container. You can add up to 50 tags to each container. For more
     * information about tagging, including naming and usage conventions, see <a
     * href="https://docs.aws.amazon.com/mediastore/latest/ug/tagging.html">Tagging Resources in MediaStore</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified container. You can specify one or more tags to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ContainerInUseException,
            ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            MediaStoreException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified container. You can specify one or more tags to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.mediastore.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ContainerInUseException
     *         The container that you specified in the request already exists or is being updated.
     * @throws ContainerNotFoundException
     *         The container that you specified in the request does not exist.
     * @throws InternalServerErrorException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaStoreException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaStoreClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ContainerInUseException, ContainerNotFoundException, InternalServerErrorException, AwsServiceException,
            SdkClientException, MediaStoreException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link MediaStoreClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaStoreClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaStoreClient}.
     */
    static MediaStoreClientBuilder builder() {
        return new DefaultMediaStoreClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MediaStoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
