/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.mediastore.auth.scheme.MediaStoreAuthSchemeParams;
import software.amazon.awssdk.services.mediastore.auth.scheme.internal.DefaultMediaStoreAuthSchemeProvider;
import software.amazon.awssdk.services.mediastore.auth.scheme.internal.PreferredMediaStoreAuthSchemeProvider;

@SdkPublicApi
public interface MediaStoreAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(MediaStoreAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<MediaStoreAuthSchemeParams.Builder> consumer) {
        MediaStoreAuthSchemeParams.Builder builder = MediaStoreAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static MediaStoreAuthSchemeProvider defaultProvider() {
        return DefaultMediaStoreAuthSchemeProvider.create();
    }

    public static MediaStoreAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredMediaStoreAuthSchemeProvider(MediaStoreAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

