/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureLogsForChannelResponse extends MediaTailorResponse implements
        ToCopyableBuilder<ConfigureLogsForChannelResponse.Builder, ConfigureLogsForChannelResponse> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(ConfigureLogsForChannelResponse::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<List<String>> LOG_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogTypes")
            .getter(getter(ConfigureLogsForChannelResponse::logTypesAsStrings))
            .setter(setter(Builder::logTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            LOG_TYPES_FIELD));

    private final String channelName;

    private final List<String> logTypes;

    private ConfigureLogsForChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.logTypes = builder.logTypes;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The types of logs collected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypes} method.
     * </p>
     * 
     * @return The types of logs collected.
     */
    public final List<LogType> logTypes() {
        return LogTypesCopier.copyStringToEnum(logTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the LogTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogTypes() {
        return logTypes != null && !(logTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of logs collected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypes} method.
     * </p>
     * 
     * @return The types of logs collected.
     */
    public final List<String> logTypesAsStrings() {
        return logTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogTypes() ? logTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForChannelResponse)) {
            return false;
        }
        ConfigureLogsForChannelResponse other = (ConfigureLogsForChannelResponse) obj;
        return Objects.equals(channelName(), other.channelName()) && hasLogTypes() == other.hasLogTypes()
                && Objects.equals(logTypesAsStrings(), other.logTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureLogsForChannelResponse").add("ChannelName", channelName())
                .add("LogTypes", hasLogTypes() ? logTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "LogTypes":
            return Optional.ofNullable(clazz.cast(logTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsForChannelResponse, T> g) {
        return obj -> g.apply((ConfigureLogsForChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfigureLogsForChannelResponse> {
        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param channelName
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The types of logs collected.
         * </p>
         * 
         * @param logTypes
         *        The types of logs collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesWithStrings(Collection<String> logTypes);

        /**
         * <p>
         * The types of logs collected.
         * </p>
         * 
         * @param logTypes
         *        The types of logs collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesWithStrings(String... logTypes);

        /**
         * <p>
         * The types of logs collected.
         * </p>
         * 
         * @param logTypes
         *        The types of logs collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypes(Collection<LogType> logTypes);

        /**
         * <p>
         * The types of logs collected.
         * </p>
         * 
         * @param logTypes
         *        The types of logs collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypes(LogType... logTypes);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private String channelName;

        private List<String> logTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsForChannelResponse model) {
            super(model);
            channelName(model.channelName);
            logTypesWithStrings(model.logTypes);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final Collection<String> getLogTypes() {
            if (logTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return logTypes;
        }

        public final void setLogTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypesWithStrings(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesWithStrings(String... logTypes) {
            logTypesWithStrings(Arrays.asList(logTypes));
            return this;
        }

        @Override
        public final Builder logTypes(Collection<LogType> logTypes) {
            this.logTypes = LogTypesCopier.copyEnumToString(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypes(LogType... logTypes) {
            logTypes(Arrays.asList(logTypes));
            return this;
        }

        @Override
        public ConfigureLogsForChannelResponse build() {
            return new ConfigureLogsForChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
