/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelRequest extends MediaTailorRequest implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(CreateChannelRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<SlateSource> FILLER_SLATE_FIELD = SdkField.<SlateSource> builder(MarshallingType.SDK_POJO)
            .memberName("FillerSlate").getter(getter(CreateChannelRequest::fillerSlate)).setter(setter(Builder::fillerSlate))
            .constructor(SlateSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillerSlate").build()).build();

    private static final SdkField<List<RequestOutputItem>> OUTPUTS_FIELD = SdkField
            .<List<RequestOutputItem>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(CreateChannelRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackMode").getter(getter(CreateChannelRequest::playbackModeAsString))
            .setter(setter(Builder::playbackMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(CreateChannelRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            FILLER_SLATE_FIELD, OUTPUTS_FIELD, PLAYBACK_MODE_FIELD, TAGS_FIELD, TIER_FIELD));

    private final String channelName;

    private final SlateSource fillerSlate;

    private final List<RequestOutputItem> outputs;

    private final String playbackMode;

    private final Map<String, String> tags;

    private final String tier;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.fillerSlate = builder.fillerSlate;
        this.outputs = builder.outputs;
        this.playbackMode = builder.playbackMode;
        this.tags = builder.tags;
        this.tier = builder.tier;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel
     * uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate for channels
     * using the <code>LOOP</code> <code>PlaybackMode</code>.
     * </p>
     * 
     * @return The slate used to fill gaps between programs in the schedule. You must configure filler slate if your
     *         channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate
     *         for channels using the <code>LOOP</code> <code>PlaybackMode</code>.
     */
    public final SlateSource fillerSlate() {
        return fillerSlate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channel's output properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The channel's output properties.
     */
    public final List<RequestOutputItem> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The type of playback mode to use for this channel.
     * </p>
     * <p>
     * <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
     * </p>
     * <p>
     * <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last program in
     * the schedule stops playing, playback loops back to the first program in the schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playbackMode} will
     * return {@link PlaybackMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playbackModeAsString}.
     * </p>
     * 
     * @return The type of playback mode to use for this channel.</p>
     *         <p>
     *         <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
     *         </p>
     *         <p>
     *         <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last
     *         program in the schedule stops playing, playback loops back to the first program in the schedule.
     * @see PlaybackMode
     */
    public final PlaybackMode playbackMode() {
        return PlaybackMode.fromValue(playbackMode);
    }

    /**
     * <p>
     * The type of playback mode to use for this channel.
     * </p>
     * <p>
     * <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
     * </p>
     * <p>
     * <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last program in
     * the schedule stops playing, playback loops back to the first program in the schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playbackMode} will
     * return {@link PlaybackMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #playbackModeAsString}.
     * </p>
     * 
     * @return The type of playback mode to use for this channel.</p>
     *         <p>
     *         <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
     *         </p>
     *         <p>
     *         <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last
     *         program in the schedule stops playing, playback loops back to the first program in the schedule.
     * @see PlaybackMode
     */
    public final String playbackModeAsString() {
        return playbackMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to help
     * with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources
     *         to help with organization, access control, and cost tracking. For more information, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     *         Resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The tier of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the channel.
     * @see Tier
     */
    public final Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The tier of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the channel.
     * @see Tier
     */
    public final String tierAsString() {
        return tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(fillerSlate());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(playbackModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(fillerSlate(), other.fillerSlate())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(playbackModeAsString(), other.playbackModeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(tierAsString(), other.tierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelRequest").add("ChannelName", channelName()).add("FillerSlate", fillerSlate())
                .add("Outputs", hasOutputs() ? outputs() : null).add("PlaybackMode", playbackModeAsString())
                .add("Tags", hasTags() ? tags() : null).add("Tier", tierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "FillerSlate":
            return Optional.ofNullable(clazz.cast(fillerSlate()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "PlaybackMode":
            return Optional.ofNullable(clazz.cast(playbackModeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param channelName
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel
         * uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate for channels
         * using the <code>LOOP</code> <code>PlaybackMode</code>.
         * </p>
         * 
         * @param fillerSlate
         *        The slate used to fill gaps between programs in the schedule. You must configure filler slate if your
         *        channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler
         *        slate for channels using the <code>LOOP</code> <code>PlaybackMode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillerSlate(SlateSource fillerSlate);

        /**
         * <p>
         * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel
         * uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate for channels
         * using the <code>LOOP</code> <code>PlaybackMode</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlateSource.Builder} avoiding the need to
         * create one manually via {@link SlateSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlateSource.Builder#build()} is called immediately and its result
         * is passed to {@link #fillerSlate(SlateSource)}.
         * 
         * @param fillerSlate
         *        a consumer that will call methods on {@link SlateSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fillerSlate(SlateSource)
         */
        default Builder fillerSlate(Consumer<SlateSource.Builder> fillerSlate) {
            return fillerSlate(SlateSource.builder().applyMutation(fillerSlate).build());
        }

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * 
         * @param outputs
         *        The channel's output properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<RequestOutputItem> outputs);

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * 
         * @param outputs
         *        The channel's output properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(RequestOutputItem... outputs);

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<RequestOutputItem>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<RequestOutputItem>)
         */
        Builder outputs(Consumer<RequestOutputItem.Builder>... outputs);

        /**
         * <p>
         * The type of playback mode to use for this channel.
         * </p>
         * <p>
         * <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
         * </p>
         * <p>
         * <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last program
         * in the schedule stops playing, playback loops back to the first program in the schedule.
         * </p>
         * 
         * @param playbackMode
         *        The type of playback mode to use for this channel.</p>
         *        <p>
         *        <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
         *        </p>
         *        <p>
         *        <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last
         *        program in the schedule stops playing, playback loops back to the first program in the schedule.
         * @see PlaybackMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaybackMode
         */
        Builder playbackMode(String playbackMode);

        /**
         * <p>
         * The type of playback mode to use for this channel.
         * </p>
         * <p>
         * <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
         * </p>
         * <p>
         * <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last program
         * in the schedule stops playing, playback loops back to the first program in the schedule.
         * </p>
         * 
         * @param playbackMode
         *        The type of playback mode to use for this channel.</p>
         *        <p>
         *        <code>LINEAR</code> - The programs in the schedule play once back-to-back in the schedule.
         *        </p>
         *        <p>
         *        <code>LOOP</code> - The programs in the schedule play back-to-back in an endless loop. When the last
         *        program in the schedule stops playing, playback loops back to the first program in the schedule.
         * @see PlaybackMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlaybackMode
         */
        Builder playbackMode(PlaybackMode playbackMode);

        /**
         * <p>
         * The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon resources to
         * help with organization, access control, and cost tracking. For more information, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the channel. Tags are key-value pairs that you can associate with Amazon
         *        resources to help with organization, access control, and cost tracking. For more information, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental
         *        MediaTailor Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The tier of the channel.
         * </p>
         * 
         * @param tier
         *        The tier of the channel.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier of the channel.
         * </p>
         * 
         * @param tier
         *        The tier of the channel.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private String channelName;

        private SlateSource fillerSlate;

        private List<RequestOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();

        private String playbackMode;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            channelName(model.channelName);
            fillerSlate(model.fillerSlate);
            outputs(model.outputs);
            playbackMode(model.playbackMode);
            tags(model.tags);
            tier(model.tier);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final SlateSource.Builder getFillerSlate() {
            return fillerSlate != null ? fillerSlate.toBuilder() : null;
        }

        public final void setFillerSlate(SlateSource.BuilderImpl fillerSlate) {
            this.fillerSlate = fillerSlate != null ? fillerSlate.build() : null;
        }

        @Override
        public final Builder fillerSlate(SlateSource fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        public final List<RequestOutputItem.Builder> getOutputs() {
            List<RequestOutputItem.Builder> result = RequestOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<RequestOutputItem.BuilderImpl> outputs) {
            this.outputs = RequestOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<RequestOutputItem> outputs) {
            this.outputs = RequestOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(RequestOutputItem... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<RequestOutputItem.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> RequestOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlaybackMode() {
            return playbackMode;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        @Override
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        @Override
        public final Builder playbackMode(PlaybackMode playbackMode) {
            this.playbackMode(playbackMode == null ? null : playbackMode.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
