/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListVodSourcesResponse;
import software.amazon.awssdk.services.mediatailor.model.VodSource;

public class ListVodSourcesPublisher
implements SdkPublisher<ListVodSourcesResponse> {
    private final MediaTailorAsyncClient client;
    private final ListVodSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVodSourcesPublisher(MediaTailorAsyncClient client, ListVodSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVodSourcesPublisher(MediaTailorAsyncClient client, ListVodSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVodSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVodSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VodSource> items() {
        Function<ListVodSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVodSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVodSourcesResponseFetcher
    implements AsyncPageFetcher<ListVodSourcesResponse> {
        private ListVodSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListVodSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVodSourcesResponse> nextPage(ListVodSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListVodSourcesPublisher.this.client.listVodSources(ListVodSourcesPublisher.this.firstRequest);
            }
            return ListVodSourcesPublisher.this.client.listVodSources((ListVodSourcesRequest)((Object)ListVodSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

