/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Copy image set information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyImageSetInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<CopyImageSetInformation.Builder, CopyImageSetInformation> {
    private static final SdkField<CopySourceImageSetInformation> SOURCE_IMAGE_SET_FIELD = SdkField
            .<CopySourceImageSetInformation> builder(MarshallingType.SDK_POJO).memberName("sourceImageSet")
            .getter(getter(CopyImageSetInformation::sourceImageSet)).setter(setter(Builder::sourceImageSet))
            .constructor(CopySourceImageSetInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImageSet").build()).build();

    private static final SdkField<CopyDestinationImageSet> DESTINATION_IMAGE_SET_FIELD = SdkField
            .<CopyDestinationImageSet> builder(MarshallingType.SDK_POJO).memberName("destinationImageSet")
            .getter(getter(CopyImageSetInformation::destinationImageSet)).setter(setter(Builder::destinationImageSet))
            .constructor(CopyDestinationImageSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationImageSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_SET_FIELD,
            DESTINATION_IMAGE_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final CopySourceImageSetInformation sourceImageSet;

    private final CopyDestinationImageSet destinationImageSet;

    private CopyImageSetInformation(BuilderImpl builder) {
        this.sourceImageSet = builder.sourceImageSet;
        this.destinationImageSet = builder.destinationImageSet;
    }

    /**
     * <p>
     * The source image set.
     * </p>
     * 
     * @return The source image set.
     */
    public final CopySourceImageSetInformation sourceImageSet() {
        return sourceImageSet;
    }

    /**
     * <p>
     * The destination image set.
     * </p>
     * 
     * @return The destination image set.
     */
    public final CopyDestinationImageSet destinationImageSet() {
        return destinationImageSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageSet());
        hashCode = 31 * hashCode + Objects.hashCode(destinationImageSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageSetInformation)) {
            return false;
        }
        CopyImageSetInformation other = (CopyImageSetInformation) obj;
        return Objects.equals(sourceImageSet(), other.sourceImageSet())
                && Objects.equals(destinationImageSet(), other.destinationImageSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyImageSetInformation").add("SourceImageSet", sourceImageSet())
                .add("DestinationImageSet", destinationImageSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceImageSet":
            return Optional.ofNullable(clazz.cast(sourceImageSet()));
        case "destinationImageSet":
            return Optional.ofNullable(clazz.cast(destinationImageSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyImageSetInformation, T> g) {
        return obj -> g.apply((CopyImageSetInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyImageSetInformation> {
        /**
         * <p>
         * The source image set.
         * </p>
         * 
         * @param sourceImageSet
         *        The source image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageSet(CopySourceImageSetInformation sourceImageSet);

        /**
         * <p>
         * The source image set.
         * </p>
         * This is a convenience method that creates an instance of the {@link CopySourceImageSetInformation.Builder}
         * avoiding the need to create one manually via {@link CopySourceImageSetInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopySourceImageSetInformation.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceImageSet(CopySourceImageSetInformation)}.
         * 
         * @param sourceImageSet
         *        a consumer that will call methods on {@link CopySourceImageSetInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceImageSet(CopySourceImageSetInformation)
         */
        default Builder sourceImageSet(Consumer<CopySourceImageSetInformation.Builder> sourceImageSet) {
            return sourceImageSet(CopySourceImageSetInformation.builder().applyMutation(sourceImageSet).build());
        }

        /**
         * <p>
         * The destination image set.
         * </p>
         * 
         * @param destinationImageSet
         *        The destination image set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationImageSet(CopyDestinationImageSet destinationImageSet);

        /**
         * <p>
         * The destination image set.
         * </p>
         * This is a convenience method that creates an instance of the {@link CopyDestinationImageSet.Builder} avoiding
         * the need to create one manually via {@link CopyDestinationImageSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CopyDestinationImageSet.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationImageSet(CopyDestinationImageSet)}.
         * 
         * @param destinationImageSet
         *        a consumer that will call methods on {@link CopyDestinationImageSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationImageSet(CopyDestinationImageSet)
         */
        default Builder destinationImageSet(Consumer<CopyDestinationImageSet.Builder> destinationImageSet) {
            return destinationImageSet(CopyDestinationImageSet.builder().applyMutation(destinationImageSet).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CopySourceImageSetInformation sourceImageSet;

        private CopyDestinationImageSet destinationImageSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageSetInformation model) {
            sourceImageSet(model.sourceImageSet);
            destinationImageSet(model.destinationImageSet);
        }

        public final CopySourceImageSetInformation.Builder getSourceImageSet() {
            return sourceImageSet != null ? sourceImageSet.toBuilder() : null;
        }

        public final void setSourceImageSet(CopySourceImageSetInformation.BuilderImpl sourceImageSet) {
            this.sourceImageSet = sourceImageSet != null ? sourceImageSet.build() : null;
        }

        @Override
        public final Builder sourceImageSet(CopySourceImageSetInformation sourceImageSet) {
            this.sourceImageSet = sourceImageSet;
            return this;
        }

        public final CopyDestinationImageSet.Builder getDestinationImageSet() {
            return destinationImageSet != null ? destinationImageSet.toBuilder() : null;
        }

        public final void setDestinationImageSet(CopyDestinationImageSet.BuilderImpl destinationImageSet) {
            this.destinationImageSet = destinationImageSet != null ? destinationImageSet.build() : null;
        }

        @Override
        public final Builder destinationImageSet(CopyDestinationImageSet destinationImageSet) {
            this.destinationImageSet = destinationImageSet;
            return this;
        }

        @Override
        public CopyImageSetInformation build() {
            return new CopyImageSetInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
