/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search input attribute value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchByAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchByAttributeValue.Builder, SearchByAttributeValue> {
    private static final SdkField<String> DICOM_PATIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMPatientId").getter(getter(SearchByAttributeValue::dicomPatientId))
            .setter(setter(Builder::dicomPatientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMPatientId").build()).build();

    private static final SdkField<String> DICOM_ACCESSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMAccessionNumber").getter(getter(SearchByAttributeValue::dicomAccessionNumber))
            .setter(setter(Builder::dicomAccessionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMAccessionNumber").build())
            .build();

    private static final SdkField<String> DICOM_STUDY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyId").getter(getter(SearchByAttributeValue::dicomStudyId))
            .setter(setter(Builder::dicomStudyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyId").build()).build();

    private static final SdkField<String> DICOM_STUDY_INSTANCE_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DICOMStudyInstanceUID").getter(getter(SearchByAttributeValue::dicomStudyInstanceUID))
            .setter(setter(Builder::dicomStudyInstanceUID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyInstanceUID").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SearchByAttributeValue::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<DICOMStudyDateAndTime> DICOM_STUDY_DATE_AND_TIME_FIELD = SdkField
            .<DICOMStudyDateAndTime> builder(MarshallingType.SDK_POJO).memberName("DICOMStudyDateAndTime")
            .getter(getter(SearchByAttributeValue::dicomStudyDateAndTime)).setter(setter(Builder::dicomStudyDateAndTime))
            .constructor(DICOMStudyDateAndTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMStudyDateAndTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DICOM_PATIENT_ID_FIELD,
            DICOM_ACCESSION_NUMBER_FIELD, DICOM_STUDY_ID_FIELD, DICOM_STUDY_INSTANCE_UID_FIELD, CREATED_AT_FIELD,
            DICOM_STUDY_DATE_AND_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dicomPatientId;

    private final String dicomAccessionNumber;

    private final String dicomStudyId;

    private final String dicomStudyInstanceUID;

    private final Instant createdAt;

    private final DICOMStudyDateAndTime dicomStudyDateAndTime;

    private final Type type;

    private SearchByAttributeValue(BuilderImpl builder) {
        this.dicomPatientId = builder.dicomPatientId;
        this.dicomAccessionNumber = builder.dicomAccessionNumber;
        this.dicomStudyId = builder.dicomStudyId;
        this.dicomStudyInstanceUID = builder.dicomStudyInstanceUID;
        this.createdAt = builder.createdAt;
        this.dicomStudyDateAndTime = builder.dicomStudyDateAndTime;
        this.type = builder.type;
    }

    /**
     * <p>
     * The patient ID input for search.
     * </p>
     * 
     * @return The patient ID input for search.
     */
    public final String dicomPatientId() {
        return dicomPatientId;
    }

    /**
     * <p>
     * The DICOM accession number for search.
     * </p>
     * 
     * @return The DICOM accession number for search.
     */
    public final String dicomAccessionNumber() {
        return dicomAccessionNumber;
    }

    /**
     * <p>
     * The DICOM study ID for search.
     * </p>
     * 
     * @return The DICOM study ID for search.
     */
    public final String dicomStudyId() {
        return dicomStudyId;
    }

    /**
     * <p>
     * The DICOM study instance UID for search.
     * </p>
     * 
     * @return The DICOM study instance UID for search.
     */
    public final String dicomStudyInstanceUID() {
        return dicomStudyInstanceUID;
    }

    /**
     * <p>
     * The created at time of the image set provided for search.
     * </p>
     * 
     * @return The created at time of the image set provided for search.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The aggregated structure containing DICOM study date and study time for search.
     * </p>
     * 
     * @return The aggregated structure containing DICOM study date and study time for search.
     */
    public final DICOMStudyDateAndTime dicomStudyDateAndTime() {
        return dicomStudyDateAndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dicomPatientId());
        hashCode = 31 * hashCode + Objects.hashCode(dicomAccessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyId());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyInstanceUID());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dicomStudyDateAndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchByAttributeValue)) {
            return false;
        }
        SearchByAttributeValue other = (SearchByAttributeValue) obj;
        return Objects.equals(dicomPatientId(), other.dicomPatientId())
                && Objects.equals(dicomAccessionNumber(), other.dicomAccessionNumber())
                && Objects.equals(dicomStudyId(), other.dicomStudyId())
                && Objects.equals(dicomStudyInstanceUID(), other.dicomStudyInstanceUID())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(dicomStudyDateAndTime(), other.dicomStudyDateAndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchByAttributeValue")
                .add("DICOMPatientId", dicomPatientId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMAccessionNumber", dicomAccessionNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyId", dicomStudyId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DICOMStudyInstanceUID", dicomStudyInstanceUID() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedAt", createdAt()).add("DICOMStudyDateAndTime", dicomStudyDateAndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DICOMPatientId":
            return Optional.ofNullable(clazz.cast(dicomPatientId()));
        case "DICOMAccessionNumber":
            return Optional.ofNullable(clazz.cast(dicomAccessionNumber()));
        case "DICOMStudyId":
            return Optional.ofNullable(clazz.cast(dicomStudyId()));
        case "DICOMStudyInstanceUID":
            return Optional.ofNullable(clazz.cast(dicomStudyInstanceUID()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DICOMStudyDateAndTime":
            return Optional.ofNullable(clazz.cast(dicomStudyDateAndTime()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dicomPatientId()} initialized to the given value.
     *
     * <p>
     * The patient ID input for search.
     * </p>
     * 
     * @param dicomPatientId
     *        The patient ID input for search.
     */
    public static SearchByAttributeValue fromDicomPatientId(String dicomPatientId) {
        return builder().dicomPatientId(dicomPatientId).build();
    }

    /**
     * Create an instance of this class with {@link #dicomAccessionNumber()} initialized to the given value.
     *
     * <p>
     * The DICOM accession number for search.
     * </p>
     * 
     * @param dicomAccessionNumber
     *        The DICOM accession number for search.
     */
    public static SearchByAttributeValue fromDicomAccessionNumber(String dicomAccessionNumber) {
        return builder().dicomAccessionNumber(dicomAccessionNumber).build();
    }

    /**
     * Create an instance of this class with {@link #dicomStudyId()} initialized to the given value.
     *
     * <p>
     * The DICOM study ID for search.
     * </p>
     * 
     * @param dicomStudyId
     *        The DICOM study ID for search.
     */
    public static SearchByAttributeValue fromDicomStudyId(String dicomStudyId) {
        return builder().dicomStudyId(dicomStudyId).build();
    }

    /**
     * Create an instance of this class with {@link #dicomStudyInstanceUID()} initialized to the given value.
     *
     * <p>
     * The DICOM study instance UID for search.
     * </p>
     * 
     * @param dicomStudyInstanceUID
     *        The DICOM study instance UID for search.
     */
    public static SearchByAttributeValue fromDicomStudyInstanceUID(String dicomStudyInstanceUID) {
        return builder().dicomStudyInstanceUID(dicomStudyInstanceUID).build();
    }

    /**
     * Create an instance of this class with {@link #createdAt()} initialized to the given value.
     *
     * <p>
     * The created at time of the image set provided for search.
     * </p>
     * 
     * @param createdAt
     *        The created at time of the image set provided for search.
     */
    public static SearchByAttributeValue fromCreatedAt(Instant createdAt) {
        return builder().createdAt(createdAt).build();
    }

    /**
     * Create an instance of this class with {@link #dicomStudyDateAndTime()} initialized to the given value.
     *
     * <p>
     * The aggregated structure containing DICOM study date and study time for search.
     * </p>
     * 
     * @param dicomStudyDateAndTime
     *        The aggregated structure containing DICOM study date and study time for search.
     */
    public static SearchByAttributeValue fromDicomStudyDateAndTime(DICOMStudyDateAndTime dicomStudyDateAndTime) {
        return builder().dicomStudyDateAndTime(dicomStudyDateAndTime).build();
    }

    /**
     * Create an instance of this class with {@link #dicomStudyDateAndTime()} initialized to the given value.
     *
     * <p>
     * The aggregated structure containing DICOM study date and study time for search.
     * </p>
     * 
     * @param dicomStudyDateAndTime
     *        The aggregated structure containing DICOM study date and study time for search.
     */
    public static SearchByAttributeValue fromDicomStudyDateAndTime(Consumer<DICOMStudyDateAndTime.Builder> dicomStudyDateAndTime) {
        DICOMStudyDateAndTime.Builder builder = DICOMStudyDateAndTime.builder();
        dicomStudyDateAndTime.accept(builder);
        return fromDicomStudyDateAndTime(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchByAttributeValue, T> g) {
        return obj -> g.apply((SearchByAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchByAttributeValue> {
        /**
         * <p>
         * The patient ID input for search.
         * </p>
         * 
         * @param dicomPatientId
         *        The patient ID input for search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomPatientId(String dicomPatientId);

        /**
         * <p>
         * The DICOM accession number for search.
         * </p>
         * 
         * @param dicomAccessionNumber
         *        The DICOM accession number for search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomAccessionNumber(String dicomAccessionNumber);

        /**
         * <p>
         * The DICOM study ID for search.
         * </p>
         * 
         * @param dicomStudyId
         *        The DICOM study ID for search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyId(String dicomStudyId);

        /**
         * <p>
         * The DICOM study instance UID for search.
         * </p>
         * 
         * @param dicomStudyInstanceUID
         *        The DICOM study instance UID for search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyInstanceUID(String dicomStudyInstanceUID);

        /**
         * <p>
         * The created at time of the image set provided for search.
         * </p>
         * 
         * @param createdAt
         *        The created at time of the image set provided for search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The aggregated structure containing DICOM study date and study time for search.
         * </p>
         * 
         * @param dicomStudyDateAndTime
         *        The aggregated structure containing DICOM study date and study time for search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dicomStudyDateAndTime(DICOMStudyDateAndTime dicomStudyDateAndTime);

        /**
         * <p>
         * The aggregated structure containing DICOM study date and study time for search.
         * </p>
         * This is a convenience method that creates an instance of the {@link DICOMStudyDateAndTime.Builder} avoiding
         * the need to create one manually via {@link DICOMStudyDateAndTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DICOMStudyDateAndTime.Builder#build()} is called immediately and
         * its result is passed to {@link #dicomStudyDateAndTime(DICOMStudyDateAndTime)}.
         * 
         * @param dicomStudyDateAndTime
         *        a consumer that will call methods on {@link DICOMStudyDateAndTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dicomStudyDateAndTime(DICOMStudyDateAndTime)
         */
        default Builder dicomStudyDateAndTime(Consumer<DICOMStudyDateAndTime.Builder> dicomStudyDateAndTime) {
            return dicomStudyDateAndTime(DICOMStudyDateAndTime.builder().applyMutation(dicomStudyDateAndTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dicomPatientId;

        private String dicomAccessionNumber;

        private String dicomStudyId;

        private String dicomStudyInstanceUID;

        private Instant createdAt;

        private DICOMStudyDateAndTime dicomStudyDateAndTime;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchByAttributeValue model) {
            dicomPatientId(model.dicomPatientId);
            dicomAccessionNumber(model.dicomAccessionNumber);
            dicomStudyId(model.dicomStudyId);
            dicomStudyInstanceUID(model.dicomStudyInstanceUID);
            createdAt(model.createdAt);
            dicomStudyDateAndTime(model.dicomStudyDateAndTime);
        }

        public final String getDicomPatientId() {
            return dicomPatientId;
        }

        public final void setDicomPatientId(String dicomPatientId) {
            Object oldValue = this.dicomPatientId;
            this.dicomPatientId = dicomPatientId;
            handleUnionValueChange(Type.DICOM_PATIENT_ID, oldValue, this.dicomPatientId);
        }

        @Override
        public final Builder dicomPatientId(String dicomPatientId) {
            Object oldValue = this.dicomPatientId;
            this.dicomPatientId = dicomPatientId;
            handleUnionValueChange(Type.DICOM_PATIENT_ID, oldValue, this.dicomPatientId);
            return this;
        }

        public final String getDicomAccessionNumber() {
            return dicomAccessionNumber;
        }

        public final void setDicomAccessionNumber(String dicomAccessionNumber) {
            Object oldValue = this.dicomAccessionNumber;
            this.dicomAccessionNumber = dicomAccessionNumber;
            handleUnionValueChange(Type.DICOM_ACCESSION_NUMBER, oldValue, this.dicomAccessionNumber);
        }

        @Override
        public final Builder dicomAccessionNumber(String dicomAccessionNumber) {
            Object oldValue = this.dicomAccessionNumber;
            this.dicomAccessionNumber = dicomAccessionNumber;
            handleUnionValueChange(Type.DICOM_ACCESSION_NUMBER, oldValue, this.dicomAccessionNumber);
            return this;
        }

        public final String getDicomStudyId() {
            return dicomStudyId;
        }

        public final void setDicomStudyId(String dicomStudyId) {
            Object oldValue = this.dicomStudyId;
            this.dicomStudyId = dicomStudyId;
            handleUnionValueChange(Type.DICOM_STUDY_ID, oldValue, this.dicomStudyId);
        }

        @Override
        public final Builder dicomStudyId(String dicomStudyId) {
            Object oldValue = this.dicomStudyId;
            this.dicomStudyId = dicomStudyId;
            handleUnionValueChange(Type.DICOM_STUDY_ID, oldValue, this.dicomStudyId);
            return this;
        }

        public final String getDicomStudyInstanceUID() {
            return dicomStudyInstanceUID;
        }

        public final void setDicomStudyInstanceUID(String dicomStudyInstanceUID) {
            Object oldValue = this.dicomStudyInstanceUID;
            this.dicomStudyInstanceUID = dicomStudyInstanceUID;
            handleUnionValueChange(Type.DICOM_STUDY_INSTANCE_UID, oldValue, this.dicomStudyInstanceUID);
        }

        @Override
        public final Builder dicomStudyInstanceUID(String dicomStudyInstanceUID) {
            Object oldValue = this.dicomStudyInstanceUID;
            this.dicomStudyInstanceUID = dicomStudyInstanceUID;
            handleUnionValueChange(Type.DICOM_STUDY_INSTANCE_UID, oldValue, this.dicomStudyInstanceUID);
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            Object oldValue = this.createdAt;
            this.createdAt = createdAt;
            handleUnionValueChange(Type.CREATED_AT, oldValue, this.createdAt);
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            Object oldValue = this.createdAt;
            this.createdAt = createdAt;
            handleUnionValueChange(Type.CREATED_AT, oldValue, this.createdAt);
            return this;
        }

        public final DICOMStudyDateAndTime.Builder getDicomStudyDateAndTime() {
            return dicomStudyDateAndTime != null ? dicomStudyDateAndTime.toBuilder() : null;
        }

        public final void setDicomStudyDateAndTime(DICOMStudyDateAndTime.BuilderImpl dicomStudyDateAndTime) {
            Object oldValue = this.dicomStudyDateAndTime;
            this.dicomStudyDateAndTime = dicomStudyDateAndTime != null ? dicomStudyDateAndTime.build() : null;
            handleUnionValueChange(Type.DICOM_STUDY_DATE_AND_TIME, oldValue, this.dicomStudyDateAndTime);
        }

        @Override
        public final Builder dicomStudyDateAndTime(DICOMStudyDateAndTime dicomStudyDateAndTime) {
            Object oldValue = this.dicomStudyDateAndTime;
            this.dicomStudyDateAndTime = dicomStudyDateAndTime;
            handleUnionValueChange(Type.DICOM_STUDY_DATE_AND_TIME, oldValue, this.dicomStudyDateAndTime);
            return this;
        }

        @Override
        public SearchByAttributeValue build() {
            return new SearchByAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SearchByAttributeValue#type()
     */
    public enum Type {
        DICOM_PATIENT_ID,

        DICOM_ACCESSION_NUMBER,

        DICOM_STUDY_ID,

        DICOM_STUDY_INSTANCE_UID,

        CREATED_AT,

        DICOM_STUDY_DATE_AND_TIME,

        UNKNOWN_TO_SDK_VERSION
    }
}
