/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medicalimaging.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImageSetMetadataResponse extends MedicalImagingResponse implements
        ToCopyableBuilder<UpdateImageSetMetadataResponse.Builder, UpdateImageSetMetadataResponse> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreId").getter(getter(UpdateImageSetMetadataResponse::datastoreId))
            .setter(setter(Builder::datastoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()).build();

    private static final SdkField<String> IMAGE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetId").getter(getter(UpdateImageSetMetadataResponse::imageSetId))
            .setter(setter(Builder::imageSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetId").build()).build();

    private static final SdkField<String> LATEST_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestVersionId").getter(getter(UpdateImageSetMetadataResponse::latestVersionId))
            .setter(setter(Builder::latestVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersionId").build()).build();

    private static final SdkField<String> IMAGE_SET_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetState").getter(getter(UpdateImageSetMetadataResponse::imageSetStateAsString))
            .setter(setter(Builder::imageSetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetState").build()).build();

    private static final SdkField<String> IMAGE_SET_WORKFLOW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSetWorkflowStatus").getter(getter(UpdateImageSetMetadataResponse::imageSetWorkflowStatusAsString))
            .setter(setter(Builder::imageSetWorkflowStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSetWorkflowStatus").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(UpdateImageSetMetadataResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(UpdateImageSetMetadataResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(UpdateImageSetMetadataResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD,
            IMAGE_SET_ID_FIELD, LATEST_VERSION_ID_FIELD, IMAGE_SET_STATE_FIELD, IMAGE_SET_WORKFLOW_STATUS_FIELD,
            CREATED_AT_FIELD, UPDATED_AT_FIELD, MESSAGE_FIELD));

    private final String datastoreId;

    private final String imageSetId;

    private final String latestVersionId;

    private final String imageSetState;

    private final String imageSetWorkflowStatus;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String message;

    private UpdateImageSetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreId = builder.datastoreId;
        this.imageSetId = builder.imageSetId;
        this.latestVersionId = builder.latestVersionId;
        this.imageSetState = builder.imageSetState;
        this.imageSetWorkflowStatus = builder.imageSetWorkflowStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.message = builder.message;
    }

    /**
     * <p>
     * The data store identifier.
     * </p>
     * 
     * @return The data store identifier.
     */
    public final String datastoreId() {
        return datastoreId;
    }

    /**
     * <p>
     * The image set identifier.
     * </p>
     * 
     * @return The image set identifier.
     */
    public final String imageSetId() {
        return imageSetId;
    }

    /**
     * <p>
     * The latest image set version identifier.
     * </p>
     * 
     * @return The latest image set version identifier.
     */
    public final String latestVersionId() {
        return latestVersionId;
    }

    /**
     * <p>
     * The image set state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state.
     * @see ImageSetState
     */
    public final ImageSetState imageSetState() {
        return ImageSetState.fromValue(imageSetState);
    }

    /**
     * <p>
     * The image set state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSetState}
     * will return {@link ImageSetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageSetStateAsString}.
     * </p>
     * 
     * @return The image set state.
     * @see ImageSetState
     */
    public final String imageSetStateAsString() {
        return imageSetState;
    }

    /**
     * <p>
     * The image set workflow status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The image set workflow status.
     * @see ImageSetWorkflowStatus
     */
    public final ImageSetWorkflowStatus imageSetWorkflowStatus() {
        return ImageSetWorkflowStatus.fromValue(imageSetWorkflowStatus);
    }

    /**
     * <p>
     * The image set workflow status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageSetWorkflowStatus} will return {@link ImageSetWorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageSetWorkflowStatusAsString}.
     * </p>
     * 
     * @return The image set workflow status.
     * @see ImageSetWorkflowStatus
     */
    public final String imageSetWorkflowStatusAsString() {
        return imageSetWorkflowStatus;
    }

    /**
     * <p>
     * The timestamp when image set metadata was created.
     * </p>
     * 
     * @return The timestamp when image set metadata was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when image set metadata was updated.
     * </p>
     * 
     * @return The timestamp when image set metadata was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The error message thrown if an update image set metadata action fails.
     * </p>
     * 
     * @return The error message thrown if an update image set metadata action fails.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetId());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageSetWorkflowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageSetMetadataResponse)) {
            return false;
        }
        UpdateImageSetMetadataResponse other = (UpdateImageSetMetadataResponse) obj;
        return Objects.equals(datastoreId(), other.datastoreId()) && Objects.equals(imageSetId(), other.imageSetId())
                && Objects.equals(latestVersionId(), other.latestVersionId())
                && Objects.equals(imageSetStateAsString(), other.imageSetStateAsString())
                && Objects.equals(imageSetWorkflowStatusAsString(), other.imageSetWorkflowStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImageSetMetadataResponse").add("DatastoreId", datastoreId())
                .add("ImageSetId", imageSetId()).add("LatestVersionId", latestVersionId())
                .add("ImageSetState", imageSetStateAsString()).add("ImageSetWorkflowStatus", imageSetWorkflowStatusAsString())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreId":
            return Optional.ofNullable(clazz.cast(datastoreId()));
        case "imageSetId":
            return Optional.ofNullable(clazz.cast(imageSetId()));
        case "latestVersionId":
            return Optional.ofNullable(clazz.cast(latestVersionId()));
        case "imageSetState":
            return Optional.ofNullable(clazz.cast(imageSetStateAsString()));
        case "imageSetWorkflowStatus":
            return Optional.ofNullable(clazz.cast(imageSetWorkflowStatusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageSetMetadataResponse, T> g) {
        return obj -> g.apply((UpdateImageSetMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MedicalImagingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateImageSetMetadataResponse> {
        /**
         * <p>
         * The data store identifier.
         * </p>
         * 
         * @param datastoreId
         *        The data store identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreId(String datastoreId);

        /**
         * <p>
         * The image set identifier.
         * </p>
         * 
         * @param imageSetId
         *        The image set identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSetId(String imageSetId);

        /**
         * <p>
         * The latest image set version identifier.
         * </p>
         * 
         * @param latestVersionId
         *        The latest image set version identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionId(String latestVersionId);

        /**
         * <p>
         * The image set state.
         * </p>
         * 
         * @param imageSetState
         *        The image set state.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(String imageSetState);

        /**
         * <p>
         * The image set state.
         * </p>
         * 
         * @param imageSetState
         *        The image set state.
         * @see ImageSetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetState
         */
        Builder imageSetState(ImageSetState imageSetState);

        /**
         * <p>
         * The image set workflow status.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The image set workflow status.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(String imageSetWorkflowStatus);

        /**
         * <p>
         * The image set workflow status.
         * </p>
         * 
         * @param imageSetWorkflowStatus
         *        The image set workflow status.
         * @see ImageSetWorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSetWorkflowStatus
         */
        Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus);

        /**
         * <p>
         * The timestamp when image set metadata was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when image set metadata was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when image set metadata was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when image set metadata was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The error message thrown if an update image set metadata action fails.
         * </p>
         * 
         * @param message
         *        The error message thrown if an update image set metadata action fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl extends MedicalImagingResponse.BuilderImpl implements Builder {
        private String datastoreId;

        private String imageSetId;

        private String latestVersionId;

        private String imageSetState;

        private String imageSetWorkflowStatus;

        private Instant createdAt;

        private Instant updatedAt;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageSetMetadataResponse model) {
            super(model);
            datastoreId(model.datastoreId);
            imageSetId(model.imageSetId);
            latestVersionId(model.latestVersionId);
            imageSetState(model.imageSetState);
            imageSetWorkflowStatus(model.imageSetWorkflowStatus);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            message(model.message);
        }

        public final String getDatastoreId() {
            return datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getImageSetId() {
            return imageSetId;
        }

        public final void setImageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
        }

        @Override
        public final Builder imageSetId(String imageSetId) {
            this.imageSetId = imageSetId;
            return this;
        }

        public final String getLatestVersionId() {
            return latestVersionId;
        }

        public final void setLatestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(String latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final String getImageSetState() {
            return imageSetState;
        }

        public final void setImageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
        }

        @Override
        public final Builder imageSetState(String imageSetState) {
            this.imageSetState = imageSetState;
            return this;
        }

        @Override
        public final Builder imageSetState(ImageSetState imageSetState) {
            this.imageSetState(imageSetState == null ? null : imageSetState.toString());
            return this;
        }

        public final String getImageSetWorkflowStatus() {
            return imageSetWorkflowStatus;
        }

        public final void setImageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
        }

        @Override
        public final Builder imageSetWorkflowStatus(String imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus = imageSetWorkflowStatus;
            return this;
        }

        @Override
        public final Builder imageSetWorkflowStatus(ImageSetWorkflowStatus imageSetWorkflowStatus) {
            this.imageSetWorkflowStatus(imageSetWorkflowStatus == null ? null : imageSetWorkflowStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public UpdateImageSetMetadataResponse build() {
            return new UpdateImageSetMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
