/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.medicalimaging.endpoints.MedicalImagingEndpointParams;
import software.amazon.awssdk.services.medicalimaging.endpoints.MedicalImagingEndpointProvider;
import software.amazon.awssdk.services.medicalimaging.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class MedicalImagingResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        MedicalImagingEndpointProvider provider = (MedicalImagingEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(MedicalImagingResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = MedicalImagingResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static MedicalImagingEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        MedicalImagingEndpointParams.Builder builder = MedicalImagingEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        MedicalImagingResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        MedicalImagingResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        return builder.build();
    }

    private static void setContextParams(MedicalImagingEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(MedicalImagingEndpointParams.Builder params, String operationName) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "CopyImageSet": {
                return Optional.of("runtime-");
            }
            case "DeleteImageSet": {
                return Optional.of("runtime-");
            }
            case "GetImageFrame": {
                return Optional.of("runtime-");
            }
            case "GetImageSet": {
                return Optional.of("runtime-");
            }
            case "GetImageSetMetadata": {
                return Optional.of("runtime-");
            }
            case "ListImageSetVersions": {
                return Optional.of("runtime-");
            }
            case "SearchImageSets": {
                return Optional.of("runtime-");
            }
            case "UpdateImageSetMetadata": {
                return Optional.of("runtime-");
            }
        }
        return Optional.empty();
    }
}

